/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.settings.impl;

import java.lang.constant.Constable;
import java.util.Map;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.jpa.BaseTest;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.settings.jpa.JPASettingServiceImpl;
import org.exoplatform.settings.jpa.SettingContextDAO;
import org.exoplatform.settings.jpa.SettingScopeDAO;
import org.exoplatform.settings.jpa.SettingsDAO;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.settings-configuration-local.xml")})
public class JPASettingServiceImplTest
extends BaseTest {
    protected JPASettingServiceImpl settingService;
    protected SettingContextDAO contextDAO;
    protected SettingScopeDAO scopeDAO;
    protected SettingsDAO settingsDAO;

    @Override
    public void setUp() {
        super.setUp();
        this.settingService = this.getService(JPASettingServiceImpl.class);
        this.contextDAO = this.getService(SettingContextDAO.class);
        this.scopeDAO = this.getService(SettingScopeDAO.class);
        this.settingsDAO = this.getService(SettingsDAO.class);
        this.settingsDAO.deleteAll();
        this.contextDAO.deleteAll();
        this.scopeDAO.deleteAll();
        ConversationState c = new ConversationState(new Identity("root"));
        ConversationState.setCurrent((ConversationState)c);
    }

    @Override
    protected void tearDown() {
        this.settingsDAO.deleteAll();
        this.contextDAO.deleteAll();
        this.scopeDAO.deleteAll();
    }

    public void testUserSimple() {
        this.settingService.set(Context.USER.id("foo"), Scope.SPACE, "a", SettingValue.create((String)"b"));
        JPASettingServiceImplTest.assertEquals((Object)"b", (Object)this.settingService.get(Context.USER.id("foo"), Scope.SPACE, "a").getValue());
        this.settingService.set(Context.USER, Scope.SPACE.id("name"), "a", SettingValue.create((Long)new Long(789L)));
        Constable value = Long.parseLong(this.settingService.get(Context.USER, Scope.SPACE.id("name"), "a").getValue().toString());
        JPASettingServiceImplTest.assertEquals((Object)value, (Object)new Long(789L));
        this.settingService.set(Context.USER.id("foo"), Scope.SPACE.id("name"), "a", SettingValue.create((Double)new Double(4.5)));
        value = Double.parseDouble(this.settingService.get(Context.USER.id("foo"), Scope.SPACE.id("name"), "a").getValue().toString());
        JPASettingServiceImplTest.assertEquals((Object)value, (Object)new Double(4.5));
        this.settingService.set(Context.USER.id("foo"), Scope.SPACE.id("name"), "a", SettingValue.create((Boolean)true));
        value = Boolean.valueOf(Boolean.parseBoolean(this.settingService.get(Context.USER.id("foo"), Scope.SPACE.id("name"), "a").getValue().toString()));
        JPASettingServiceImplTest.assertEquals((Object)value, (Object)true);
    }

    public void testGlobalSimple() {
        this.settingService.set(Context.GLOBAL, Scope.SPACE, "a", SettingValue.create((String)"b"));
        JPASettingServiceImplTest.assertEquals((Object)"b", (Object)this.settingService.get(Context.GLOBAL, Scope.SPACE, "a").getValue());
    }

    public void testUserNamed() {
        this.settingService.set(Context.USER.id("foo"), Scope.SPACE.id("name"), "a", SettingValue.create((String)"b"));
        JPASettingServiceImplTest.assertEquals((Object)"b", (Object)this.settingService.get(Context.USER.id("foo"), Scope.SPACE.id("name"), "a").getValue());
    }

    public void testGlobalNamed() {
        this.settingService.set(Context.GLOBAL, Scope.SPACE.id("name"), "a", SettingValue.create((String)"b"));
        JPASettingServiceImplTest.assertEquals((Object)"b", (Object)this.settingService.get(Context.GLOBAL, Scope.SPACE.id("name"), "a").getValue());
    }

    public void testRemoveSimple() {
        this.settingService.set(Context.USER.id("foo"), Scope.SPACE, "a", SettingValue.create((String)"b"));
        JPASettingServiceImplTest.assertEquals((Object)"b", (Object)this.settingService.get(Context.USER.id("foo"), Scope.SPACE, "a").getValue());
        this.settingService.remove(Context.USER.id("foo"), Scope.SPACE, "a");
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.USER.id("foo"), Scope.SPACE, "a"));
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name"), "x", SettingValue.create((String)"y"));
        JPASettingServiceImplTest.assertEquals((Object)"y", (Object)this.settingService.get(Context.GLOBAL, Scope.PAGE.id("name"), "x").getValue());
        this.settingService.remove(Context.GLOBAL, Scope.PAGE.id("name"), "x");
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.GLOBAL, Scope.PAGE.id("name"), "x"));
    }

    public void testRemovePage() {
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x2", SettingValue.create((String)"y2"));
        JPASettingServiceImplTest.assertEquals((Object)this.settingService.get(Context.GLOBAL, Scope.PAGE.id("name1"), "x1").getValue(), (Object)"y1");
        JPASettingServiceImplTest.assertEquals((Object)this.settingService.get(Context.GLOBAL, Scope.PAGE.id("name1"), "x2").getValue(), (Object)"y2");
        this.settingService.remove(Context.GLOBAL, Scope.PAGE.id("name1"));
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.GLOBAL, Scope.PAGE.id("name1"), "x1"));
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.GLOBAL, Scope.PAGE.id("name1"), "x2"));
    }

    public void testRemoveUser() {
        this.settingService.set(Context.USER, Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.USER, Scope.PORTAL.id("name2"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER, Scope.PAGE.id("name3"), "x3", SettingValue.create((String)"y3"));
        this.settingService.set(Context.USER, Scope.PAGE.id("name4"), "x4", SettingValue.create((String)"y4"));
        JPASettingServiceImplTest.assertEquals((Object)this.settingService.get(Context.USER, Scope.PORTAL.id("name1"), "x1").getValue(), (Object)"y1");
        JPASettingServiceImplTest.assertEquals((Object)this.settingService.get(Context.USER, Scope.PORTAL.id("name2"), "x2").getValue(), (Object)"y2");
        JPASettingServiceImplTest.assertEquals((Object)this.settingService.get(Context.USER, Scope.PAGE.id("name3"), "x3").getValue(), (Object)"y3");
        JPASettingServiceImplTest.assertEquals((Object)this.settingService.get(Context.USER, Scope.PAGE.id("name4"), "x4").getValue(), (Object)"y4");
        this.settingService.remove(Context.USER);
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.USER, Scope.PORTAL.id("name1"), "x1"));
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.USER, Scope.PORTAL.id("name2"), "x2"));
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.USER, Scope.PAGE.id("name3"), "x3"));
        JPASettingServiceImplTest.assertNull((Object)this.settingService.get(Context.USER, Scope.PAGE.id("name4"), "x4"));
    }

    public void testCountSettingsByNameAndValueAndScope() {
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x1", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user3"), Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        JPASettingServiceImplTest.assertEquals((float)1.0f, (float)this.settingService.countSettingsByNameAndValueAndScope(Scope.PAGE.id("name2"), "x1", "y1"), (float)1.0f);
        JPASettingServiceImplTest.assertEquals((float)1.0f, (float)this.settingService.countSettingsByNameAndValueAndScope(Scope.PAGE.id("name1"), "x1", "y2"), (float)1.0f);
        JPASettingServiceImplTest.assertEquals((float)1.0f, (float)this.settingService.countSettingsByNameAndValueAndScope(Scope.PAGE.id("name2"), "x1", "y3"), (float)1.0f);
        JPASettingServiceImplTest.assertEquals((float)1.0f, (float)this.settingService.countSettingsByNameAndValueAndScope(Scope.PAGE.id("name2"), "x2", "x2"), (float)1.0f);
    }

    public void testGetContextsByTypeAndScopeAndSettingName() {
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x1", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user3"), Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PAGE.getName(), "name2", "x1", 0, 10).size());
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PAGE.getName(), "name1", "x1", 0, 10).size());
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PAGE.getName(), "name2", "x2", 0, 10).size());
    }

    public void testGetSettingsByContext() {
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x1", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user3"), Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getSettingsByContext(Context.USER.id("user1")).size());
        JPASettingServiceImplTest.assertEquals((int)2, (int)((Map)this.settingService.getSettingsByContext(Context.USER.id("user1")).get(Scope.PAGE.id("name1"))).size());
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getSettingsByContext(Context.USER.id("user2")).size());
        JPASettingServiceImplTest.assertEquals((int)2, (int)((Map)this.settingService.getSettingsByContext(Context.USER.id("user2")).get(Scope.PAGE.id("name2"))).size());
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getSettingsByContext(Context.USER.id("user3")).size());
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getSettingsByContext(Context.GLOBAL).size());
        JPASettingServiceImplTest.assertEquals((int)0, (int)this.settingService.getSettingsByContext(Context.GLOBAL.id("user1")).size());
    }

    public void testGetEmptyContextsByScopeAndContextType() {
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.USER.id("user1"), Scope.PAGE.id("name1"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user2"), Scope.PAGE.id("name2"), "x2", SettingValue.create((String)"y2"));
        this.settingService.set(Context.USER.id("user3"), Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        this.settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        JPASettingServiceImplTest.assertEquals((int)3, (int)this.settingService.getEmptyContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PORTAL.getName(), null, "x1", 0, 10).size());
        JPASettingServiceImplTest.assertEquals((int)2, (int)this.settingService.getEmptyContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PORTAL.getName(), "name1", "x1", 0, 10).size());
        JPASettingServiceImplTest.assertEquals((int)1, (int)this.settingService.getEmptyContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PAGE.getName(), "name1", "x1", 0, 10).size());
        JPASettingServiceImplTest.assertEquals((int)2, (int)this.settingService.getEmptyContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.PAGE.getName(), "name2", "x2", 0, 10).size());
    }
}

