/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa.dao.mock;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.settings.jpa.SettingContextDAO;
import org.exoplatform.settings.jpa.dao.mock.InMemorySettingsDAO;
import org.exoplatform.settings.jpa.entity.ContextEntity;

public class InMemorySettingContextDAO
extends AbstractInMemoryDAO<ContextEntity>
implements SettingContextDAO {
    private InMemorySettingsDAO memorySettingsDAO;

    public InMemorySettingContextDAO(InMemorySettingsDAO memorySettingsDAO) {
        this.memorySettingsDAO = memorySettingsDAO;
    }

    public ContextEntity getContextByTypeAndName(String contextType, String contextName) {
        return this.entities.values().stream().filter(entity -> !(!StringUtils.isBlank((CharSequence)contextName) && !StringUtils.equals((CharSequence)contextName, (CharSequence)entity.getName()) || !StringUtils.isBlank((CharSequence)contextType) && !StringUtils.equals((CharSequence)contextType, (CharSequence)entity.getType()))).findFirst().orElse(null);
    }

    public List<ContextEntity> getEmptyContextsByScopeAndContextType(String contextType, String scopeType, String scopeName, String settingName, int offset, int limit) {
        Stream<ContextEntity> resultStream = this.entities.values().stream().filter(entity -> (StringUtils.isBlank((CharSequence)contextType) || StringUtils.equals((CharSequence)contextType, (CharSequence)entity.getType())) && this.isEmptyContext((ContextEntity)entity, scopeType, scopeName, settingName));
        if (limit > 0) {
            resultStream = resultStream.limit((long)offset + (long)limit);
        }
        List<Object> result = resultStream.toList();
        if (offset > 0) {
            result = result.size() > offset ? result.subList(offset, result.size()) : Collections.emptyList();
        }
        return result;
    }

    public List<ContextEntity> getContextsByTypeAndSettingNameAndScope(String contextType, String scopeType, String scopeName, String settingName, int offset, int limit) {
        Stream<ContextEntity> resultStream = this.entities.values().stream().filter(entity -> (StringUtils.isBlank((CharSequence)contextType) || StringUtils.equals((CharSequence)contextType, (CharSequence)entity.getType())) && this.memorySettingsDAO.getSettingByContextAndScopeAndKey(entity.getType(), entity.getName(), scopeType, scopeName, settingName) != null);
        if (limit > 0) {
            resultStream = resultStream.limit((long)offset + (long)limit);
        }
        List<Object> result = resultStream.toList();
        if (offset > 0) {
            result = result.size() > offset ? result.subList(offset, result.size()) : Collections.emptyList();
        }
        return result;
    }

    public long countContextsByType(String contextType) {
        return this.entities.values().stream().filter(entity -> StringUtils.isBlank((CharSequence)contextType) || StringUtils.equals((CharSequence)contextType, (CharSequence)entity.getType())).count();
    }

    public List<String> getContextNamesByType(String contextType, int offset, int limit) {
        return this.entities.values().stream().filter(entity -> StringUtils.isBlank((CharSequence)contextType) || StringUtils.equals((CharSequence)contextType, (CharSequence)entity.getType())).map(ContextEntity::getName).distinct().toList();
    }

    private boolean isEmptyContext(ContextEntity context, String scopeType, String scopeName, String settingName) {
        if (StringUtils.isBlank((CharSequence)scopeName)) {
            return this.memorySettingsDAO.getSettingsByContextTypeAndName(context.getType(), context.getName()).stream().filter(setting -> setting.getScope() != null && StringUtils.equals((CharSequence)setting.getScope().getType(), (CharSequence)scopeType) && StringUtils.isBlank((CharSequence)setting.getScope().getName()) && StringUtils.equals((CharSequence)setting.getName(), (CharSequence)settingName)).count() == 0L;
        }
        return this.memorySettingsDAO.getSettingByContextAndScopeAndKey(context.getType(), context.getName(), scopeType, scopeName, settingName) == null;
    }
}

