/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax;

import java.util.Collection;
import org.gatein.common.xml.stax.XmlHandler;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.staxnav.StaxNavigator;

public abstract class CollectionXmlHandler<T, N>
implements XmlHandler<Collection<T>, N> {
    private final N collectionName;
    private final N itemName;

    public CollectionXmlHandler(N collectionName, N itemName) {
        this.collectionName = collectionName;
        this.itemName = itemName;
    }

    @Override
    public Collection<T> read(StaxNavigator<N> navigator) {
        if (!navigator.getName().equals(this.collectionName)) {
            throw Exceptions.expectedElement(navigator, this.collectionName);
        }
        Collection<T> collection = this.createCollection();
        Object element = navigator.child();
        while (element != null) {
            if (!element.equals(this.itemName)) {
                throw Exceptions.expectedElement(navigator, this.itemName);
            }
            collection.add(this.readElement(navigator.fork()));
            element = navigator.sibling();
        }
        return collection;
    }

    @Override
    public void write(StaxWriter<N> writer, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        writer.writeStartElement(this.collectionName);
        for (T element : collection) {
            this.writeElement(writer, element);
        }
        writer.writeEndElement();
    }

    protected abstract T readElement(StaxNavigator<N> var1);

    protected abstract void writeElement(StaxWriter<N> var1, T var2);

    protected abstract Collection<T> createCollection();
}

