/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import junit.framework.TestCase;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterImpl;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.formatting.XmlStreamingFormatter;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.staxnav.Naming;

public abstract class AbstractStaxWriterTest<N>
extends TestCase {
    static final String ENCODING = "UTF-8";
    static final String VERSION = "1.0";
    private Naming<N> naming;
    protected XMLStreamWriter stream;
    protected XmlStreamingFormatter formatter;
    protected StaxWriter<N> writer;

    public abstract Naming<N> getNaming();

    public void setUp() throws Exception {
        this.naming = this.getNaming();
        this.formatter = (XmlStreamingFormatter)Mockito.mock(XmlStreamingFormatter.class);
        this.stream = (XMLStreamWriter)Mockito.mock(XMLStreamWriter.class);
        this.writer = new StaxWriterImpl(this.naming, this.stream, this.formatter, ENCODING, VERSION);
    }

    protected N createName(String localPart) {
        return (N)this.naming.getName(null, null, localPart);
    }

    public void testEncodingAndVersion() throws Exception {
        String encoding = ENCODING;
        String version = VERSION;
        StaxWriterImpl writer = new StaxWriterImpl(this.naming, this.stream, this.formatter, encoding, version);
        writer.writeElement(this.createName("foo"), "blah");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartDocument(encoding, version);
        Mockito.reset((Object[])new XMLStreamWriter[]{this.stream});
        encoding = "encoding";
        version = "version";
        writer = new StaxWriterImpl(this.naming, this.stream, this.formatter, encoding, version);
        writer.writeElement(this.createName("foo"), "blah");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartDocument(encoding, version);
    }

    public void testEncoding() throws Exception {
        String encoding = "ISO-8859-1";
        StaxWriterImpl writer = new StaxWriterImpl(this.naming, this.stream, this.formatter, encoding, null);
        writer.writeElement(this.createName("foo"), "blah");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartDocument(encoding, null);
    }

    public void testNoEncoding() throws Exception {
        StaxWriterImpl writer = new StaxWriterImpl(this.naming, this.stream, this.formatter);
        writer.writeElement(this.createName("foo"), "blah");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartDocument();
    }

    public void testStartDocument() throws Exception {
        this.writer.writeStartElement(this.createName("foo"));
        this.writer.writeComment("some comment");
        this.writer.writeCData("some cdata < & ...");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)1))).writeStartDocument(ENCODING, VERSION);
    }

    public void testWriteStartElement() throws Exception {
        this.writer.writeStartElement(this.createName("foo"));
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartElement("foo");
    }

    public void testWriteAttribute() throws Exception {
        this.writer.writeStartElement(this.createName("foo")).writeAttribute("name", "value");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeAttribute("name", "value");
    }

    public void testWriteQNameAttribute() throws Exception {
        this.writer.writeStartElement(this.createName("foo")).writeAttribute(new QName("uri", "local", "pre"), "value").writeAttribute(new QName("uri", "local"), "value");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeAttribute("pre", "uri", "local", "value");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeAttribute("uri", "local", "value");
    }

    public void testWriteElement() throws Exception {
        this.writer.writeElement(this.createName("foo"), "content");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartElement("foo");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeCharacters("content");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeEndElement();
    }

    public void testWriteContent() throws Exception {
        this.writer.writeStartElement(this.createName("foo")).writeContent("blah");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeCharacters("blah");
        WritableValueType<String> vt = new WritableValueType<String>(this){

            public String format(String value) {
                return "some value";
            }
        };
        this.writer.writeStartElement(this.createName("bar")).writeContent((WritableValueType)vt, (Object)"content");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeCharacters("some value");
    }

    public void testWriteNullContent() throws Exception {
        try {
            this.writer.writeContent(null);
            AbstractStaxWriterTest.fail((String)"IllegalArgumentException expected to be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNamespace() throws Exception {
        this.writer.writeStartElement(this.createName("foo")).writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public void testDefaultNamespace() throws Exception {
        String namespace = "http://www.example.com/ns/mynamespace";
        this.writer.writeStartElement(this.createName("foo")).writeDefaultNamespace(namespace);
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeDefaultNamespace(namespace);
    }

    public void testComment() throws Exception {
        this.writer.writeComment("Some comment");
        this.writer.writeStartElement(this.createName("foo"));
        ((XMLStreamWriter)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)1))).writeStartDocument(ENCODING, VERSION);
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeComment("Some comment");
    }

    public void testCData() throws Exception {
        String cdata = "Some cdata stuff here < & \" ";
        this.writer.writeCData(cdata);
        this.writer.writeStartElement(this.createName("foo"));
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartDocument(ENCODING, VERSION);
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeCData(cdata);
    }

    public void testFinish() throws Exception {
        this.writer.writeStartElement(this.createName("foo")).finish();
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).flush();
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).close();
    }

    public void testFinishNoElements() throws Exception {
        this.writer.writeComment("comment");
        this.writer.finish();
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).flush();
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).close();
    }

    public void testEndElementOnFinish() throws Exception {
        this.writer.writeStartElement(this.createName("foo")).writeStartElement(this.createName("bar")).writeElement(this.createName("foobar"), "stuff");
        this.writer.finish();
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartElement("foo");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartElement("bar");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeStartElement("foobar");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream)).writeCharacters("stuff");
        ((XMLStreamWriter)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)3))).writeEndElement();
    }

    public void testFormatter() throws Exception {
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.formatter, this.stream});
        this.writer.writeStartElement(this.createName("foo"));
        this.verifyFormatter(order, 7, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeStartDocument(AbstractStaxWriterTest.ENCODING, AbstractStaxWriterTest.VERSION);
            }
        });
        this.verifyFormatter(order, 1, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeStartElement("foo");
            }
        });
        this.writer.writeNamespace("prefix", "uri");
        this.verifyFormatter(order, 13, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeNamespace("prefix", "uri");
            }
        });
        this.writer.writeDefaultNamespace("uri");
        this.verifyFormatter(order, 13, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeDefaultNamespace("uri");
            }
        });
        this.writer.writeAttribute("name", "value");
        this.verifyFormatter(order, 10, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeAttribute("name", "value");
            }
        });
        this.writer.writeComment("comment");
        this.verifyFormatter(order, 5, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeComment("comment");
            }
        });
        this.writer.writeCData("cdata");
        this.verifyFormatter(order, 12, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeCData("cdata");
            }
        });
        this.writer.writeContent("content");
        this.verifyFormatter(order, 4, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeCharacters("content");
            }
        });
        this.writer.writeEndElement();
        this.verifyFormatter(order, 2, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeEndElement();
            }
        });
        this.writer.finish();
        this.verifyFormatter(order, 8, new VerifyClosure(){

            @Override
            public void verify(InOrder order) throws Exception {
                ((XMLStreamWriter)order.verify((Object)AbstractStaxWriterTest.this.stream)).writeEndDocument();
            }
        });
    }

    protected void verifyFormatter(InOrder order, int event, VerifyClosure closure) throws Exception {
        ((XmlStreamingFormatter)order.verify((Object)this.formatter)).before(this.stream, event);
        closure.verify(order);
        ((XmlStreamingFormatter)order.verify((Object)this.formatter)).after(this.stream, event);
    }

    private static interface VerifyClosure {
        public void verify(InOrder var1) throws Exception;
    }
}

