/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.I18N;

public class TestI18N
extends TestCase {
    public void testToRFC1766() {
        TestI18N.assertEquals((String)"en", (String)I18N.toTagIdentifier((Locale)Locale.ENGLISH));
        TestI18N.assertEquals((String)"en-GB", (String)I18N.toTagIdentifier((Locale)Locale.UK));
        TestI18N.assertEquals((String)"en-GB", (String)I18N.toTagIdentifier((Locale)new Locale("en", "GB", "ab")));
        try {
            I18N.toTagIdentifier(null);
            TestI18N.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseRFC1766() {
        String[] incorrects;
        TestI18N.assertEquals((Object)Locale.ENGLISH, (Object)I18N.parseTagIdentifier((String)"en"));
        TestI18N.assertEquals((Object)Locale.UK, (Object)I18N.parseTagIdentifier((String)"en-GB"));
        for (String incorrect : incorrects = new String[]{"", " en ", "en_GB"}) {
            try {
                I18N.parseTagIdentifier((String)incorrect);
                TestI18N.fail((String)("Was expecting " + incorrect + " to not be parsed"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            I18N.parseTagIdentifier(null);
            TestI18N.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseJavaIdentifier() {
        this.assertJavaIdentifier(Locale.ENGLISH, "en");
        this.assertNotJavaIdentifier("e");
        this.assertNotJavaIdentifier("+e");
        this.assertNotJavaIdentifier("e+");
        this.assertNotJavaIdentifier("_");
        this.assertNotJavaIdentifier("en+");
        this.assertNotJavaIdentifier("en_");
        this.assertNotJavaIdentifier("en_G");
        this.assertNotJavaIdentifier("__");
        this.assertNotJavaIdentifier("en_+");
        this.assertNotJavaIdentifier("en_G+");
        this.assertJavaIdentifier(Locale.UK, "en_GB");
        this.assertNotJavaIdentifier("en__");
        this.assertNotJavaIdentifier("en_GB_");
        this.assertNotJavaIdentifier("__f");
        this.assertJavaIdentifier(new Locale("en", "", "f"), "en__f");
        this.assertJavaIdentifier(new Locale("", "GB", "f"), "_GB_f");
        this.assertJavaIdentifier(new Locale("fil", "", ""), "fil");
    }

    public void testDefaultLocales() {
        for (Locale expected : Locale.getAvailableLocales()) {
            String s = expected.toString();
            if (s.contains("#")) continue;
            Locale parsed = I18N.parseJavaIdentifier((String)s);
            TestI18N.assertEquals((Object)expected, (Object)parsed);
        }
    }

    private static boolean isJava6Compatible(Locale locale) {
        String expectedJava6LocaleId;
        boolean hasVariant;
        String foundLocaleId = locale.toString();
        if (foundLocaleId.isEmpty()) {
            return false;
        }
        StringBuilder localeIdBuilder = new StringBuilder(16);
        localeIdBuilder.append(locale.getLanguage());
        String country = locale.getCountry();
        boolean hasCountry = country != null && country.length() > 0;
        String variant = locale.getVariant();
        boolean bl = hasVariant = variant != null && variant.length() > 0;
        if (hasCountry || hasVariant) {
            localeIdBuilder.append('_');
            if (hasCountry) {
                localeIdBuilder.append(country);
            }
            if (hasVariant) {
                localeIdBuilder.append('_').append(variant);
            }
        }
        if ("ja_JP_JP".equals(expectedJava6LocaleId = localeIdBuilder.toString()) && "ja_JP_JP_#u-ca-japanese".equals(foundLocaleId)) {
            return true;
        }
        if ("th_TH_TH".equals(expectedJava6LocaleId) && "th_TH_TH_#u-nu-thai".equals(foundLocaleId)) {
            return true;
        }
        return expectedJava6LocaleId.equals(foundLocaleId);
    }

    private void assertNotJavaIdentifier(String s) {
        try {
            I18N.parseJavaIdentifier((String)s);
            TestI18N.fail((String)("Was expecting " + s + " to fail"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertJavaIdentifier(Locale expected, String s) {
        TestI18N.assertEquals((Object)expected, (Object)I18N.parseJavaIdentifier((String)s));
    }

    public void testGetParentLocale() {
        Locale l3 = new Locale("a", "b", "c");
        Locale l2 = new Locale("a", "b");
        Locale l1 = new Locale("a");
        TestI18N.assertEquals((Object)l2, (Object)I18N.getParent((Locale)l3));
        TestI18N.assertEquals((Object)l1, (Object)I18N.getParent((Locale)l2));
        TestI18N.assertEquals(null, (Object)I18N.getParent((Locale)l1));
        try {
            I18N.getParent(null);
            TestI18N.fail((String)"Was expecting an NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

