/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.download;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.MockDownloadResource;
import org.exoplatform.services.cache.ExoCache;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/services/download-service.xml")})
public class TestDownloadService
extends AbstractKernelTest {
    private DownloadService service;
    private ExoCache<String, DownloadResource> cache;

    protected void beforeRunBare() {
        super.beforeRunBare();
        this.service = (DownloadService)this.getContainer().getComponentInstanceOfType(DownloadService.class);
        this.cache = this.service.getCache();
    }

    @Test
    public void testMaxSizeEviction() {
        for (int i = 0; i < 20; ++i) {
            this.service.addDownloadResource((DownloadResource)new MockDownloadResource("" + i));
        }
        TestDownloadService.assertTrue((this.cache.getCacheSize() <= 10 ? 1 : 0) != 0);
        this.cache.clearCache();
    }

    @Test
    public void testCleanningOnGetting() {
        MockDownloadResource s = new MockDownloadResource("blah");
        this.service.addDownloadResource((DownloadResource)s);
        TestDownloadService.assertNotNull((Object)this.service.getDownloadResource("" + ((Object)((Object)s)).hashCode()));
        TestDownloadService.assertNull((Object)this.cache.get((Serializable)((Object)("" + ((Object)((Object)s)).hashCode()))));
        this.cache.clearCache();
    }

    @Test
    public void testMemoryLeakWithMultiThread() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                int i = counter.incrementAndGet();
                while (i < 100) {
                    TestDownloadService.this.service.addDownloadResource((DownloadResource)new MockDownloadResource("" + i));
                    i = counter.incrementAndGet();
                }
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                int i = counter.incrementAndGet();
                while (i < 100) {
                    TestDownloadService.this.service.addDownloadResource((DownloadResource)new MockDownloadResource("" + i));
                    i = counter.incrementAndGet();
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        TestDownloadService.assertTrue((this.cache.getCacheSize() <= 10 ? 1 : 0) != 0);
    }
}

