/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.writer;

import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.staxnav.StaxNavException;

public abstract class WritableValueTypes {
    public static final WritableValueType<String> STRING = new WritableValueType<String>(){

        @Override
        public String format(String value) throws StaxNavException {
            return value;
        }
    };
    public static final WritableValueType<String> TRIMMED_STRING = new WritableValueType<String>(){

        @Override
        public String format(String value) throws StaxNavException {
            return value.trim();
        }
    };
    public static final WritableValueType<Boolean> BOOLEAN = new WritableValueType<Boolean>(){

        @Override
        public String format(Boolean value) throws StaxNavException {
            return value.toString();
        }
    };
    public static final WritableValueType<Integer> INTEGER = new WritableValueType<Integer>(){

        @Override
        public String format(Integer value) throws StaxNavException {
            return value.toString();
        }
    };
    public static final WritableValueType<Date> DATE = new WritableValueType<Date>(){

        @Override
        public String format(Date value) throws StaxNavException {
            Calendar cal = Calendar.getInstance();
            cal.setTime(value);
            return DatatypeConverter.printDate((Calendar)cal);
        }
    };
    public static final WritableValueType<Date> DATE_TIME = new WritableValueType<Date>(){

        @Override
        public String format(Date value) throws StaxNavException {
            Calendar cal = Calendar.getInstance();
            cal.setTime(value);
            return DatatypeConverter.printDateTime((Calendar)cal);
        }
    };

    public static <E extends Enum<E>> WritableValueType<E> getEnumType() {
        return new EnumType();
    }

    protected static class EnumType<E extends Enum<E>>
    implements WritableValueType<E> {
        protected EnumType() {
        }

        @Override
        public String format(E value) throws StaxNavException {
            return ((Enum)value).name();
        }
    }
}

