/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.common.performance.model;

import io.meeds.common.performance.model.ServerResponseTimeItem;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ServerResponseTime {
    public static final boolean DEVELOPPING = PropertyManager.isDevelopping();
    public static final boolean SERVER_TIMING_ENABLED = DEVELOPPING || StringUtils.equals((CharSequence)System.getProperty("meeds.server.timing.api.enabled", "false"), (CharSequence)"true");
    private static final Log LOG = ExoLogger.getLogger((String)"ServerTimingAPI");
    private static final String OVERALL_KEY = "overall";
    private List<String> serverTimeNames = new Vector<String>();
    private Map<String, ServerResponseTimeItem> serverTimes = new LinkedHashMap<String, ServerResponseTimeItem>();

    public ServerResponseTime() {
        if (!SERVER_TIMING_ENABLED) {
            LOG.warn((Object)"Server Timing API Not enabled, please consider use it conditionally when (ServerResponseTime.SERVER_TIMING_ENABLED == true) only");
        }
    }

    public boolean startServerTime(String name) {
        if (!this.serverTimeNames.contains(name)) {
            long start = System.currentTimeMillis();
            ServerResponseTimeItem timeItem = this.serverTimes.computeIfAbsent(name, k -> new ServerResponseTimeItem(name, this.serverTimes.size()));
            timeItem.setStartTime(start);
            if (!this.serverTimeNames.isEmpty()) {
                String lastName = this.serverTimeNames.getLast();
                this.serverTimes.get(lastName).setPausedTime(start);
            }
            this.serverTimeNames.add(name);
            return true;
        }
        return false;
    }

    public void endServerTime(String name) {
        long end = System.currentTimeMillis();
        ServerResponseTimeItem timeItem = this.serverTimes.get(name);
        timeItem.setDuration(end - timeItem.getStartTime() - timeItem.getCumulativePausedTime());
        this.serverTimeNames.remove(name);
        if (!this.serverTimeNames.isEmpty()) {
            String lastName = this.serverTimeNames.getLast();
            ServerResponseTimeItem lastTimeItem = this.serverTimes.get(lastName);
            lastTimeItem.setCumulativePausedTime(lastTimeItem.getCumulativePausedTime() + end - lastTimeItem.getPausedTime());
        }
    }

    public void addHttpHeader(HttpServletResponse response) {
        if (response.isCommitted()) {
            LOG.warn((Object)"Can't add Server Timing Header since the response is already committed");
        } else {
            ServerResponseTimeItem overallTimeItem = new ServerResponseTimeItem(OVERALL_KEY, this.serverTimes.size());
            this.serverTimeNames.reversed().forEach(this::endServerTime);
            overallTimeItem.setDuration(this.serverTimes.values().stream().mapToLong(ServerResponseTimeItem::getDuration).sum());
            this.serverTimes.put(OVERALL_KEY, overallTimeItem);
            List<String> times = this.serverTimes.values().stream().map(e -> e.getName() + ";dur=" + e.getDuration()).toList();
            response.setHeader("Server-Timing", StringUtils.join(times, (String)","));
        }
    }

    @Generated
    public List<String> getServerTimeNames() {
        return this.serverTimeNames;
    }

    @Generated
    public Map<String, ServerResponseTimeItem> getServerTimes() {
        return this.serverTimes;
    }

    @Generated
    public void setServerTimeNames(List<String> serverTimeNames) {
        this.serverTimeNames = serverTimeNames;
    }

    @Generated
    public void setServerTimes(Map<String, ServerResponseTimeItem> serverTimes) {
        this.serverTimes = serverTimes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerResponseTime)) {
            return false;
        }
        ServerResponseTime other = (ServerResponseTime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$serverTimeNames = this.getServerTimeNames();
        List<String> other$serverTimeNames = other.getServerTimeNames();
        if (this$serverTimeNames == null ? other$serverTimeNames != null : !((Object)this$serverTimeNames).equals(other$serverTimeNames)) {
            return false;
        }
        Map<String, ServerResponseTimeItem> this$serverTimes = this.getServerTimes();
        Map<String, ServerResponseTimeItem> other$serverTimes = other.getServerTimes();
        return !(this$serverTimes == null ? other$serverTimes != null : !((Object)this$serverTimes).equals(other$serverTimes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServerResponseTime;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $serverTimeNames = this.getServerTimeNames();
        result = result * 59 + ($serverTimeNames == null ? 43 : ((Object)$serverTimeNames).hashCode());
        Map<String, ServerResponseTimeItem> $serverTimes = this.getServerTimes();
        result = result * 59 + ($serverTimes == null ? 43 : ((Object)$serverTimes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServerResponseTime(serverTimeNames=" + String.valueOf(this.getServerTimeNames()) + ", serverTimes=" + String.valueOf(this.getServerTimes()) + ")";
    }
}

