/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.commons.file.CommonsJPAIntegrationTest;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileInfoDAOTest
extends CommonsJPAIntegrationTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.fileInfoDAO.deleteAll();
        this.nameSpaceDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.fileInfoDAO.deleteAll();
        this.nameSpaceDAO.deleteAll();
    }

    @Test
    public void testFileInfoEntity() {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.create((Object)new NameSpaceEntity("file", "default namespace"));
        FileInfoEntity entity = new FileInfoEntity();
        entity.setName("MyDoc.doc");
        entity.setNameSpaceEntity(nameSpaceEntity);
        entity.setChecksum("1225445455");
        entity.setDeleted(false);
        entity.setMimetype("application/doc");
        entity.setSize(1L);
        entity.setUpdater("root");
        entity.setUpdatedDate(new Date());
        this.fileInfoDAO.create((Object)entity);
        List list = this.fileInfoDAO.findAll();
        FileInfoDAOTest.assertEquals((int)list.size(), (int)1);
        FileInfoEntity result = (FileInfoEntity)list.get(0);
        FileInfoDAOTest.assertEquals((String)result.getChecksum(), (String)"1225445455");
        FileInfoDAOTest.assertEquals((String)result.getName(), (String)"MyDoc.doc");
        FileInfoDAOTest.assertEquals((boolean)result.isDeleted(), (boolean)false);
    }

    public void testFindDeletedFile() {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.create((Object)new NameSpaceEntity("file", "default namespace"));
        FileInfoEntity entity1 = new FileInfoEntity();
        entity1.setName("MyDoc.doc");
        entity1.setNameSpaceEntity(nameSpaceEntity);
        entity1.setUpdatedDate(FileInfoDAOTest.daysAgo(70));
        this.fileInfoDAO.create((Object)entity1);
        FileInfoEntity entity2 = new FileInfoEntity();
        entity2.setName("MyDoc1.doc");
        entity2.setNameSpaceEntity(nameSpaceEntity);
        entity2.setDeleted(true);
        entity2.setUpdatedDate(FileInfoDAOTest.daysAgo(60));
        this.fileInfoDAO.create((Object)entity2);
        FileInfoEntity entity3 = new FileInfoEntity();
        entity3.setName("MyDoc2.doc");
        entity3.setNameSpaceEntity(nameSpaceEntity);
        entity3.setDeleted(true);
        entity3.setUpdatedDate(FileInfoDAOTest.daysAgo(15));
        this.fileInfoDAO.create((Object)entity3);
        List list = this.fileInfoDAO.findAll();
        FileInfoDAOTest.assertEquals((int)list.size(), (int)3);
        List list1 = this.fileInfoDAO.findDeletedFiles(FileInfoDAOTest.daysAgo(30));
        FileInfoDAOTest.assertEquals((int)1, (int)list1.size());
        FileInfoEntity fileInfoEntity = (FileInfoEntity)list1.get(0);
        FileInfoDAOTest.assertEquals((String)"MyDoc1.doc", (String)fileInfoEntity.getName());
    }

    public void testFindFilesByPage() {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.create((Object)new NameSpaceEntity("file", "default namespace"));
        ArrayList<FileInfoEntity> list = new ArrayList<FileInfoEntity>();
        for (int i = 0; i < 20; ++i) {
            FileInfoEntity entity = new FileInfoEntity();
            entity.setName("MyDoc_" + i + ".doc");
            entity.setNameSpaceEntity(nameSpaceEntity);
            entity.setUpdatedDate(FileInfoDAOTest.daysAgo(70));
            list.add(entity);
        }
        this.fileInfoDAO.createAll(list);
        List result = this.fileInfoDAO.findAllByPage(15, 10);
        FileInfoDAOTest.assertNotNull((Object)result);
        FileInfoDAOTest.assertEquals((int)5, (int)result.size());
    }

    private static Date daysAgo(int days) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.add(5, -days);
        return gc.getTime();
    }
}

