/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.FileSystemResourceProvider;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FileSystemBinaryProviderTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() throws Exception {
    }

    @Test
    public void shouldReadBinary() throws Exception {
    }

    @Test
    public void shouldWriteBinary() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileItem file = new FileItem(Long.valueOf(1L), "file1", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream(new byte[0]));
        fileResourceProvider.put(file.getFileInfo().getChecksum(), file.getAsStream());
        File createdFile = fileResourceProvider.getFile(file.getFileInfo().getChecksum());
        Assert.assertTrue((boolean)createdFile.exists());
    }

    @Test
    public void shouldWriteBinaryWhenFileAlreadyExistsAndBinaryHasChanged() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileItem file = new FileItem(Long.valueOf(1L), "file1", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        fileResourceProvider.put(file.getFileInfo().getChecksum(), file.getAsStream());
        File createdFile = fileResourceProvider.getFile(file.getFileInfo().getChecksum());
        Assert.assertTrue((boolean)createdFile.exists());
        file.setChecksum((InputStream)new ByteArrayInputStream("test-updated".getBytes()));
        fileResourceProvider.put(file.getFileInfo().getChecksum(), file.getAsStream());
        File updatedFile = fileResourceProvider.getFile(file.getFileInfo().getChecksum());
        Assert.assertThat((Object)updatedFile.getAbsolutePath(), (Matcher)Is.is((Matcher)IsNot.not((Object)createdFile.getAbsolutePath())));
    }

    @Test
    public void shouldNotWriteBinaryWhenFileAlreadyExistsAndBinaryHasNotChanged() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileItem file = new FileItem(Long.valueOf(1L), "file1", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        fileResourceProvider.put(file);
        File createdFile = new File(fileResourceProvider.getFilePath(file.getFileInfo()));
        Assert.assertTrue((boolean)createdFile.exists());
        fileResourceProvider.put(file);
        File updatedFile = new File(fileResourceProvider.getFilePath(file.getFileInfo()));
        Assert.assertEquals((Object)updatedFile.getAbsolutePath(), (Object)createdFile.getAbsolutePath());
    }

    @Test
    public void shouldDeleteBinary() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileItem file = new FileItem(Long.valueOf(1L), "file1", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        fileResourceProvider.put(file);
        File createdFile = new File(fileResourceProvider.getFilePath(file.getFileInfo()));
        Assert.assertTrue((boolean)createdFile.exists());
        fileResourceProvider.remove(file.getFileInfo());
        File deletedFile = new File(fileResourceProvider.getFilePath(file.getFileInfo()));
        Assert.assertFalse((boolean)deletedFile.exists());
    }

    @Test
    public void shouldThrowExceptionWhenDeletingABinaryWhichDoesNotExist() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileItem file = new FileItem(Long.valueOf(1L), "file1", "", null, 1L, null, "", false, (InputStream)new ByteArrayInputStream("test".getBytes()));
        this.exception.expect(FileNotFoundException.class);
        fileResourceProvider.remove(file.getFileInfo());
    }

    @Test
    public void shouldReturnPathWhenChecksumIsValid() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileInfo fileInfo = new FileInfo(Long.valueOf(1L), "file1", "", null, 1L, null, "", "d41d8cd98f00b204e9800998ecf8427e", false);
        String path = fileResourceProvider.getFilePath(fileInfo);
        Assert.assertEquals((Object)(this.folder.getRoot().getPath() + "/d/4/1/d/8/c/d/9/d41d8cd98f00b204e9800998ecf8427e"), (Object)path);
    }

    @Test
    public void shouldReturnNullWhenChecksumIsNotValid() throws Exception {
        FileSystemResourceProvider fileResourceProvider = new FileSystemResourceProvider(this.folder.getRoot().getPath());
        FileInfo fileInfo = new FileInfo(Long.valueOf(1L), "file1", "", null, 1L, null, "", "", false);
        String path = fileResourceProvider.getFilePath(fileInfo);
        Assert.assertNull((Object)path);
    }
}

