/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.dao;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.commons.file.CommonsJPAIntegrationTest;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;
import org.exoplatform.commons.file.storage.entity.OrphanFileEntity;
import org.junit.After;
import org.junit.Before;

public class OrphanFileDAOTest
extends CommonsJPAIntegrationTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.orphanFileDAO.deleteAll();
        this.fileInfoDAO.deleteAll();
        this.nameSpaceDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.orphanFileDAO.deleteAll();
        this.fileInfoDAO.deleteAll();
        this.nameSpaceDAO.deleteAll();
    }

    public void testFindDeletedFile() {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.create((Object)new NameSpaceEntity("file", "default namespace"));
        FileInfoEntity entity1 = new FileInfoEntity();
        entity1.setName("MyDoc.doc");
        entity1.setNameSpaceEntity(nameSpaceEntity);
        entity1.setUpdatedDate(OrphanFileDAOTest.daysAgo(70));
        this.fileInfoDAO.create((Object)entity1);
        List list = this.fileInfoDAO.findAll();
        OrphanFileDAOTest.assertEquals((int)list.size(), (int)1);
        OrphanFileEntity deletedFileEntity = new OrphanFileEntity();
        deletedFileEntity.setDeletedDate(OrphanFileDAOTest.daysAgo(60));
        deletedFileEntity.setFileInfoEntity(entity1);
        deletedFileEntity.setChecksum("d41d8cd98f00b204e9800998ecf8427e");
        this.orphanFileDAO.create((Object)deletedFileEntity);
        OrphanFileEntity deletedFileEntity1 = new OrphanFileEntity();
        deletedFileEntity1.setDeletedDate(OrphanFileDAOTest.daysAgo(10));
        deletedFileEntity1.setFileInfoEntity(entity1);
        deletedFileEntity1.setChecksum("d41d8cd98f00b204e9800998ecf88899");
        this.orphanFileDAO.create((Object)deletedFileEntity1);
        List list1 = this.orphanFileDAO.findDeletedFiles(OrphanFileDAOTest.daysAgo(30));
        OrphanFileDAOTest.assertEquals((int)1, (int)list1.size());
        OrphanFileEntity deletedFileEntity2 = (OrphanFileEntity)list1.get(0);
        OrphanFileDAOTest.assertEquals((String)"d41d8cd98f00b204e9800998ecf8427e", (String)deletedFileEntity2.getChecksum());
    }

    private static Date daysAgo(int days) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.add(5, -days);
        return gc.getTime();
    }
}

