/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.dao;

import java.util.Date;
import java.util.List;
import org.exoplatform.commons.file.CommonsJPAIntegrationTest;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileInfoDAOTest
extends CommonsJPAIntegrationTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.fileInfoDAO.deleteAll();
        this.nameSpaceDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.fileInfoDAO.deleteAll();
        this.nameSpaceDAO.deleteAll();
    }

    @Test
    public void testFileInfoEntity() {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.create((Object)new NameSpaceEntity("file", "default namespace"));
        FileInfoEntity entity = new FileInfoEntity();
        entity.setName("MyDoc.doc");
        entity.setNameSpaceEntity(nameSpaceEntity);
        entity.setChecksum("1225445455");
        entity.setMimetype("application/doc");
        entity.setSize(1L);
        entity.setUpdater("root");
        entity.setUpdatedDate(new Date());
        this.fileInfoDAO.create((Object)entity);
        List list = this.fileInfoDAO.findAll();
        FileInfoDAOTest.assertEquals((int)list.size(), (int)1);
        FileInfoEntity result = (FileInfoEntity)list.get(0);
        FileInfoDAOTest.assertEquals((String)result.getChecksum(), (String)"1225445455");
        FileInfoDAOTest.assertEquals((String)result.getName(), (String)"MyDoc.doc");
        FileInfoDAOTest.assertEquals((boolean)result.isDeleted(), (boolean)false);
        FileInfoDAOTest.assertEquals((int)1, (int)this.fileInfoDAO.countFilesByChecksum(entity.getChecksum()));
    }
}

