/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.file-storage-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/test-configuration.xml")})
public class FileServiceImplIntegrationTest
extends AbstractKernelTest {
    private ExecutorService executorService = Executors.newFixedThreadPool(3);
    private AtomicInteger counter = new AtomicInteger(0);

    protected void setUp() throws IOException {
        this.begin();
    }

    protected void tearDown() {
        this.end();
    }

    public void testShouldReturnFile() throws Exception {
        FileService fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        FileItem createdFile = fileService.writeFile(new FileItem(null, "file1", "plain/text", null, 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream("test".getBytes())));
        FileItem fetchedFile = fileService.getFile(createdFile.getFileInfo().getId().longValue());
        FileServiceImplIntegrationTest.assertNotNull((Object)fetchedFile);
        FileServiceImplIntegrationTest.assertEquals((String)"file1", (String)fetchedFile.getFileInfo().getName());
        FileServiceImplIntegrationTest.assertEquals((String)"plain/text", (String)fetchedFile.getFileInfo().getMimetype());
        FileServiceImplIntegrationTest.assertEquals((String)"john", (String)fetchedFile.getFileInfo().getUpdater());
        FileServiceImplIntegrationTest.assertEquals((boolean)false, (boolean)fetchedFile.getFileInfo().isDeleted());
        FileServiceImplIntegrationTest.assertEquals((long)1L, (long)fetchedFile.getFileInfo().getSize());
        FileServiceImplIntegrationTest.assertEquals((String)"file", (String)fetchedFile.getFileInfo().getNameSpace());
        InputStream fileStream = fetchedFile.getAsStream();
        FileServiceImplIntegrationTest.assertNotNull((Object)fileStream);
        FileServiceImplIntegrationTest.assertEquals((String)"test", (String)IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8));
    }

    public void testShouldReturnFilesByChecksum() throws Exception {
        FileService fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        FileItem createdFile1 = fileService.writeFile(new FileItem(null, "file1", "plain/text", null, 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream("test1".getBytes())));
        String file1Checksum = createdFile1.getFileInfo().getChecksum();
        FileItem createdFile2 = fileService.writeFile(new FileItem(null, "file2", "plain/text", null, 2L, new Date(), "root", false, (InputStream)new ByteArrayInputStream("test2".getBytes())));
        this.restartTransaction();
        List fetchedFiles = fileService.getFilesByChecksum(file1Checksum);
        FileServiceImplIntegrationTest.assertEquals((int)1, (int)fetchedFiles.size());
        FileServiceImplIntegrationTest.assertEquals((String)"file1", (String)((FileItem)fetchedFiles.get(0)).getFileInfo().getName());
        FileServiceImplIntegrationTest.assertEquals((String)"plain/text", (String)((FileItem)fetchedFiles.get(0)).getFileInfo().getMimetype());
        FileServiceImplIntegrationTest.assertEquals((String)"john", (String)((FileItem)fetchedFiles.get(0)).getFileInfo().getUpdater());
        FileServiceImplIntegrationTest.assertEquals((boolean)false, (boolean)((FileItem)fetchedFiles.get(0)).getFileInfo().isDeleted());
        FileServiceImplIntegrationTest.assertEquals((long)1L, (long)((FileItem)fetchedFiles.get(0)).getFileInfo().getSize());
        FileServiceImplIntegrationTest.assertEquals((String)"file", (String)((FileItem)fetchedFiles.get(0)).getFileInfo().getNameSpace());
        InputStream fileStream = ((FileItem)fetchedFiles.get(0)).getAsStream();
        FileServiceImplIntegrationTest.assertEquals((String)"test1", (String)IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8));
        fetchedFiles = fileService.getFilesByChecksum(createdFile2.getFileInfo().getChecksum());
        FileServiceImplIntegrationTest.assertEquals((int)1, (int)fetchedFiles.size());
    }

    public void testUpdateFile() throws Exception {
        FileService fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        FileItem createdFile = fileService.writeFile(new FileItem(null, "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream("test".getBytes())));
        FileItem fetchedFile = fileService.getFile(createdFile.getFileInfo().getId().longValue());
        FileServiceImplIntegrationTest.assertNotNull((Object)fetchedFile);
        FileItem updatedSameFile = fileService.updateFile(new FileItem(fetchedFile.getFileInfo().getId(), "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream("test".getBytes())));
        FileServiceImplIntegrationTest.assertNotNull((Object)updatedSameFile);
        FileServiceImplIntegrationTest.assertNotSame((Object)fetchedFile.getFileInfo().getChecksum(), (Object)updatedSameFile.getFileInfo().getChecksum());
        FileItem updatedNewFile = fileService.updateFile(new FileItem(fetchedFile.getFileInfo().getId(), "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream("New test".getBytes())));
        FileServiceImplIntegrationTest.assertNotNull((Object)updatedNewFile);
        FileServiceImplIntegrationTest.assertNotSame((Object)fetchedFile.getFileInfo().getChecksum(), (Object)updatedNewFile.getFileInfo().getChecksum());
    }

    public void testConcurrentAddFile() throws Exception {
        final FileService fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        BinaryProvider binaryProvider = (BinaryProvider)this.getContainer().getComponentInstanceOfType(BinaryProvider.class);
        final String text = "Concurrent add test" + System.currentTimeMillis();
        FileItem fileItem = fileService.writeFile(new FileItem(null, "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream(text.getBytes())));
        final Throwable error = null;
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ExoContainerContext.setCurrentContainer((ExoContainer)FileServiceImplIntegrationTest.this.getContainer());
                    FileServiceImplIntegrationTest.this.begin();
                    try {
                        fileService.writeFile(new FileItem(null, "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream(text.getBytes())));
                    }
                    catch (Throwable e) {
                        TestCase.fail((String)("Error while adding File: " + error.getMessage()));
                    }
                    finally {
                        FileServiceImplIntegrationTest.this.end();
                        FileServiceImplIntegrationTest.this.counter.incrementAndGet();
                    }
                }
            });
        }
        do {
            Thread.sleep(100L);
        } while (this.counter.get() < 10);
        File file = new File(binaryProvider.getFilePath(fileItem.getFileInfo().getChecksum()));
        FileServiceImplIntegrationTest.assertEquals((int)1, (int)file.getParentFile().list().length);
    }

    public void testConcurrentUpdateFile() throws Exception {
        final FileService fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        BinaryProvider binaryProvider = (BinaryProvider)this.getContainer().getComponentInstanceOfType(BinaryProvider.class);
        final String text = "Concurrent update test" + System.currentTimeMillis();
        final FileItem fileItem = fileService.writeFile(new FileItem(null, "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream(text.getBytes())));
        for (int i = 0; i < 10; ++i) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ExoContainerContext.setCurrentContainer((ExoContainer)FileServiceImplIntegrationTest.this.getContainer());
                    FileServiceImplIntegrationTest.this.begin();
                    try {
                        fileService.updateFile(new FileItem(fileItem.getFileInfo().getId(), "file1", "plain/text", "file", 1L, new Date(), "john", false, (InputStream)new ByteArrayInputStream(text.getBytes())));
                    }
                    catch (Throwable e) {
                        TestCase.fail((String)("Error while adding File: " + e.getMessage()));
                    }
                    finally {
                        FileServiceImplIntegrationTest.this.end();
                        FileServiceImplIntegrationTest.this.counter.incrementAndGet();
                    }
                }
            });
        }
        do {
            Thread.sleep(100L);
        } while (this.counter.get() < 10);
        File file = new File(binaryProvider.getFilePath(fileItem.getFileInfo().getChecksum()));
        FileServiceImplIntegrationTest.assertEquals((int)1, (int)file.getParentFile().list().length);
    }
}

