/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.storage;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.NameSpace;
import org.exoplatform.commons.file.storage.DataStorage$AjcClosure1;
import org.exoplatform.commons.file.storage.dao.FileInfoDAO;
import org.exoplatform.commons.file.storage.dao.NameSpaceDAO;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;

public class DataStorage {
    private FileInfoDAO fileInfoDAO;
    private NameSpaceDAO nameSpaceDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DataStorage(FileInfoDAO fileInfoDAO, NameSpaceDAO nameSpaceDAO) {
        this.fileInfoDAO = fileInfoDAO;
        this.nameSpaceDAO = nameSpaceDAO;
    }

    public FileInfo getFileInfo(long id) {
        FileInfoEntity fileInfoEntity = (FileInfoEntity)this.fileInfoDAO.find(Long.valueOf(id));
        return this.convertFileEntityToFileInfo(fileInfoEntity);
    }

    public List<FileInfo> getFileInfoListByChecksum(String checksum) {
        List<FileInfoEntity> result = this.fileInfoDAO.findFilesByChecksum(checksum);
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (FileInfoEntity fileInfoEntity : result) {
            fileInfoList.add(this.convertFileEntityToFileInfo(fileInfoEntity));
        }
        return fileInfoList;
    }

    public int sharedChecksum(String checksum) {
        return this.fileInfoDAO.countFilesByChecksum(checksum);
    }

    public NameSpace getNameSpace(long id) {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.find(Long.valueOf(id));
        return this.convertNameSpace(nameSpaceEntity);
    }

    @ExoTransactional
    public NameSpace getNameSpace(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        DataStorage$AjcClosure1 dataStorage$AjcClosure1 = new DataStorage$AjcClosure1(objectArray);
        return (NameSpace)ExoTransactionalAspect.aspectOf().around(dataStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void createNameSpaces(List<NameSpace> listNameSpace) {
        ArrayList<NameSpaceEntity> entityList = new ArrayList<NameSpaceEntity>();
        for (NameSpace s : listNameSpace) {
            NameSpaceEntity n = new NameSpaceEntity(s.getName(), s.getDescription());
            entityList.add(n);
        }
        this.nameSpaceDAO.createAll(entityList);
    }

    public NameSpace createNameSpace(NameSpace nameSpace) {
        NameSpaceEntity n = new NameSpaceEntity(nameSpace.getName(), nameSpace.getDescription());
        NameSpaceEntity createdNameSpace = (NameSpaceEntity)this.nameSpaceDAO.create(n);
        return this.convertNameSpace(createdNameSpace);
    }

    public FileInfo create(FileInfo fileInfo, NameSpace nameSpace) {
        if (fileInfo == null) {
            return null;
        }
        NameSpaceEntity nSpace = new NameSpaceEntity(nameSpace.getId(), nameSpace.getName(), nameSpace.getDescription());
        FileInfoEntity fileInfoEntity = new FileInfoEntity(fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.getChecksum(), fileInfo.isDeleted());
        fileInfoEntity.setNameSpaceEntity(nSpace);
        FileInfoEntity createdFile = (FileInfoEntity)this.fileInfoDAO.create(fileInfoEntity);
        return this.convertFileEntityToFileInfo(createdFile);
    }

    public FileInfo updateFileInfo(FileInfo fileInfo) {
        if (fileInfo == null) {
            return null;
        }
        FileInfoEntity fileInfoEntity = new FileInfoEntity(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.getChecksum(), fileInfo.isDeleted());
        NameSpaceEntity nsEntity = this.nameSpaceDAO.getNameSpaceByName(fileInfo.getNameSpace());
        fileInfoEntity.setNameSpaceEntity(nsEntity);
        FileInfoEntity updated = (FileInfoEntity)this.fileInfoDAO.update(fileInfoEntity);
        return this.convertFileEntityToFileInfo(updated);
    }

    public void deleteFileInfo(long id) {
        FileInfoEntity fileInfoEntity = (FileInfoEntity)this.fileInfoDAO.find(Long.valueOf(id));
        if (fileInfoEntity == null) {
            return;
        }
        this.fileInfoDAO.delete(fileInfoEntity);
    }

    private FileInfo convertFileEntityToFileInfo(FileInfoEntity fileInfoEntity) {
        if (fileInfoEntity == null || fileInfoEntity.isDeleted()) {
            return null;
        }
        return new FileInfo(fileInfoEntity.getId(), fileInfoEntity.getName(), fileInfoEntity.getMimetype(), fileInfoEntity.getNameSpaceEntity().getName(), fileInfoEntity.getSize(), fileInfoEntity.getUpdatedDate(), fileInfoEntity.getUpdater(), fileInfoEntity.getChecksum(), fileInfoEntity.isDeleted());
    }

    private NameSpace convertNameSpace(NameSpaceEntity nameSpaceEntity) {
        if (nameSpaceEntity == null) {
            return null;
        }
        return new NameSpace(nameSpaceEntity.getId(), nameSpaceEntity.getName(), nameSpaceEntity.getDescription());
    }

    static {
        DataStorage.ajc$preClinit();
    }

    static final /* synthetic */ NameSpace getNameSpace_aroundBody0(DataStorage ajc$this, String name, JoinPoint joinPoint) {
        NameSpaceEntity nameSpaceEntity = ajc$this.nameSpaceDAO.getNameSpaceByName(name);
        return ajc$this.convertNameSpace(nameSpaceEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DataStorage.java", DataStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameSpace", "org.exoplatform.commons.file.storage.DataStorage", "java.lang.String", "name", "", "org.exoplatform.commons.file.model.NameSpace"), 72);
    }
}

