/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.dao;

import java.util.Date;
import java.util.List;
import org.exoplatform.commons.file.CommonsJPAIntegrationTest;
import org.exoplatform.commons.file.storage.entity.FileBinaryEntity;
import org.junit.After;
import org.junit.Before;

public class FileBinaryDAOTest
extends CommonsJPAIntegrationTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.fileBinaryDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.fileBinaryDAO.deleteAll();
    }

    public void testFileInfoEntity() {
        Date now = new Date();
        FileBinaryEntity fileBinaryEntity = new FileBinaryEntity();
        fileBinaryEntity.setName("myFile");
        fileBinaryEntity.setData("test".getBytes());
        fileBinaryEntity.setUpdatedDate(now);
        this.fileBinaryDAO.create((Object)fileBinaryEntity);
        List list = this.fileBinaryDAO.findAll();
        FileBinaryDAOTest.assertEquals((int)list.size(), (int)1);
        FileBinaryEntity result = (FileBinaryEntity)list.get(0);
        FileBinaryDAOTest.assertEquals((String)result.getName(), (String)"myFile");
        FileBinaryDAOTest.assertEquals((String)new String(result.getData()), (String)"test");
        FileBinaryDAOTest.assertEquals((Object)result.getUpdatedDate(), (Object)now);
    }

    public void testFindFileBlobByName() {
        FileBinaryEntity fileBinaryEntity1 = new FileBinaryEntity();
        fileBinaryEntity1.setName("file-1");
        FileBinaryEntity fileBinaryEntity2 = new FileBinaryEntity();
        fileBinaryEntity2.setName("file-2");
        this.fileBinaryDAO.create((Object)fileBinaryEntity1);
        this.fileBinaryDAO.create((Object)fileBinaryEntity2);
        FileBinaryEntity result = this.fileBinaryDAO.findFileBinaryByName("file-1");
        FileBinaryDAOTest.assertNotNull((Object)result);
        FileBinaryDAOTest.assertEquals((String)result.getName(), (String)"file-1");
        result = this.fileBinaryDAO.findFileBinaryByName("file-3");
        FileBinaryDAOTest.assertNull((Object)result);
    }
}

