/*
 * Decompiled with CFR 0.152.
 */
package exo.portal.component.identiy.opendsconfig;

import exo.portal.component.identiy.opendsconfig.XMLTools;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.picketlink.idm.common.io.IOTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSConfig {
    private String name;
    private String description;
    private String host;
    private String port;
    private String contextFactory;
    private String adminDN;
    private String adminPassword;
    private String configFile;
    private String populateLdif;
    private String cleanUpDN;

    public DSConfig(String name, String description, String host, String port, String contextFactory, String adminDN, String adminPass, String configFile, String populateLdif, String cleanUpDN) {
        this.name = name;
        this.description = description;
        this.host = host;
        this.port = port;
        this.contextFactory = contextFactory;
        this.adminDN = adminDN;
        this.adminPassword = adminPass;
        this.configFile = configFile;
        this.populateLdif = populateLdif;
        this.cleanUpDN = cleanUpDN;
    }

    public String toString() {
        return new StringBuffer().append("[").append(this.description).append("]/[").append(this.host).append(":").append(this.port).append("]").toString();
    }

    public static DSConfig obtainConfig(String directories, String directoryName) throws Exception {
        if (directoryName != null && directoryName.length() > 0) {
            DSConfig[] configs;
            URL url = Thread.currentThread().getContextClassLoader().getResource(directories);
            for (DSConfig config : configs = DSConfig.fromXML(url)) {
                if (!config.getName().equals(directoryName)) continue;
                return config;
            }
            throw new IllegalStateException("Could not obtain Config for {directoryName:directories} - {" + directoryName + ":" + directories + "}");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSConfig[] fromXML(URL url) throws Exception {
        ArrayList<DSConfig> configs = new ArrayList<DSConfig>();
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
            Iterator<Element> i = XMLTools.getChildrenIterator(doc.getDocumentElement(), "directory");
            while (i.hasNext()) {
                Element childElt = i.next();
                Element nm = XMLTools.getUniqueChild(childElt, "directory-name", true);
                Element desc = XMLTools.getUniqueChild(childElt, "description", true);
                Element config = XMLTools.getUniqueChild(childElt, "config-file", true);
                Element h = XMLTools.getUniqueChild(childElt, "host", true);
                Element p = XMLTools.getUniqueChild(childElt, "port", true);
                Element context = XMLTools.getUniqueChild(childElt, "context-factory", true);
                Element admin = XMLTools.getUniqueChild(childElt, "admin-dn", true);
                Element password = XMLTools.getUniqueChild(childElt, "admin-password", true);
                Element populate = XMLTools.getUniqueChild(childElt, "populate-ldif", true);
                Element cleanup = XMLTools.getUniqueChild(childElt, "cleanup-dn", true);
                String name = XMLTools.asString(nm);
                String description = XMLTools.asString(desc);
                String configFile = XMLTools.asString(config);
                String host = XMLTools.asString(h);
                String port = XMLTools.asString(p);
                String contextFactory = XMLTools.asString(context);
                String adminDN = XMLTools.asString(admin);
                String adminPassword = XMLTools.asString(password);
                String populateLdif = XMLTools.asString(populate);
                String cleanUpDN = XMLTools.asString(cleanup);
                DSConfig dsCfg = new DSConfig(name, description, host, port, contextFactory, adminDN, adminPassword, configFile, populateLdif, cleanUpDN);
                configs.add(dsCfg);
            }
            DSConfig[] dSConfigArray = configs.toArray(new DSConfig[configs.size()]);
            return dSConfigArray;
        }
        finally {
            IOTools.safeClose((InputStream)in);
        }
    }

    public String getURL() {
        return new StringBuffer("ldap://").append(this.getHost()).append(":").append(this.getPort()).toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getAdminDN() {
        return this.adminDN;
    }

    public void setAdminDN(String adminDN) {
        this.adminDN = adminDN;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPopulateLdif() {
        return this.populateLdif;
    }

    public void setPopulateLdif(String populateLdif) {
        this.populateLdif = populateLdif;
    }

    public String getCleanUpDN() {
        return this.cleanUpDN;
    }

    public void setCleanUpDN(String cleanUpDN) {
        this.cleanUpDN = cleanUpDN;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

