/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.idm.IdmHibernateConfiguration;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class CustomHibernateServiceImpl
implements HibernateService,
ComponentRequestLifecycle {
    private static final Log LOG = ExoLogger.getLogger(CustomHibernateServiceImpl.class);
    public static final String AUTO_DIALECT = "AUTO";
    private ThreadLocal<Session> threadLocal_ = new ThreadLocal();
    private IdmHibernateConfiguration conf_;
    private SessionFactory sessionFactory_;

    public CustomHibernateServiceImpl(InitParams initParams) {
        PropertiesParam param = initParams.getPropertiesParam("hibernate.properties");
        this.conf_ = new IdmHibernateConfiguration();
        Iterator properties = param.getPropertyIterator();
        while (properties.hasNext()) {
            Property p = (Property)properties.next();
            this.conf_.setProperty(p.getName(), p.getValue());
        }
        String connectionURL = this.conf_.getProperty("hibernate.connection.url");
        if (connectionURL != null) {
            connectionURL = connectionURL.replace("${java.io.tmpdir}", System.getProperty("java.io.tmpdir"));
            this.conf_.setProperty("hibernate.connection.url", connectionURL);
        }
    }

    public Configuration getHibernateConfiguration() {
        return this.conf_;
    }

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory_ == null) {
            this.sessionFactory_ = this.conf_.buildSessionFactory();
        }
        return this.sessionFactory_;
    }

    public Session openSession() {
        Session currentSession = this.threadLocal_.get();
        if (currentSession == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"open new hibernate session in openSession()");
            }
            currentSession = this.getSessionFactory().openSession();
            this.threadLocal_.set(currentSession);
        }
        return currentSession;
    }

    public Session openNewSession() {
        Session currentSession = this.threadLocal_.get();
        if (currentSession != null) {
            this.closeSession(currentSession);
        }
        currentSession = this.getSessionFactory().openSession();
        this.threadLocal_.set(currentSession);
        return currentSession;
    }

    public void closeSession(Session session) {
        if (session == null) {
            return;
        }
        try {
            session.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"close hibernate session in openSession(Session session)");
            }
        }
        catch (HibernateException t) {
            LOG.error((Object)("Error closing hibernate session : " + t.getMessage()), (Throwable)t);
        }
        this.threadLocal_.remove();
    }

    public final void closeSession() {
        Session s = this.threadLocal_.get();
        if (s != null) {
            s.close();
        }
        this.threadLocal_.remove();
    }

    public Object findExactOne(Session session, String query, String id) throws Exception {
        Object res = session.createQuery(query).setParameter("id", (Object)id).uniqueResult();
        if (res == null) {
            throw new ObjectNotFoundException("Cannot find the object with id: " + id);
        }
        return res;
    }

    public Object findOne(Session session, String query, String id) throws Exception {
        List l = session.createQuery(query).setParameter("id", (Object)id).list();
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new Exception("Expect only one object but found" + l.size());
        }
        return l.get(0);
    }

    public Collection<?> findAll(Session session, String query) throws Exception {
        List l = session.createQuery(query).list();
        if (l.size() == 0) {
            return null;
        }
        return l;
    }

    public Object findOne(Class clazz, Serializable id) throws Exception {
        Session session = this.openSession();
        Object obj = session.get(clazz, (Object)id);
        return obj;
    }

    public Object findOne(ObjectQuery q) throws Exception {
        Session session = this.openSession();
        List l = session.createQuery(q.getHibernateQuery()).list();
        if (l.size() == 0) {
            return null;
        }
        if (l.size() > 1) {
            throw new Exception("Expect only one object but found" + l.size());
        }
        return l.get(0);
    }

    public Object create(Object obj) throws Exception {
        Session session = this.openSession();
        session.save(obj);
        session.flush();
        return obj;
    }

    public Object update(Object obj) throws Exception {
        Session session = this.openSession();
        session.update(obj);
        session.flush();
        return obj;
    }

    public Object save(Object obj) throws Exception {
        Session session = this.openSession();
        session.merge(obj);
        session.flush();
        return obj;
    }

    public Object remove(Object obj) throws Exception {
        Session session = this.openSession();
        session.delete(obj);
        session.flush();
        return obj;
    }

    public Object remove(Class clazz, Serializable id) throws Exception {
        Session session = this.openSession();
        Object obj = session.get(clazz, (Object)id);
        session.delete(obj);
        session.flush();
        return obj;
    }

    public Object remove(Session session, Class clazz, Serializable id) throws Exception {
        Object obj = session.get(clazz, (Object)id);
        session.delete(obj);
        return obj;
    }

    public void startRequest(ExoContainer container) {
    }

    public void endRequest(ExoContainer container) {
        this.closeSession();
    }

    public boolean isStarted(ExoContainer container) {
        Session s = this.threadLocal_.get();
        return s != null && s.isOpen();
    }
}

