/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.tck.organization;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.UserStatus;

public abstract class AbstractOrganizationServiceTest
extends TestCase {
    protected GroupHandler gHandler;
    protected MembershipHandler mHandler;
    protected UserHandler uHandler;
    protected MembershipTypeHandler mtHandler;
    protected UserProfileHandler upHandler;
    protected String membershipType = "type";
    protected String userName = "user";
    protected String newUserName = "newUser";
    protected String groupName1 = "group1";
    protected String groupName2 = "group2";
    protected StandaloneContainer container;
    private List<String> users = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();
    private List<String> groups = new ArrayList<String>();

    public void setUp() throws Exception {
        super.setUp();
        String configPath = System.getProperty("orgservice.test.configuration.file");
        if (configPath == null) {
            configPath = "/conf/standalone/test-configuration.xml";
        }
        String containerConf = ((Object)((Object)this)).getClass().getResource(configPath).toString();
        StandaloneContainer.addConfigurationURL((String)containerConf);
        this.container = StandaloneContainer.getInstance();
        OrganizationService organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        this.gHandler = organizationService.getGroupHandler();
        this.uHandler = organizationService.getUserHandler();
        this.mHandler = organizationService.getMembershipHandler();
        this.mtHandler = organizationService.getMembershipTypeHandler();
        this.upHandler = organizationService.getUserProfileHandler();
        this.users.add(this.userName);
        this.users.add(this.newUserName);
        this.groups.add("/" + this.groupName1);
        this.groups.add("/" + this.groupName1 + "/" + this.groupName2);
        this.types.add(this.membershipType);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void createUser(String userName) throws Exception {
        User u = this.uHandler.createUserInstance(userName);
        u.setEmail("email@test");
        u.setFirstName("first");
        u.setLastLoginTime(Calendar.getInstance().getTime());
        u.setCreatedDate(Calendar.getInstance().getTime());
        u.setLastName("last");
        u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00");
        this.uHandler.createUser(u, true);
        this.users.add(userName);
    }

    protected void createUserProfile(String userName) throws Exception {
        UserProfile up = this.upHandler.createUserProfileInstance(userName);
        Map attributes = up.getUserInfoMap();
        attributes.put("key1", "value1");
        attributes.put("key2", "value2");
        this.upHandler.saveUserProfile(up, true);
    }

    protected void createMembershipType(String type, String desc) throws Exception {
        MembershipType mt = this.mtHandler.createMembershipTypeInstance();
        mt.setName(type);
        mt.setDescription(desc);
        this.mtHandler.createMembershipType(mt, true);
        this.types.add(type);
    }

    protected void createGroup(String parentId, String name, String label, String desc) throws Exception {
        Group parent = parentId == null ? null : this.gHandler.findGroupById(parentId);
        Group child = this.gHandler.createGroupInstance();
        child.setGroupName(name);
        child.setLabel(label);
        child.setDescription(desc);
        this.gHandler.addChild(parent, child, true);
        this.groups.add((parent == null ? "" : parentId) + "/" + name);
    }

    protected void createMembership(String userName, String groupName, String type) throws Exception {
        this.createUser(userName);
        this.createGroup(null, groupName, "label", "desc");
        this.createMembershipType(type, "desc");
        this.mHandler.linkMembership(this.uHandler.findUserByName(userName), this.gHandler.findGroupById("/" + groupName), this.mtHandler.findMembershipType(type), true);
    }

    protected Group createGroupInstance(String name) throws Exception {
        this.createGroup(null, name, "label", "desc");
        return this.gHandler.removeGroup(this.gHandler.findGroupById("/" + name), true);
    }

    public void tearDown() throws Exception {
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Iterator<String> iter = this.users.iterator();
            while (iter.hasNext()) {
                String userName = iter.next();
                if (this.uHandler.findUserByName(userName) != null) {
                    this.uHandler.removeUser(userName, true);
                }
                iter.remove();
            }
            iter = this.types.iterator();
            while (iter.hasNext()) {
                String type = iter.next();
                if (this.mtHandler.findMembershipType(type) != null) {
                    this.mtHandler.removeMembershipType(type, true);
                }
                iter.remove();
            }
            iter = this.groups.iterator();
            while (iter.hasNext()) {
                String groupId = iter.next();
                this.removeGroups(groupId);
                iter.remove();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void removeGroups(String parentId) throws Exception {
        Group group = this.gHandler.findGroupById(parentId);
        if (group != null) {
            Collection childs = this.gHandler.findGroups(group);
            for (Group child : childs) {
                this.removeGroups(child.getId());
            }
            this.gHandler.removeGroup(group, true);
        }
    }

    protected void assertSizeEquals(int expectedSize, ListAccess<?> list) throws Exception {
        int size = list.getSize();
        AbstractOrganizationServiceTest.assertEquals((int)expectedSize, (int)size);
        Object[] values = list.load(0, size);
        size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            ++size;
        }
        AbstractOrganizationServiceTest.assertEquals((int)expectedSize, (int)size);
    }

    protected void assertSizeEquals(int expectedSize, Collection<?> list) throws Exception {
        AbstractOrganizationServiceTest.assertEquals((int)expectedSize, (int)list.size());
        int size = 0;
        for (Object value : list) {
            if (value == null) continue;
            ++size;
        }
        AbstractOrganizationServiceTest.assertEquals((int)expectedSize, (int)size);
    }

    protected void assertSizeEquals(int expectedSize, ListAccess<User> list, UserStatus status) throws Exception {
        int size = list.getSize();
        AbstractOrganizationServiceTest.assertEquals((int)expectedSize, (int)size);
        User[] values = (User[])list.load(0, size);
        size = 0;
        for (int i = 0; i < values.length; ++i) {
            User usr = values[i];
            if (usr == null || !status.matches(usr.isEnabled())) continue;
            ++size;
        }
        AbstractOrganizationServiceTest.assertEquals((int)expectedSize, (int)size);
    }
}

