/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.picketlink.idm.common.exception.PolicyValidationException;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;

@Entity(name="HibernateIdentityObject")
@Table(name="jbid_io")
@NamedQueries(value={@NamedQuery(name="HibernateIdentityObject.findIdentityObjectByNameAndTypeIgnoreCase", query="SELECT o FROM HibernateIdentityObject o WHERE o.realm.name = :realmName AND lower(o.name) = :name AND o.identityType.name = :typeName"), @NamedQuery(name="HibernateIdentityObject.findIdentityObjectByNameAndType", query="SELECT o FROM HibernateIdentityObject o WHERE o.realm.name = :realmName AND o.name = :name AND o.identityType.name = :typeName"), @NamedQuery(name="HibernateIdentityObject.countIdentityObjectByNameAndTypeIgnoreCase", query="SELECT count(o) FROM HibernateIdentityObject o WHERE o.realm.name = :realmName AND lower(o.name) = :name AND o.identityType.name = :typeName"), @NamedQuery(name="HibernateIdentityObject.countIdentityObjectByNameAndType", query="SELECT count(o) FROM HibernateIdentityObject o WHERE o.realm.name = :realmName AND o.name = :name AND o.identityType.name = :typeName"), @NamedQuery(name="HibernateIdentityObject.countIdentityObjectsByType", query="SELECT count(o.id) FROM HibernateIdentityObject o WHERE o.realm.name = :realmName AND o.identityType.name = :typeName")})
public class HibernateIdentityObject
implements IdentityObject {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JBID_IO_ID_SEQ")
    @SequenceGenerator(name="JBID_IO_ID_SEQ", sequenceName="JBID_IO_ID_SEQ", allocationSize=1)
    @Column(name="ID")
    private Long id;
    @Column(name="NAME", unique=true)
    private String name;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.JOIN)
    @JoinColumn(name="IDENTITY_TYPE", nullable=false)
    private HibernateIdentityObjectType identityType;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="fromIdentityObject", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<HibernateIdentityObjectRelationship> fromRelationships = new HashSet<HibernateIdentityObjectRelationship>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="toIdentityObject", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<HibernateIdentityObjectRelationship> toRelationships = new HashSet<HibernateIdentityObjectRelationship>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="identityObject", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<HibernateIdentityObjectAttribute> attributes = new HashSet<HibernateIdentityObjectAttribute>();
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="PROP_NAME")
    @Column(name="PROP_VALUE")
    @CollectionTable(name="jbid_io_props", joinColumns={@JoinColumn(name="PROP_ID", referencedColumnName="ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    private Map<String, String> properties = new HashMap<String, String>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, targetEntity=HibernateIdentityObjectCredential.class)
    @JoinColumn(name="IDENTITY_OBJECT_ID")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<HibernateIdentityObjectCredential> credentials = new HashSet<HibernateIdentityObjectCredential>();
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="REALM", nullable=false)
    private HibernateRealm realm;

    public HibernateIdentityObject() {
    }

    public HibernateIdentityObject(String name, HibernateIdentityObjectType identityType, HibernateRealm realm) {
        this.name = name;
        this.identityType = identityType;
        this.realm = realm;
    }

    public String getId() {
        return this.id.toString();
    }

    public Long getIdLong() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Long.parseLong(id);
    }

    public void addAttribute(HibernateIdentityObjectAttribute attribute) {
        attribute.setIdentityObject(this);
        this.attributes.add(attribute);
    }

    public Map<String, Collection> getAttributesAsMap() {
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (HibernateIdentityObjectAttribute attribute : this.attributes) {
            Collection values = attribute.getValues();
            map.put(attribute.getName(), values);
        }
        return Collections.unmodifiableMap(map);
    }

    public void addTextAttribute(String name, String[] values) {
        HibernateIdentityObjectAttribute attr = new HibernateIdentityObjectAttribute(this, name, "text");
        List<String> list = Arrays.asList(values);
        HashSet<String> vals = new HashSet<String>(list);
        attr.setTextValues(vals);
        this.attributes.add(attr);
    }

    public void removeAttribute(String name) {
        HibernateIdentityObjectAttribute attributeToRemove = null;
        for (HibernateIdentityObjectAttribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            attributeToRemove = attribute;
            break;
        }
        if (attributeToRemove != null) {
            this.attributes.remove(attributeToRemove);
        }
    }

    public void addFromRelationship(HibernateIdentityObjectRelationship fromRelationship) {
        fromRelationship.setFromIdentityObject(this);
        this.fromRelationships.add(fromRelationship);
    }

    public void addToRelationship(HibernateIdentityObjectRelationship toRelationship) {
        toRelationship.setToIdentityObject(this);
        this.fromRelationships.add(toRelationship);
    }

    public void addCredential(HibernateIdentityObjectCredential credential) {
        credential.setIdentityObject(this);
        this.credentials.add(credential);
    }

    public boolean hasCredentials() {
        return this.credentials != null && !this.credentials.isEmpty();
    }

    public boolean hasCredential(IdentityObjectCredentialType type) {
        if (this.credentials != null) {
            for (HibernateIdentityObjectCredential credential : this.credentials) {
                if (!credential.getType().getName().equals(type.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public HibernateIdentityObjectCredential getCredential(IdentityObjectCredentialType type) {
        if (this.credentials != null) {
            for (HibernateIdentityObjectCredential credential : this.credentials) {
                if (!credential.getType().getName().equals(type.getName())) continue;
                return credential;
            }
        }
        return null;
    }

    public void validatePolicy() throws PolicyValidationException {
    }

    public String getName() {
        return this.name;
    }

    public HibernateIdentityObjectType getIdentityType() {
        return this.identityType;
    }

    public Set<HibernateIdentityObjectRelationship> getFromRelationships() {
        return this.fromRelationships;
    }

    public Set<HibernateIdentityObjectRelationship> getToRelationships() {
        return this.toRelationships;
    }

    public Set<HibernateIdentityObjectAttribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<HibernateIdentityObjectCredential> getCredentials() {
        return this.credentials;
    }

    public HibernateRealm getRealm() {
        return this.realm;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIdentityType(HibernateIdentityObjectType identityType) {
        this.identityType = identityType;
    }

    public void setFromRelationships(Set<HibernateIdentityObjectRelationship> fromRelationships) {
        this.fromRelationships = fromRelationships;
    }

    public void setToRelationships(Set<HibernateIdentityObjectRelationship> toRelationships) {
        this.toRelationships = toRelationships;
    }

    public void setAttributes(Set<HibernateIdentityObjectAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setCredentials(Set<HibernateIdentityObjectCredential> credentials) {
        this.credentials = credentials;
    }

    public void setRealm(HibernateRealm realm) {
        this.realm = realm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HibernateIdentityObject)) {
            return false;
        }
        HibernateIdentityObject other = (HibernateIdentityObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        HibernateIdentityObjectType this$identityType = this.getIdentityType();
        HibernateIdentityObjectType other$identityType = other.getIdentityType();
        if (this$identityType == null ? other$identityType != null : !((Object)this$identityType).equals(other$identityType)) {
            return false;
        }
        Set<HibernateIdentityObjectRelationship> this$fromRelationships = this.getFromRelationships();
        Set<HibernateIdentityObjectRelationship> other$fromRelationships = other.getFromRelationships();
        if (this$fromRelationships == null ? other$fromRelationships != null : !((Object)this$fromRelationships).equals(other$fromRelationships)) {
            return false;
        }
        Set<HibernateIdentityObjectRelationship> this$toRelationships = this.getToRelationships();
        Set<HibernateIdentityObjectRelationship> other$toRelationships = other.getToRelationships();
        if (this$toRelationships == null ? other$toRelationships != null : !((Object)this$toRelationships).equals(other$toRelationships)) {
            return false;
        }
        Set<HibernateIdentityObjectAttribute> this$attributes = this.getAttributes();
        Set<HibernateIdentityObjectAttribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Set<HibernateIdentityObjectCredential> this$credentials = this.getCredentials();
        Set<HibernateIdentityObjectCredential> other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        HibernateRealm this$realm = this.getRealm();
        HibernateRealm other$realm = other.getRealm();
        return !(this$realm == null ? other$realm != null : !((Object)this$realm).equals(other$realm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HibernateIdentityObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        HibernateIdentityObjectType $identityType = this.getIdentityType();
        result = result * 59 + ($identityType == null ? 43 : ((Object)$identityType).hashCode());
        Set<HibernateIdentityObjectRelationship> $fromRelationships = this.getFromRelationships();
        result = result * 59 + ($fromRelationships == null ? 43 : ((Object)$fromRelationships).hashCode());
        Set<HibernateIdentityObjectRelationship> $toRelationships = this.getToRelationships();
        result = result * 59 + ($toRelationships == null ? 43 : ((Object)$toRelationships).hashCode());
        Set<HibernateIdentityObjectAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Set<HibernateIdentityObjectCredential> $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        HibernateRealm $realm = this.getRealm();
        result = result * 59 + ($realm == null ? 43 : ((Object)$realm).hashCode());
        return result;
    }

    public String toString() {
        return "HibernateIdentityObject(id=" + this.getId() + ", name=" + this.getName() + ", identityType=" + String.valueOf(this.getIdentityType()) + ", fromRelationships=" + String.valueOf(this.getFromRelationships()) + ", toRelationships=" + String.valueOf(this.getToRelationships()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", properties=" + String.valueOf(this.getProperties()) + ", credentials=" + String.valueOf(this.getCredentials()) + ", realm=" + String.valueOf(this.getRealm()) + ")";
    }
}

