/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.organization.mock.InMemoryMembershipHandler;

public class InMemoryMembershipTypeHandler
implements MembershipTypeHandler {
    private static final String ERROR_BROADCASTING_EVENT_MESSAGE = "Error broadcasting event : {}";
    private OrganizationService organizationService;
    private List<MembershipTypeEventListener> membershipTypeListeners = new ArrayList<MembershipTypeEventListener>();
    private static Map<String, MembershipType> membershipTypesById = new HashMap<String, MembershipType>();

    public InMemoryMembershipTypeHandler(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.membershipTypeListeners.add(listener);
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.membershipTypeListeners.remove(listener);
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType membershipType, boolean broadcast) {
        if (membershipTypesById.containsKey(membershipType.getName())) {
            return this.findMembershipType(membershipType.getName());
        }
        return this.saveMembershipType(membershipType, broadcast);
    }

    public MembershipType saveMembershipType(MembershipType membershipType, boolean broadcast) {
        if (broadcast) {
            this.preSave(membershipType, true);
        }
        Date now = new Date();
        membershipType.setCreatedDate(now);
        membershipType.setModifiedDate(now);
        membershipTypesById.put(membershipType.getName(), (MembershipType)ObjectUtils.clone((Object)membershipType));
        if (broadcast) {
            this.postSave(membershipType, true);
        }
        return (MembershipType)ObjectUtils.clone((Object)membershipType);
    }

    public MembershipType findMembershipType(String name) {
        return (MembershipType)ObjectUtils.clone((Object)membershipTypesById.get(name));
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) {
        if (!membershipTypesById.containsKey(name)) {
            return null;
        }
        MembershipType membershipType = this.findMembershipType(name);
        if (broadcast) {
            this.preDelete(membershipType);
        }
        Date now = new Date();
        membershipType.setCreatedDate(now);
        membershipType.setModifiedDate(now);
        membershipTypesById.remove(membershipType.getName());
        this.getMembershipHandler().removeMembershipByMembershipType(name, broadcast);
        if (broadcast) {
            this.postDelete(membershipType);
        }
        return membershipType;
    }

    public Collection<MembershipType> findMembershipTypes() {
        return membershipTypesById.values();
    }

    private void preSave(MembershipType membershipType, boolean isNew) {
        for (MembershipTypeEventListener listener : this.membershipTypeListeners) {
            try {
                listener.preSave(membershipType, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postSave(MembershipType membershipType, boolean isNew) {
        for (MembershipTypeEventListener listener : this.membershipTypeListeners) {
            try {
                listener.postSave(membershipType, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void preDelete(MembershipType membershipType) {
        for (MembershipTypeEventListener listener : this.membershipTypeListeners) {
            try {
                listener.preDelete(membershipType);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postDelete(MembershipType membershipType) {
        for (MembershipTypeEventListener listener : this.membershipTypeListeners) {
            try {
                listener.postDelete(membershipType);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private InMemoryMembershipHandler getMembershipHandler() {
        return (InMemoryMembershipHandler)this.organizationService.getMembershipHandler();
    }
}

