/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import exo.portal.component.identiy.opendsconfig.opends.OpenDSService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.TestOrganization;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.Config;
import org.exoplatform.services.organization.idm.EntityMapperUtils;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.organization.idm.cache.CacheableUserHandlerImpl;
import org.picketlink.idm.impl.api.SimpleAttribute;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-ldap-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestLDAPOrganization
extends TestOrganization {
    private static Log log = ExoLogger.getLogger((String)TestLDAPOrganization.class.getName());
    protected UserHandler uHandler;
    OpenDSService openDSService = new OpenDSService(null);
    PortalContainer container;
    OrganizationService organization;

    protected void beforeRunBare() {
        try {
            this.openDSService.start();
            this.openDSService.initLDAPServer();
        }
        catch (Exception e) {
            log.error((Object)"Error in starting up OPENDS", (Throwable)e);
            e.printStackTrace();
        }
        super.beforeRunBare();
    }

    @Override
    protected void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.organization = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        this.uHandler = this.organization.getUserHandler();
        super.setUp();
        this.synchronizeUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeUsers() throws Exception {
        this.begin();
        TestLDAPOrganization.assertNotNull((String)"Cannot find OrganizationService", (Object)this.organization);
        UserDAOImpl userHandler = (UserDAOImpl)this.organization.getUserHandler();
        ListAccess userListAccess = this.organization.getUserHandler().findAllUsers();
        User[] users = (User[])userListAccess.load(0, userListAccess.getSize());
        this.end();
        for (User user : users) {
            String username = user.getUserName();
            if (user.getCreatedDate() == null) {
                user.setCreatedDate(new Date());
            }
            log.info((Object)("Invoke " + username + " user synchronization "));
            List userDAOListeners = userHandler.getUserEventListeners();
            for (UserEventListener userEventListener : userDAOListeners) {
                this.begin();
                try {
                    userEventListener.preSave(user, true);
                }
                catch (Exception e) {
                    log.info((Object)("\t\tFailed to call preSave for " + username + " User with listener : " + String.valueOf(userEventListener.getClass())));
                    e.printStackTrace();
                }
                finally {
                    this.end();
                }
            }
            for (UserEventListener userEventListener : userDAOListeners) {
                try {
                    this.begin();
                    userEventListener.postSave(user, true);
                }
                catch (Exception e) {
                    log.info((Object)("\t\tFailed to call postSave for " + username + " User with listener : " + String.valueOf(userEventListener.getClass())));
                    e.printStackTrace();
                }
                finally {
                    this.end();
                }
            }
        }
    }

    @Override
    public void testIDMConfiguration() {
        PicketLinkIDMOrganizationServiceImpl idmService = (PicketLinkIDMOrganizationServiceImpl)this.container.getComponentInstanceOfType(PicketLinkIDMOrganizationServiceImpl.class);
        Config config = idmService.getConfiguration();
        TestLDAPOrganization.assertFalse((boolean)config.isCountPaginatedUsers());
        TestLDAPOrganization.assertTrue((boolean)config.isSkipPaginationInMembershipQuery());
    }

    public void testFindGroupHierachy() throws Exception {
        Group group;
        GroupHandler handler = this.organizationService.getGroupHandler();
        Collection childGoups = handler.findGroups(group = handler.findGroupById("/organization_hierarchy/OrganizationC"));
        Assert.assertTrue((childGoups.size() > 0 ? 1 : 0) != 0);
    }

    public void testMoveGroup() throws Exception {
        GroupHandler handler = this.organizationService.getGroupHandler();
        Group group = handler.findGroupById("/organization/communication/press-and-media");
        TestLDAPOrganization.assertNotNull((Object)group);
        Group communication = handler.findGroupById("/organization/communication");
        int communitcationChildren = handler.findGroups(communication).size();
        Group parentOrigin = handler.findGroupById("/organization/communication");
        Group parentTarget = handler.findGroupById("/organization/operations");
        handler.moveGroup(parentOrigin, parentTarget, group);
        TestLDAPOrganization.assertEquals((int)(communitcationChildren - 1), (int)handler.findGroups(communication).size());
        TestLDAPOrganization.assertNotNull((Object)handler.findGroupById("/organization/operations/press-and-media"));
    }

    public void testFindFilteredGroup() throws Exception {
        GroupHandler handler = this.organizationService.getGroupHandler();
        Group filteredGroup = handler.findGroupById("/organization_hierarchy/filteredSubOrganizationC");
        TestLDAPOrganization.assertNull((Object)filteredGroup);
        Group existingGroup = handler.findGroupById("/organization_hierarchy/OrganizationC");
        TestLDAPOrganization.assertNotNull((Object)existingGroup);
    }

    public void testFindUser() throws Exception {
        TestLDAPOrganization.assertNotNull((Object)this.organization);
        this.begin();
        User test2 = this.organization.getUserHandler().findUserByName("admin");
        TestLDAPOrganization.assertNotNull((Object)test2);
        this.openDSService.cleanUpDN("uid=admin,ou=People,o=test,dc=portal,dc=example,dc=com");
        if (this.organization.getUserHandler() instanceof CacheableUserHandlerImpl) {
            ((CacheableUserHandlerImpl)this.organization.getUserHandler()).clearCache();
        }
        test2 = this.organization.getUserHandler().findUserByName("admin");
        TestLDAPOrganization.assertNull((Object)test2);
        this.end();
    }

    public void testEnabledUserDetection() throws Exception {
        User u = this.uHandler.createUserInstance("test");
        ((UserImpl)u).setEnabled(Boolean.valueOf(true));
        HashMap<String, SimpleAttribute> attrs = new HashMap<String, SimpleAttribute>();
        SimpleAttribute attr = new SimpleAttribute("enabled");
        SimpleAttribute attr1 = new SimpleAttribute("enabled");
        SimpleAttribute attr2 = new SimpleAttribute("enabled");
        SimpleAttribute attr3 = new SimpleAttribute("enabled");
        attr.addValue((Object)65536);
        attr1.addValue((Object)65538);
        attr2.addValue((Object)0x800000);
        attr3.addValue((Object)0x800002);
        attrs.put("enabled", attr);
        TestLDAPOrganization.assertFalse((boolean)EntityMapperUtils.populateUser((User)u, attrs, (boolean)true));
        attrs.remove("enabled", attr);
        attrs.put("enabled", attr1);
        TestLDAPOrganization.assertTrue((boolean)EntityMapperUtils.populateUser((User)u, attrs, (boolean)true));
        attrs.remove("enabled", attr1);
        attrs.put("enabled", attr2);
        TestLDAPOrganization.assertTrue((boolean)EntityMapperUtils.populateUser((User)u, attrs, (boolean)true));
        attrs.remove("enabled", attr2);
        attrs.put("enabled", attr3);
        TestLDAPOrganization.assertTrue((boolean)EntityMapperUtils.populateUser((User)u, attrs, (boolean)true));
    }

    public void testFindEnabledUsers() throws Exception {
        Query query = new Query();
        query.setUserName("*");
        ListAccess listEnabled = this.organization.getUserHandler().findUsersByQuery(query, UserStatus.ENABLED);
        ListAccess listDisabled = this.organization.getUserHandler().findUsersByQuery(query, UserStatus.DISABLED);
        ListAccess listAll = this.organization.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
        TestLDAPOrganization.assertNotNull((Object)listDisabled);
        TestLDAPOrganization.assertNotNull((Object)listAll);
        TestLDAPOrganization.assertNotNull((Object)listEnabled);
        TestLDAPOrganization.assertEquals((int)0, (int)((User[])listDisabled.load(0, listDisabled.getSize())).length);
        TestLDAPOrganization.assertEquals((int)((User[])listAll.load(0, listAll.getSize())).length, (int)((User[])listEnabled.load(0, listEnabled.getSize())).length);
        User adminUser = this.organization.getUserHandler().findUserByName("jduke", UserStatus.ENABLED);
        TestLDAPOrganization.assertNotNull((Object)adminUser);
        adminUser = this.organization.getUserHandler().findUserByName("jduke", UserStatus.DISABLED);
        TestLDAPOrganization.assertNull((Object)adminUser);
        adminUser = this.organization.getUserHandler().findUserByName("jduke", UserStatus.ANY);
        TestLDAPOrganization.assertNotNull((Object)adminUser);
        this.organization.getUserHandler().setEnabled("jduke", false, false);
        adminUser = this.organization.getUserHandler().findUserByName("jduke", UserStatus.ENABLED);
        TestLDAPOrganization.assertNull((Object)adminUser);
        adminUser = this.organization.getUserHandler().findUserByName("jduke", UserStatus.DISABLED);
        TestLDAPOrganization.assertNotNull((Object)adminUser);
        adminUser = this.organization.getUserHandler().findUserByName("jduke", UserStatus.ANY);
        TestLDAPOrganization.assertNotNull((Object)adminUser);
        ListAccess newListEnabled = this.organization.getUserHandler().findUsersByQuery(query, UserStatus.ENABLED);
        ListAccess newListDisabled = this.organization.getUserHandler().findUsersByQuery(query, UserStatus.DISABLED);
        ListAccess newListAll = this.organization.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
        TestLDAPOrganization.assertNotNull((Object)newListEnabled);
        TestLDAPOrganization.assertNotNull((Object)newListDisabled);
        TestLDAPOrganization.assertNotNull((Object)newListAll);
        TestLDAPOrganization.assertEquals((int)1, (int)((User[])newListDisabled.load(0, newListDisabled.getSize())).length);
        TestLDAPOrganization.assertEquals((String)"jduke", (String)((User[])newListDisabled.load(0, 1))[0].getUserName());
        for (int i = 0; i < newListEnabled.getSize(); ++i) {
            TestLDAPOrganization.assertNotSame((Object)"jduke", (Object)((User[])newListEnabled.load(i, 1))[0].getUserName());
        }
    }

    public void testFindUsersWithPagination() throws Exception {
        this.begin();
        ListAccess userListAccess = this.organization.getUserHandler().findAllUsers();
        this.coherenceTestofReturnedResults((ListAccess<User>)userListAccess);
        Query query = new Query();
        query.setUserName("jduke");
        userListAccess = this.organization.getUserHandler().findUsersByQuery(query);
        this.coherenceTestofReturnedResults((ListAccess<User>)userListAccess);
    }

    private void coherenceTestofReturnedResults(ListAccess<User> userListAccess) throws Exception {
        int usersCount = userListAccess.getSize();
        TestLDAPOrganization.assertTrue((usersCount > 3 ? 1 : 0) != 0);
        int pageSize = 2;
        int index = 0;
        HashSet<String> foundUsernames = new HashSet<String>();
        while (index < pageSize * 2 && index < usersCount) {
            int usersToLoad = index + pageSize > usersCount ? usersCount - index : pageSize;
            User[] users = (User[])userListAccess.load(index, usersToLoad);
            TestLDAPOrganization.assertTrue(((index += users.length) <= usersCount ? 1 : 0) != 0);
            for (User user : users) {
                if (user != null && StringUtils.isBlank((CharSequence)user.getUserName())) continue;
                TestLDAPOrganization.assertFalse((boolean)foundUsernames.contains(user.getUserName()));
                foundUsernames.add(user.getUserName());
            }
        }
    }

    public void testFindUsers() throws Exception {
        Query query = new Query();
        query.setEmail("email@test");
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        query = new Query();
        query.setUserName("*tolik*");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("tol*");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("*lik");
        this.assertSizeEquals(4, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("tolik");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("tol");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("*olik");
        ListAccess users = this.uHandler.findUsersByQuery(query);
        this.assertSizeEquals(4, (ListAccess<User>)users, UserStatus.ENABLED);
        this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        User[] allPage = (User[])users.load(0, 4);
        User[] page1 = (User[])users.load(0, 2);
        User[] page2 = (User[])users.load(2, 2);
        TestLDAPOrganization.assertEquals((String)allPage[0].getUserName(), (String)page1[0].getUserName());
        TestLDAPOrganization.assertEquals((String)allPage[1].getUserName(), (String)page1[1].getUserName());
        TestLDAPOrganization.assertEquals((String)allPage[2].getUserName(), (String)page2[0].getUserName());
        TestLDAPOrganization.assertEquals((String)allPage[3].getUserName(), (String)page2[1].getUserName());
        try {
            users.load(0, 0);
        }
        catch (Exception e) {
            TestLDAPOrganization.fail((String)"Exception is not expected");
        }
        try {
            users.load(0, 5);
            TestLDAPOrganization.fail((String)"Exception is expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            users.load(1, 4);
            TestLDAPOrganization.fail((String)"Exception is expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.uHandler.setEnabled("tolik", false, true);
            this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
            this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
            this.uHandler.setEnabled("tolik", true, true);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        }
        catch (UnsupportedOperationException e) {
            TestLDAPOrganization.fail();
        }
    }

    protected void assertSizeEquals(int expectedSize, ListAccess<User> list, UserStatus status) throws Exception {
        int size = list.getSize();
        TestLDAPOrganization.assertEquals((int)expectedSize, (int)size);
        User[] values = (User[])list.load(0, size);
        size = 0;
        for (int i = 0; i < values.length; ++i) {
            User usr = values[i];
            if (usr == null || !status.matches(usr.isEnabled())) continue;
            ++size;
        }
        TestLDAPOrganization.assertEquals((int)expectedSize, (int)size);
    }

    protected void assertSizeEquals(int expectedSize, ListAccess<?> list) throws Exception {
        int size = list.getSize();
        TestLDAPOrganization.assertEquals((int)expectedSize, (int)size);
        Object[] values = list.load(0, size);
        size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            ++size;
        }
        TestLDAPOrganization.assertEquals((int)expectedSize, (int)size);
    }
}

