/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.IdmHibernateService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration-local.xml")})
public class TestBootstrap
extends AbstractKernelTest {
    public void testWorkspace() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        IdmHibernateService idmHibernateService = (IdmHibernateService)container.getComponentInstanceOfType(IdmHibernateService.class);
        TestBootstrap.assertNotNull((Object)idmHibernateService);
        OrganizationService organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        TestBootstrap.assertNotNull((Object)organization);
    }

    public void testBasicOperation() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        OrganizationService organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        TestBootstrap.assertNotNull((Object)organization);
        this.begin();
        User test = organization.getUserHandler().createUserInstance("testUser");
        organization.getUserHandler().createUser(test, false);
        test = organization.getUserHandler().findUserByName("toto");
        TestBootstrap.assertNull((Object)test);
        test = organization.getUserHandler().findUserByName("testuser");
        TestBootstrap.assertNotNull((Object)test);
        TestBootstrap.assertEquals((String)"testUser", (String)test.getUserName());
        this.end();
    }
}

