/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.tck.organization;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipEventListenerHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.tck.organization.AbstractOrganizationServiceTest;

public class TestMembershipHandler
extends AbstractOrganizationServiceTest {
    private MyMembershipEventListener listener;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new MyMembershipEventListener();
        this.mHandler.addMembershipEventListener((MembershipEventListener)this.listener);
    }

    @Override
    public void tearDown() throws Exception {
        this.mHandler.removeMembershipEventListener((MembershipEventListener)this.listener);
        super.tearDown();
    }

    public void testFindMembership() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        Membership m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)this.membershipType, (String)m.getMembershipType());
        m = this.mHandler.findMembership(m.getId());
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)this.membershipType, (String)m.getMembershipType());
        try {
            TestMembershipHandler.assertNull((Object)this.mHandler.findMembership("not-existed-id"));
            TestMembershipHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType("*"), true);
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*");
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)"*", (String)m.getMembershipType());
        m = this.mHandler.findMembership(m.getId());
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)"*", (String)m.getMembershipType());
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindMembershipByUserGroupAndType() throws Exception {
        Membership m = this.mHandler.findMembershipByUserGroupAndType("marry", "/platform/users", "member");
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)m.getGroupId(), (String)"/platform/users");
        TestMembershipHandler.assertEquals((String)m.getMembershipType(), (String)"member");
        TestMembershipHandler.assertEquals((String)m.getUserName(), (String)"marry");
        try {
            TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/platform/users", "member"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType("marry", "/" + this.groupName1, "member"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType("marry", "/platform/users", this.membershipType));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        this.mHandler.removeMembership(m.getId(), true);
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType));
        this.createMembership(this.userName + "2", this.groupName2, this.membershipType + "2");
        TestMembershipHandler.assertNotNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName + "2", "/" + this.groupName2, this.membershipType + "2"));
        this.mHandler.removeMembershipByUser(this.userName + "2", true);
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName + "2", "/" + this.groupName2, this.membershipType + "2"));
        this.createMembership(this.userName + "3", this.groupName2 + "3", this.membershipType + "3");
        TestMembershipHandler.assertNotNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName + "3", "/" + this.groupName2 + "3", this.membershipType + "3"));
        this.uHandler.removeUser(this.userName + "3", false);
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName + "3", "/" + this.groupName2 + "3", this.membershipType + "3"));
        this.createMembership(this.userName + "4", this.groupName2 + "4", this.membershipType + "4");
        TestMembershipHandler.assertNotNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName + "4", "/" + this.groupName2 + "4", this.membershipType + "4"));
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName2 + "4"), false);
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName + "4", "/" + this.groupName2 + "4", this.membershipType + "4"));
        TestMembershipHandler.assertEquals((int)4, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)4, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.postDelete);
    }

    public void testFindMembershipTypesByGroup() throws Exception {
        Group testGroup = null;
        try {
            this.createUser(this.userName);
            TestMembershipHandler.assertEquals((int)1, (int)this.mHandler.findMembershipTypesByGroup("/platform/users").size());
            testGroup = this.gHandler.createGroupInstance();
            testGroup.setGroupName("testGroup");
            testGroup.setLabel("Testing Group");
            this.gHandler.addChild(null, testGroup, false);
            TestMembershipHandler.assertEquals((int)0, (int)this.mHandler.findMembershipTypesByGroup("/testGroup").size());
            this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), testGroup, this.mtHandler.findMembershipType("*"), true);
            TestMembershipHandler.assertEquals((int)1, (int)this.mHandler.findMembershipTypesByGroup("/testGroup").size());
            String ali = "ali";
            this.createUser(ali);
            this.mHandler.linkMembership(this.uHandler.findUserByName(ali), testGroup, this.mtHandler.findMembershipType("*"), true);
            TestMembershipHandler.assertEquals((int)1, (int)this.mHandler.findMembershipTypesByGroup("/testGroup").size());
            this.createMembershipType(this.membershipType, "desc");
            this.mHandler.linkMembership(this.uHandler.findUserByName(ali), testGroup, this.mtHandler.findMembershipType(this.membershipType), true);
            TestMembershipHandler.assertEquals((int)2, (int)this.mHandler.findMembershipTypesByGroup("/testGroup").size());
            Membership membership = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/testGroup", "*");
            this.mHandler.removeMembership(membership.getId(), true);
            TestMembershipHandler.assertEquals((int)2, (int)this.mHandler.findMembershipTypesByGroup("/testGroup").size());
            membership = this.mHandler.findMembershipByUserGroupAndType(ali, "/testGroup", this.membershipType);
            this.mHandler.removeMembership(membership.getId(), true);
            TestMembershipHandler.assertEquals((int)1, (int)this.mHandler.findMembershipTypesByGroup("/testGroup").size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testFindMembershipsByGroup() throws Exception {
        Group g = this.gHandler.findGroupById("/platform/users");
        TestMembershipHandler.assertTrue((this.mHandler.findMembershipsByGroup(g).size() >= 4 ? 1 : 0) != 0);
        g = this.gHandler.createGroupInstance();
        g.setGroupName(this.groupName1);
        g.setLabel("label");
        this.gHandler.addChild(null, g, false);
        TestMembershipHandler.assertEquals((String)g.getId(), (String)this.gHandler.findGroupById("/" + this.groupName1).getId());
        g = this.gHandler.removeGroup(g, false);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByGroup(g));
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindAllMembershipsByGroup() throws Exception {
        Membership m;
        Group g = this.gHandler.findGroupById("/platform/users");
        ListAccess memberships = this.mHandler.findAllMembershipsByGroup(g);
        TestMembershipHandler.assertTrue((memberships.getSize() >= 4 ? 1 : 0) != 0);
        try {
            m = (Membership)memberships.load(0, 4);
            TestMembershipHandler.assertEquals((int)4, (int)((Membership[])m).length);
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        try {
            m = (Membership[])memberships.load(1, 2);
            TestMembershipHandler.assertEquals((int)2, (int)((Membership[])m).length);
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        g = this.gHandler.createGroupInstance();
        g.setGroupName(this.groupName1);
        g.setLabel("label");
        this.gHandler.addChild(null, g, false);
        TestMembershipHandler.assertEquals((String)g.getId(), (String)this.gHandler.findGroupById("/" + this.groupName1).getId());
        g = this.gHandler.removeGroup(g, true);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByGroup(g));
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        g = this.gHandler.findGroupById("/" + this.groupName1);
        this.assertSizeEquals(1, this.mHandler.findAllMembershipsByGroup(g));
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), g, this.mtHandler.findMembershipType("*"), true);
        this.assertSizeEquals(2, this.mHandler.findAllMembershipsByGroup(g));
        HashSet<String> membershipTypes = new HashSet<String>();
        for (Membership mem : (Membership[])this.mHandler.findAllMembershipsByGroup(g).load(0, 2)) {
            membershipTypes.add(mem.getMembershipType());
        }
        TestMembershipHandler.assertTrue((boolean)membershipTypes.contains(this.membershipType));
        TestMembershipHandler.assertTrue((boolean)membershipTypes.contains("*"));
        this.mHandler.removeMembership(m.getId(), true);
        this.assertSizeEquals(1, this.mHandler.findAllMembershipsByGroup(g));
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*");
        TestMembershipHandler.assertNotNull((Object)m);
        this.mHandler.removeMembership(m.getId(), true);
        this.assertSizeEquals(0, this.mHandler.findAllMembershipsByGroup(g));
        this.createMembership(this.userName + "2", this.groupName2, this.membershipType + "2");
        g = this.gHandler.findGroupById("/" + this.groupName2);
        this.assertSizeEquals(1, this.mHandler.findAllMembershipsByGroup(g));
        this.mHandler.removeMembershipByUser(this.userName + "2", true);
        this.assertSizeEquals(0, this.mHandler.findAllMembershipsByGroup(g));
        this.createMembership(this.userName + "3", this.groupName2 + "3", this.membershipType + "3");
        g = this.gHandler.findGroupById("/" + this.groupName2 + "3");
        this.assertSizeEquals(1, this.mHandler.findAllMembershipsByGroup(g));
        this.uHandler.removeUser(this.userName + "3", false);
        this.assertSizeEquals(0, this.mHandler.findAllMembershipsByGroup(g));
        this.createMembership(this.userName + "4", this.groupName2 + "4", this.membershipType + "4");
        g = this.gHandler.findGroupById("/" + this.groupName2 + "4");
        this.assertSizeEquals(1, this.mHandler.findAllMembershipsByGroup(g));
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName2 + "4"), false);
        this.assertSizeEquals(0, this.mHandler.findAllMembershipsByGroup(g));
        TestMembershipHandler.assertEquals((int)5, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)5, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.postDelete);
    }

    public void testFindMembershipsByUser() throws Exception {
        this.assertSizeEquals(3, this.mHandler.findMembershipsByUser("john"));
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUser("not-existed-user"));
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUser(this.userName));
        Membership m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType("*"), true);
        this.assertSizeEquals(2, this.mHandler.findMembershipsByUser(this.userName));
        HashSet<String> membershipTypes = new HashSet<String>();
        for (Membership mem : this.mHandler.findMembershipsByUser(this.userName)) {
            membershipTypes.add(mem.getMembershipType());
        }
        TestMembershipHandler.assertTrue((boolean)membershipTypes.contains(this.membershipType));
        TestMembershipHandler.assertTrue((boolean)membershipTypes.contains("*"));
        this.mHandler.removeMembership(m.getId(), true);
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUser(this.userName));
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*");
        TestMembershipHandler.assertNotNull((Object)m);
        this.mHandler.removeMembership(m.getId(), true);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUser(this.userName));
        this.createMembership(this.userName + "2", this.groupName2, this.membershipType + "2");
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUser(this.userName + "2"));
        this.mHandler.removeMembershipByUser(this.userName + "2", true);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUser(this.userName + "2"));
        this.createMembership(this.userName + "3", this.groupName2 + "3", this.membershipType + "3");
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUser(this.userName + "3"));
        this.uHandler.removeUser(this.userName + "3", false);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUser(this.userName + "3"));
        this.createMembership(this.userName + "4", this.groupName2 + "4", this.membershipType + "4");
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUser(this.userName + "4"));
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName2 + "4"), false);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUser(this.userName + "4"));
        TestMembershipHandler.assertEquals((int)5, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)5, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.postDelete);
    }

    public void testFindMembershipsByUserAndGroup() throws Exception {
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUserAndGroup("john", "/platform/users"));
        try {
            this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup("non-existed-john", "/platform/users"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        try {
            this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup("john", "/non-existed-group"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUserAndGroup(this.userName, "/" + this.groupName1));
        Membership m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)this.membershipType, (String)m.getMembershipType());
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType("*"), true);
        this.assertSizeEquals(2, this.mHandler.findMembershipsByUserAndGroup(this.userName, "/" + this.groupName1));
        HashSet<String> membershipTypes = new HashSet<String>();
        for (Membership mem : this.mHandler.findMembershipsByUserAndGroup(this.userName, "/" + this.groupName1)) {
            membershipTypes.add(mem.getMembershipType());
        }
        TestMembershipHandler.assertTrue((boolean)membershipTypes.contains(this.membershipType));
        TestMembershipHandler.assertTrue((boolean)membershipTypes.contains("*"));
        m = this.mHandler.removeMembership(m.getId(), true);
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)this.membershipType, (String)m.getMembershipType());
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUserAndGroup(this.userName, "/" + this.groupName1));
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*");
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)"*", (String)m.getMembershipType());
        m = this.mHandler.removeMembership(m.getId(), true);
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((String)"*", (String)m.getMembershipType());
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup(this.userName, "/" + this.groupName1));
        this.createMembership(this.userName + "2", this.groupName2, this.membershipType + "2");
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUserAndGroup(this.userName + "2", "/" + this.groupName2));
        this.mHandler.removeMembershipByUser(this.userName + "2", true);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup(this.userName + "2", "/" + this.groupName2));
        this.createMembership(this.userName + "3", this.groupName2 + "3", this.membershipType + "3");
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUserAndGroup(this.userName + "3", "/" + this.groupName2 + "3"));
        this.uHandler.removeUser(this.userName + "3", false);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup(this.userName + "3", "/" + this.groupName2 + "3"));
        this.createMembership(this.userName + "4", this.groupName2 + "4", this.membershipType + "4");
        this.assertSizeEquals(1, this.mHandler.findMembershipsByUserAndGroup(this.userName + "4", "/" + this.groupName2 + "4"));
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName2 + "4"), false);
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup(this.userName + "4", "/" + this.groupName2 + "4"));
        TestMembershipHandler.assertEquals((int)5, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)5, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.postDelete);
    }

    public void testLinkMembership() throws Exception {
        this.createUser(this.userName);
        this.createGroup(null, this.groupName1, "label", "desc");
        this.createMembershipType(this.membershipType, "desc");
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType(this.membershipType), true);
        Membership m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        try {
            this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType(this.membershipType), true);
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipHandler.assertEquals((int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        this.mHandler.removeMembership(m.getId(), true);
        this.mHandler.createMembership(m, true);
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        Group group = this.createGroupInstance("not-existed-group");
        try {
            this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), group, this.mtHandler.findMembershipType(this.membershipType), true);
            TestMembershipHandler.fail((String)"Exception  should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        User user = this.uHandler.createUserInstance("not-existed-user");
        try {
            this.mHandler.linkMembership(user, this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType(this.membershipType), true);
            TestMembershipHandler.fail((String)"Exception  should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MembershipType mt = this.mtHandler.createMembershipTypeInstance();
        mt.setName("not-existed-mt");
        try {
            this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), mt, true);
            TestMembershipHandler.fail((String)"Exception  should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), null, this.mtHandler.findMembershipType(this.membershipType), true);
            TestMembershipHandler.fail((String)"Exception  should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mHandler.linkMembership(null, this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType(this.membershipType), true);
            TestMembershipHandler.fail((String)"Exception  should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), null, true);
            TestMembershipHandler.fail((String)"Exception  should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType("*"), true);
        m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*");
        TestMembershipHandler.assertNotNull((Object)m);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)3, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testRemoveMembership() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        Membership m = this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)m);
        m = this.mHandler.removeMembership(m.getId(), true);
        TestMembershipHandler.assertEquals((String)m.getGroupId(), (String)("/" + this.groupName1));
        TestMembershipHandler.assertEquals((String)m.getMembershipType(), (String)this.membershipType);
        TestMembershipHandler.assertEquals((String)m.getUserName(), (String)this.userName);
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType));
        try {
            TestMembershipHandler.assertNull((Object)this.mHandler.removeMembership("not-existed-id", true));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testRemoveMembershipByUser() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        TestMembershipHandler.assertNotNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType));
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName1), this.mtHandler.findMembershipType("*"), true);
        TestMembershipHandler.assertNotNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*"));
        Collection memberships = this.mHandler.removeMembershipByUser(this.userName, true);
        this.assertSizeEquals(2, memberships);
        HashSet<String> membershipNames = new HashSet<String>();
        for (Membership m : memberships) {
            membershipNames.add(m.getMembershipType());
        }
        TestMembershipHandler.assertTrue((boolean)membershipNames.contains(this.membershipType));
        TestMembershipHandler.assertTrue((boolean)membershipNames.contains("*"));
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType));
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, "*"));
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUserAndGroup(this.userName, "/" + this.groupName1));
        this.assertSizeEquals(0, this.mHandler.findMembershipsByUser(this.userName));
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/group", this.membershipType));
        try {
            this.assertSizeEquals(0, this.mHandler.removeMembershipByUser("not-existed-user", true));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.postDelete);
    }

    public void testFindGroupByMembership() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.assertSizeEquals(1, this.gHandler.findGroupByMembership(this.userName, this.membershipType));
        try {
            this.assertSizeEquals(0, this.gHandler.findGroupByMembership("not-existed-john", this.membershipType));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        this.mHandler.removeMembershipByUser(this.userName, true);
        try {
            this.assertSizeEquals(0, this.gHandler.findGroupByMembership(this.userName, this.membershipType));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        this.createMembership(this.userName + "2", this.groupName2, "foo");
        this.assertSizeEquals(1, this.gHandler.findGroupByMembership(this.userName + "2", "foo"));
        this.uHandler.removeUser(this.userName + "2", false);
        try {
            this.assertSizeEquals(0, this.gHandler.findGroupByMembership(this.userName + "2", "foo"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)2, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testFindGroupsOfUser() throws Exception {
        this.assertSizeEquals(3, this.gHandler.findGroupsOfUser("john"));
        try {
            this.assertSizeEquals(0, this.gHandler.findGroupsOfUser("not-existed-james"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindUsersByGroupId() throws Exception {
        ListAccess users = this.uHandler.findUsersByGroupId("/platform/users");
        TestMembershipHandler.assertTrue((users.getSize() >= 4 ? 1 : 0) != 0);
        for (User u : (User[])users.load(0, users.getSize())) {
            User currentUrer = this.uHandler.findUserByName(u.getUserName());
            TestMembershipHandler.assertNotNull((Object)currentUrer);
            TestMembershipHandler.assertEquals((String)currentUrer.getUserName(), (String)u.getUserName());
            TestMembershipHandler.assertEquals((String)currentUrer.getFirstName(), (String)u.getFirstName());
            TestMembershipHandler.assertEquals((String)currentUrer.getLastName(), (String)u.getLastName());
            TestMembershipHandler.assertEquals((String)currentUrer.getEmail(), (String)u.getEmail());
            TestMembershipHandler.assertEquals((String)currentUrer.getOrganizationId(), (String)u.getOrganizationId());
        }
        try {
            this.assertSizeEquals(0, this.uHandler.findUsersByGroupId("/not-existed-group"));
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        User[] allPage = (User[])users.load(0, 4);
        User[] page1 = (User[])users.load(0, 2);
        User[] page2 = (User[])users.load(2, 2);
        TestMembershipHandler.assertEquals((String)allPage[0].getUserName(), (String)page1[0].getUserName());
        TestMembershipHandler.assertEquals((String)allPage[1].getUserName(), (String)page1[1].getUserName());
        TestMembershipHandler.assertEquals((String)allPage[2].getUserName(), (String)page2[0].getUserName());
        TestMembershipHandler.assertEquals((String)allPage[3].getUserName(), (String)page2[1].getUserName());
        try {
            users.load(0, 0);
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception is not expected");
        }
        users.load(1, 4);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindUsersByGroup() throws Exception {
        PageList usersList = this.uHandler.findUsersByGroup("/platform/users");
        TestMembershipHandler.assertTrue((usersList.getAll().size() >= 4 ? 1 : 0) != 0);
        for (User u : usersList.getAll()) {
            User currentUrer = this.uHandler.findUserByName(u.getUserName());
            TestMembershipHandler.assertNotNull((Object)currentUrer);
            TestMembershipHandler.assertEquals((String)currentUrer.getUserName(), (String)u.getUserName());
            TestMembershipHandler.assertEquals((String)currentUrer.getFirstName(), (String)u.getFirstName());
            TestMembershipHandler.assertEquals((String)currentUrer.getLastName(), (String)u.getLastName());
            TestMembershipHandler.assertEquals((String)currentUrer.getEmail(), (String)u.getEmail());
            TestMembershipHandler.assertEquals((String)currentUrer.getOrganizationId(), (String)u.getOrganizationId());
        }
        try {
            this.assertSizeEquals(0, this.uHandler.findUsersByGroup("/not-existed-group").getAll());
        }
        catch (Exception e) {
            TestMembershipHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testRemoveMembershipType() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.mtHandler.removeMembershipType("type", true);
        TestMembershipHandler.assertNull((Object)this.mtHandler.findMembershipType("type"));
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType));
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testRemoveGroup() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName1), true);
        TestMembershipHandler.assertNull((Object)this.gHandler.findGroupById("/" + this.groupName1));
        TestMembershipHandler.assertNull((Object)this.mHandler.findMembershipByUserGroupAndType(this.userName, "/" + this.groupName1, this.membershipType));
        try {
            Group group = this.createGroupInstance("not-existed-group");
            this.gHandler.removeGroup(group, true);
            TestMembershipHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.gHandler.removeGroup(null, true);
            TestMembershipHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testRemoveUser() throws Exception {
        String userName = "testRemoveUser";
        this.createMembership(userName, this.groupName1, this.membershipType);
        this.uHandler.removeUser(userName, true);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestMembershipHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testGetListeners() throws Exception {
        if (this.mHandler instanceof MembershipEventListenerHandler) {
            List list = ((MembershipEventListenerHandler)this.mHandler).getMembershipListeners();
            try {
                list.clear();
                TestMembershipHandler.fail((String)"We are not supposed to change list of listners");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class MyMembershipEventListener
    extends MembershipEventListener {
        public int preSaveNew;
        public int postSaveNew;
        public int preSave;
        public int postSave;
        public int preDelete;
        public int postDelete;

        private MyMembershipEventListener() {
        }

        public void preSave(Membership m, boolean isNew) throws Exception {
            if (m == null) {
                return;
            }
            if (!(m.getMembershipType().startsWith("type") || m.getMembershipType().equals("foo") || m.getMembershipType().equals("*"))) {
                throw new Exception("Unexpected membership type, it should be 'type' or '*' but was " + m.getMembershipType());
            }
            if (isNew) {
                ++this.preSaveNew;
            } else {
                ++this.preSave;
            }
        }

        public void postSave(Membership m, boolean isNew) throws Exception {
            if (m == null) {
                return;
            }
            if (isNew) {
                ++this.postSaveNew;
            } else {
                ++this.postSave;
            }
        }

        public void preDelete(Membership m) throws Exception {
            if (m == null) {
                return;
            }
            ++this.preDelete;
        }

        public void postDelete(Membership m) throws Exception {
            if (m == null) {
                return;
            }
            ++this.postDelete;
        }
    }
}

