/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.plugin;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.NewUserConfig;

public class NewUserEventListener
extends UserEventListener {
    protected static final Log LOG = ExoLogger.getLogger(NewUserEventListener.class);
    private OrganizationService organizationService;
    private NewUserConfig config;

    public NewUserEventListener(OrganizationService organizationService, InitParams params) {
        this.organizationService = organizationService;
        this.config = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
    }

    public void preSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            Date date = new Date();
            user.setLastLoginTime(date);
            user.setCreatedDate(date);
        }
    }

    public void postSave(User user, boolean isNew) throws Exception {
        UserProfile up = this.organizationService.getUserProfileHandler().createUserProfileInstance(user.getUserName());
        this.organizationService.getUserProfileHandler().saveUserProfile(up, false);
        if (this.config == null) {
            return;
        }
        if (isNew && !this.config.isIgnoreUser(user.getUserName())) {
            this.createDefaultUserMemberships(user);
        }
    }

    private void createDefaultUserMemberships(User user) throws Exception {
        List groups = this.config.getGroup();
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return;
        }
        for (int i = 0; i < groups.size(); ++i) {
            NewUserConfig.JoinGroup jgroup = (NewUserConfig.JoinGroup)groups.get(i);
            Group group = this.organizationService.getGroupHandler().findGroupById(jgroup.getGroupId());
            MembershipType mtype = this.organizationService.getMembershipTypeHandler().findMembershipType(jgroup.getMembership());
            try {
                this.organizationService.getMembershipHandler().linkMembership(user, group, mtype, true);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Error creating Membership {}:{}:{}", new Object[]{user.getUserName(), jgroup.getGroupId(), jgroup.getMembership(), e});
            }
        }
    }
}

