/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.Arrays;
import java.util.Collection;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.log.LogLevel;

public class Tools {
    public static void logMethodIn(Log log, LogLevel level, String methodName, Object[] args) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Method '").append(methodName).append("' called with arguments: ");
            if (args != null) {
                for (Object arg : args) {
                    if (arg != null && arg instanceof Object[]) {
                        sb.append(Arrays.toString((Object[])arg)).append("; ");
                        continue;
                    }
                    sb.append(arg).append("; ");
                }
            } else {
                sb.append(args);
            }
            level.log(log, (Object)sb.toString());
        }
        catch (Throwable t) {
            level.log(log, (Object)"Error in logging code block (not related to application code): ", t);
        }
    }

    public static void logMethodOut(Log log, LogLevel level, String methodName, Object result) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Method '").append(methodName).append("' returning object: ");
            if (result != null && result instanceof Collection) {
                sb.append("Collection of size: ").append(((Collection)result).size());
            } else {
                if (result != null) {
                    sb.append("[").append(result.getClass().getCanonicalName()).append("]");
                }
                sb.append(result);
            }
            level.log(log, (Object)sb.toString());
        }
        catch (Throwable t) {
            level.log(log, (Object)"Error in logging code block (not related to application code): ", t);
        }
    }
}

