/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.mock.InMemoryListAccess;

public class InMemoryMembershipHandler
implements MembershipHandler {
    private static final String ERROR_BROADCASTING_EVENT_MESSAGE = "Error broadcasting event : {}";
    private List<MembershipEventListener> membershiptListeners = new ArrayList<MembershipEventListener>();
    private static Map<String, Membership> membershipsById = new HashMap<String, Membership>();
    private static Map<String, List<Membership>> userMemberships = new HashMap<String, List<Membership>>();
    private static Map<String, List<Membership>> groupMemberships = new HashMap<String, List<Membership>>();
    private static Map<String, List<Membership>> membershipTypeMemberships = new HashMap<String, List<Membership>>();

    public void addMembershipEventListener(MembershipEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.membershiptListeners.add(listener);
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.membershiptListeners.remove(listener);
    }

    public final Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership membership, boolean broadcast) {
        this.saveMembership(membership, broadcast);
    }

    public void linkMembership(User user, Group group, MembershipType membershipType, boolean broadcast) {
        this.createMembership((Membership)new MembershipImpl(membershipType.getName() + ":" + user.getUserName() + ":" + group.getId()), broadcast);
    }

    public Membership removeMembership(String membershipId, boolean broadcast) {
        if (!membershipsById.containsKey(membershipId)) {
            return null;
        }
        return this.removeMembership(membershipsById.get(membershipId), broadcast);
    }

    public List<Membership> removeMembershipByUser(String userName, boolean broadcast) {
        List memberships = userMemberships.compute(userName, (key, existingMemberships) -> existingMemberships == null ? new ArrayList() : new ArrayList(existingMemberships));
        this.removeMemberships(memberships, broadcast);
        return memberships;
    }

    public List<Membership> removeMembershipByGroup(String groupId, boolean broadcast) {
        List memberships = groupMemberships.compute(groupId, (key, existingMemberships) -> existingMemberships == null ? new ArrayList() : new ArrayList(existingMemberships));
        this.removeMemberships(memberships, broadcast);
        return memberships;
    }

    public List<Membership> removeMembershipByMembershipType(String membershipType, boolean broadcast) {
        List memberships = membershipTypeMemberships.compute(membershipType, (key, existingMemberships) -> existingMemberships == null ? new ArrayList() : new ArrayList(existingMemberships));
        this.removeMemberships(memberships, broadcast);
        return memberships;
    }

    public Membership findMembership(String id) {
        return (Membership)ObjectUtils.clone((Object)membershipsById.get(id));
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) {
        return membershipsById.values().stream().filter(membership -> StringUtils.equals((CharSequence)userName, (CharSequence)membership.getUserName()) && StringUtils.equals((CharSequence)groupId, (CharSequence)membership.getGroupId()) && StringUtils.equals((CharSequence)type, (CharSequence)membership.getMembershipType())).findAny().orElse(null);
    }

    public List<Membership> findMembershipsByUserAndGroup(String userName, String groupId) {
        return membershipsById.values().stream().filter(membership -> StringUtils.equals((CharSequence)userName, (CharSequence)membership.getUserName()) && StringUtils.equals((CharSequence)groupId, (CharSequence)membership.getGroupId())).map(ObjectUtils::clone).toList();
    }

    public List<Membership> findMembershipsByUser(String userName) {
        return userMemberships.computeIfAbsent(userName, key -> new ArrayList());
    }

    public ListAccess<Membership> findAllMembershipsByUser(User user) {
        return new InMemoryListAccess<Membership>((List<Membership>)this.findMembershipsByUser(user.getUserName()), (T[])new Membership[0]);
    }

    public List<Membership> findMembershipsByGroup(Group group) {
        return groupMemberships.computeIfAbsent(group.getId(), key -> new ArrayList());
    }

    public List<Membership> findMembershipsByGroupId(String groupId) {
        return groupMemberships.computeIfAbsent(groupId, key -> new ArrayList());
    }

    public ListAccess<Membership> findAllMembershipsByGroup(Group group) {
        return new InMemoryListAccess<Membership>((List<Membership>)this.findMembershipsByGroup(group), (T[])new Membership[0]);
    }

    private void saveMembership(Membership membership, boolean broadcast) {
        if (membershipsById.containsKey(membership.getId())) {
            return;
        }
        if (broadcast) {
            this.preSave(membership);
        }
        membershipsById.put(membership.getId(), (Membership)ObjectUtils.clone((Object)membership));
        userMemberships.computeIfAbsent(membership.getUserName(), key -> new ArrayList()).add(membership);
        groupMemberships.computeIfAbsent(membership.getGroupId(), key -> new ArrayList()).add(membership);
        membershipTypeMemberships.computeIfAbsent(membership.getMembershipType(), key -> new ArrayList()).add(membership);
        if (broadcast) {
            this.postSave(membership);
        }
    }

    private Membership removeMembership(Membership membership, boolean broadcast) {
        if (broadcast) {
            this.preDelete(membership);
        }
        userMemberships.computeIfPresent(membership.getUserName(), (key, memberships) -> {
            memberships.removeIf(existingMembership -> StringUtils.equals((CharSequence)existingMembership.getId(), (CharSequence)membership.getId()));
            return memberships;
        });
        groupMemberships.computeIfPresent(membership.getGroupId(), (key, memberships) -> {
            memberships.removeIf(existingMembership -> StringUtils.equals((CharSequence)existingMembership.getId(), (CharSequence)membership.getId()));
            return memberships;
        });
        membershipTypeMemberships.computeIfPresent(membership.getMembershipType(), (key, memberships) -> {
            memberships.removeIf(existingMembership -> StringUtils.equals((CharSequence)existingMembership.getId(), (CharSequence)membership.getId()));
            return memberships;
        });
        membershipsById.remove(membership.getId());
        if (broadcast) {
            this.postDelete(membership);
        }
        return membership;
    }

    private void preSave(Membership membership) {
        for (MembershipEventListener listener : this.membershiptListeners) {
            try {
                listener.preSave(membership, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postSave(Membership membership) {
        for (MembershipEventListener listener : this.membershiptListeners) {
            try {
                listener.postSave(membership, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void preDelete(Membership membership) {
        for (MembershipEventListener listener : this.membershiptListeners) {
            try {
                listener.preDelete(membership);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postDelete(Membership membership) {
        for (MembershipEventListener listener : this.membershiptListeners) {
            try {
                listener.postDelete(membership);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void removeMemberships(List<Membership> memberships, boolean broadcast) {
        Membership[] membershipsArray;
        for (Membership membership : membershipsArray = memberships.toArray(new Membership[0])) {
            this.removeMembership(membership.getId(), broadcast);
        }
    }
}

