/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.net.URL;
import java.util.List;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.auth.AuthenticatorPlugin;
import org.exoplatform.services.organization.auth.OrganizationAuthenticatorImpl;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

public class TestOrganizationAuthenticator
extends TestCase {
    protected ConversationRegistry registry;
    protected Authenticator authenticator;
    protected OrganizationService orgService;

    public TestOrganizationAuthenticator(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (this.registry == null) {
            URL containerConfURL = TestOrganizationAuthenticator.class.getResource("/conf/standalone/test-authenticator-configuration.xml");
            TestOrganizationAuthenticator.assertNotNull((Object)containerConfURL);
            String containerConf = containerConfURL.toString();
            URL loginConfURL = TestOrganizationAuthenticator.class.getResource("/login.conf");
            TestOrganizationAuthenticator.assertNotNull((Object)loginConfURL);
            String loginConf = loginConfURL.toString();
            StandaloneContainer.addConfigurationURL((String)containerConf);
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", loginConf);
            }
            StandaloneContainer container = StandaloneContainer.getInstance();
            this.authenticator = (Authenticator)container.getComponentInstanceOfType(OrganizationAuthenticatorImpl.class);
            TestOrganizationAuthenticator.assertNotNull((Object)this.authenticator);
            this.registry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
            TestOrganizationAuthenticator.assertNotNull((Object)this.registry);
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            TestOrganizationAuthenticator.assertNotNull((Object)this.orgService);
        }
    }

    public void testAuthenticator() throws Exception {
        TestOrganizationAuthenticator.assertNotNull((Object)this.authenticator);
        TestOrganizationAuthenticator.assertTrue((boolean)(this.authenticator instanceof OrganizationAuthenticatorImpl));
        Credential[] cred = new Credential[]{new UsernameCredential("admin"), new PasswordCredential("admin")};
        String userId = this.authenticator.validateUser(cred);
        TestOrganizationAuthenticator.assertEquals((String)"admin", (String)userId);
        Identity identity = this.authenticator.createIdentity(userId);
        TestOrganizationAuthenticator.assertTrue((boolean)identity.isMemberOf("/platform/administrators", "manager"));
        TestOrganizationAuthenticator.assertTrue((identity.getGroups().size() > 0 ? 1 : 0) != 0);
    }

    public void testAuthenticateWithEmptyPassword() throws Exception {
        TestOrganizationAuthenticator.assertNotNull((Object)this.authenticator);
        TestOrganizationAuthenticator.assertTrue((boolean)(this.authenticator instanceof OrganizationAuthenticatorImpl));
        Credential[] cred = new Credential[]{new UsernameCredential(IdentityConstants.ANONIM), new PasswordCredential("")};
        String userId = this.authenticator.validateUser(cred);
        TestOrganizationAuthenticator.assertEquals((String)IdentityConstants.ANONIM, (String)userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuthenticatorPlugin() throws Exception {
        OrganizationAuthenticatorImpl organizationAuthenticatorImpl = (OrganizationAuthenticatorImpl)this.authenticator;
        List originalPlugins = organizationAuthenticatorImpl.getPlugins();
        try {
            final String username = "0xABCD";
            final String userId = "testuser";
            final String password = "0xDCBA";
            Credential[] cred = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            try {
                organizationAuthenticatorImpl.validateUser(cred);
                TestOrganizationAuthenticator.fail((String)"Must fail with invalid credentials");
            }
            catch (LoginException loginException) {
                // empty catch block
            }
            organizationAuthenticatorImpl.addAuthenticatorPlugin(new AuthenticatorPlugin(this){

                public String validateUser(Credential[] credentials) {
                    throw new IllegalStateException("Fake Login Error");
                }
            });
            organizationAuthenticatorImpl.addAuthenticatorPlugin(new AuthenticatorPlugin(this){

                public String validateUser(Credential[] credentials) {
                    boolean valid = credentials != null && credentials.length == 2 && StringUtils.equals((CharSequence)username, (CharSequence)((UsernameCredential)credentials[0]).getUsername()) && StringUtils.equals((CharSequence)password, (CharSequence)((PasswordCredential)credentials[1]).getPassword());
                    return valid ? userId : null;
                }
            });
            organizationAuthenticatorImpl.addAuthenticatorPlugin(new AuthenticatorPlugin(this){

                public String validateUser(Credential[] credentials) {
                    return null;
                }
            });
            String authenticatedUser = organizationAuthenticatorImpl.validateUser(cred);
            TestOrganizationAuthenticator.assertEquals((String)userId, (String)authenticatedUser);
            Identity identity = organizationAuthenticatorImpl.createIdentity(userId);
            TestOrganizationAuthenticator.assertTrue((boolean)identity.isMemberOf("/platform/users", "member"));
            TestOrganizationAuthenticator.assertFalse((boolean)identity.getGroups().isEmpty());
            try {
                organizationAuthenticatorImpl.validateUser(new Credential[]{new UsernameCredential("badUsername"), new PasswordCredential(password)});
                TestOrganizationAuthenticator.fail((String)"Must fail with invalid credentials");
            }
            catch (LoginException loginException) {
                // empty catch block
            }
            try {
                organizationAuthenticatorImpl.validateUser(new Credential[]{new UsernameCredential(username), new PasswordCredential("badPassword")});
                TestOrganizationAuthenticator.fail((String)"Must fail with invalid credentials");
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        finally {
            organizationAuthenticatorImpl.setPlugins(originalPlugins);
        }
    }

    public void testGetLastExceptionOnValidateUser() throws Exception {
        TestOrganizationAuthenticator.assertNotNull((Object)this.orgService);
        UserHandler uh = this.orgService.getUserHandler();
        User user = uh.createUserInstance("testGetLastExceptionOnValidateUser");
        user.setPassword("foo");
        TestOrganizationAuthenticator.assertNotNull((Object)this.authenticator);
        TestOrganizationAuthenticator.assertTrue((boolean)(this.authenticator instanceof OrganizationAuthenticatorImpl));
        Credential[] cred = new Credential[]{new UsernameCredential("testGetLastExceptionOnValidateUser"), new PasswordCredential("foo")};
        String userId = this.authenticator.validateUser(cred);
        TestOrganizationAuthenticator.assertEquals((String)"testGetLastExceptionOnValidateUser", (String)userId);
        TestOrganizationAuthenticator.assertNull((Object)this.authenticator.getLastExceptionOnValidateUser());
        TestOrganizationAuthenticator.assertNull((Object)this.authenticator.getLastExceptionOnValidateUser());
        uh.setEnabled("testGetLastExceptionOnValidateUser", false, false);
        try {
            this.authenticator.validateUser(cred);
            TestOrganizationAuthenticator.fail((String)"a LoginException was expected");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        TestOrganizationAuthenticator.assertTrue((boolean)(this.authenticator.getLastExceptionOnValidateUser() instanceof DisabledUserException));
        TestOrganizationAuthenticator.assertNull((Object)this.authenticator.getLastExceptionOnValidateUser());
        uh.setEnabled("testGetLastExceptionOnValidateUser", true, false);
        userId = this.authenticator.validateUser(cred);
        TestOrganizationAuthenticator.assertEquals((String)"testGetLastExceptionOnValidateUser", (String)userId);
        TestOrganizationAuthenticator.assertNull((Object)this.authenticator.getLastExceptionOnValidateUser());
        TestOrganizationAuthenticator.assertNull((Object)this.authenticator.getLastExceptionOnValidateUser());
    }
}

