/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.mock;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.exoplatform.commons.utils.ListAccess;

public class InMemoryListAccess<T>
implements ListAccess<T> {
    private Class<T> modelClass;
    private List<T> values;
    private T[] defaultResult;

    public InMemoryListAccess(List<T> values, T[] defaultResult) {
        List retrievedValues;
        this.defaultResult = defaultResult;
        List<Object> list = retrievedValues = values == null ? Collections.emptyList() : values.stream().filter(Objects::nonNull).toList();
        if (CollectionUtils.isNotEmpty(retrievedValues)) {
            Object firstElement = retrievedValues.get(0);
            this.values = firstElement instanceof Cloneable ? retrievedValues.stream().map(ObjectUtils::clone).filter(Objects::nonNull).toList() : new ArrayList(retrievedValues);
            this.modelClass = firstElement.getClass();
        } else {
            this.values = Collections.emptyList();
        }
    }

    public T[] load(int index, int length) {
        if (this.modelClass == null || index >= this.values.size()) {
            return this.defaultResult;
        }
        if (index + length > this.values.size()) {
            length = this.values.size() - index;
        }
        return this.values.subList(index, index + length).toArray((Object[])Array.newInstance(this.modelClass, this.values.size()));
    }

    public int getSize() {
        return this.values.size();
    }
}

