/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.cache;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.UserDAOImpl;

public class CacheableUserHandlerImpl
extends UserDAOImpl {
    private final ExoCache<String, User> userCache;
    private final FutureExoCache<String, User, UserStatus> futureUserCache;
    private final ExoCache<String, UserProfile> userProfileCache;
    private final ExoCache<MembershipCacheKey, Object> membershipCache;
    private final ThreadLocal<Boolean> disableCacheInThread = new ThreadLocal();

    public CacheableUserHandlerImpl(OrganizationCacheHandler organizationCacheHandler, PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService idmService) {
        super(orgService, idmService);
        this.userCache = organizationCacheHandler.getUserCache();
        this.futureUserCache = new FutureExoCache((Loader)new Loader<String, User, UserStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public User retrieve(UserStatus context, String key) throws Exception {
                CacheableUserHandlerImpl.this.disableCacheInThread.set(true);
                try {
                    User user = CacheableUserHandlerImpl.this.findUserByName(key, context);
                    return user;
                }
                finally {
                    CacheableUserHandlerImpl.this.disableCacheInThread.set(false);
                }
            }
        }, this.userCache);
        this.userProfileCache = organizationCacheHandler.getUserProfileCache();
        this.membershipCache = organizationCacheHandler.getMembershipCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User removeUser(String userName, boolean broadcast) throws Exception {
        User user = null;
        this.disableCacheInThread.set(true);
        try {
            user = super.removeUser(userName, broadcast);
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                this.userCache.remove((Serializable)((Object)userName));
                this.userProfileCache.remove((Serializable)((Object)userName));
            }
            if (user != null) {
                this.membershipCache.remove((Serializable)new MembershipCacheKey(userName, null, null));
                List objects = this.membershipCache.getCachedObjects();
                for (Object obj : objects) {
                    Membership membership;
                    if (!(obj instanceof Membership) || !(membership = (Membership)obj).getUserName().equals(userName)) continue;
                    this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
                }
            }
        }
        finally {
            this.disableCacheInThread.set(false);
        }
        return user;
    }

    @Override
    public boolean authenticate(String username, String password) throws Exception {
        boolean authenticate = super.authenticate(username, password);
        if (authenticate && this.membershipCache.get((Serializable)((Object)username)) != null) {
            this.membershipCache.remove((Serializable)((Object)username));
        }
        return authenticate;
    }

    @Override
    public void saveUser(User user, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            super.saveUser(user, broadcast);
            this.userCache.remove((Serializable)((Object)user.getUserName()));
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    @Override
    public void createUser(User user, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            super.createUser(user, broadcast);
            this.userCache.remove((Serializable)((Object)user.getUserName()));
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User setEnabled(String userName, boolean enabled, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            User result = super.setEnabled(userName, enabled, broadcast);
            this.userCache.remove((Serializable)((Object)userName));
            User user = result;
            return user;
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    @Override
    public User findUserByName(String userName, UserStatus status) throws Exception {
        User user = null;
        user = this.disableCacheInThread.get() == null || this.disableCacheInThread.get() == false ? (User)this.futureUserCache.get((Object)status, (Object)userName) : super.findUserByName(userName, status);
        return user == null ? null : (status.matches(user.isEnabled()) ? (User)((ExtendedCloneable)user).clone() : null);
    }

    public void clearCache() {
        this.userCache.clearCache();
    }

    public void disableCache() {
        this.disableCacheInThread.set(true);
    }

    public void enableCache() {
        this.disableCacheInThread.set(null);
    }
}

