/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.tck.organization;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeEventListenerHandler;
import org.exoplatform.services.tck.organization.AbstractOrganizationServiceTest;

public class TestMembershipTypeHandler
extends AbstractOrganizationServiceTest {
    private MyMembershipTypeEventListener listener;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new MyMembershipTypeEventListener();
        this.mtHandler.addMembershipTypeEventListener((MembershipTypeEventListener)this.listener);
    }

    @Override
    public void tearDown() throws Exception {
        this.mtHandler.removeMembershipTypeEventListener((MembershipTypeEventListener)this.listener);
        super.tearDown();
    }

    public void testFindMembershipType() throws Exception {
        MembershipType mt = this.mtHandler.findMembershipType("manager");
        TestMembershipTypeHandler.assertNotNull((Object)mt);
        TestMembershipTypeHandler.assertEquals((String)mt.getName(), (String)"manager");
        TestMembershipTypeHandler.assertEquals((String)mt.getDescription(), (String)"manager membership type");
        TestMembershipTypeHandler.assertNull((Object)this.mtHandler.findMembershipType("manager_"));
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindMembershipTypes() throws Exception {
        int initSize = this.mtHandler.findMembershipTypes().size();
        TestMembershipTypeHandler.assertEquals((String)"*", (String)((MembershipType)this.mtHandler.findMembershipTypes().iterator().next()).getName());
        TestMembershipTypeHandler.assertTrue((initSize >= 4 ? 1 : 0) != 0);
        this.createMembershipType("type2", "membership type2");
        this.assertSizeEquals(initSize + 1, this.mtHandler.findMembershipTypes());
        this.mtHandler.removeMembershipType("type2", true);
        this.assertSizeEquals(initSize, this.mtHandler.findMembershipTypes());
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testRemoveMembershipType() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        TestMembershipTypeHandler.assertEquals((String)("We expect to find single membership for user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        MembershipType mt = this.mtHandler.removeMembershipType("type", true);
        TestMembershipTypeHandler.assertEquals((String)mt.getName(), (String)this.membershipType);
        TestMembershipTypeHandler.assertNull((Object)this.mtHandler.findMembershipType("type"));
        TestMembershipTypeHandler.assertEquals((String)("We expect to find no membership for user " + this.userName), (int)0, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        try {
            TestMembershipTypeHandler.assertNull((Object)this.mtHandler.removeMembershipType("not-existed-mt", true));
            TestMembershipTypeHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestMembershipTypeHandler.assertNotNull((Object)this.mtHandler.findMembershipType("*"));
        try {
            this.mtHandler.removeMembershipType("*", true);
        }
        catch (Exception e) {
            TestMembershipTypeHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipTypeHandler.assertNull((Object)this.mtHandler.findMembershipType("*"));
        try {
            TestMembershipTypeHandler.assertNull((Object)this.mtHandler.removeMembershipType("*", true));
            TestMembershipTypeHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception e) {
            // empty catch block
        }
        TestMembershipTypeHandler.assertNull((Object)this.mtHandler.findMembershipType("*"));
        MembershipType anyMT = this.mtHandler.createMembershipTypeInstance();
        anyMT.setName("*");
        anyMT.setDescription("desc");
        this.mtHandler.createMembershipType(anyMT, true);
        TestMembershipTypeHandler.assertNotNull((Object)this.mtHandler.findMembershipType("*"));
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.preSaveNew);
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.postSaveNew);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.preDelete);
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.postDelete);
    }

    public void testSaveMembershipType() throws Exception {
        this.createMembershipType(this.membershipType, "desc");
        MembershipType mt = this.mtHandler.findMembershipType(this.membershipType);
        mt.setDescription("newDesc");
        this.mtHandler.saveMembershipType(mt, true);
        mt = this.mtHandler.findMembershipType(this.membershipType);
        TestMembershipTypeHandler.assertEquals((String)mt.getDescription(), (String)"newDesc");
        MembershipType anyMT = this.mtHandler.findMembershipType("*");
        TestMembershipTypeHandler.assertNotNull((Object)anyMT);
        try {
            this.mtHandler.saveMembershipType(anyMT, true);
        }
        catch (Exception e) {
            TestMembershipTypeHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.preSave);
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.postSave);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testCreateMembershipType() throws Exception {
        this.createMembershipType(this.membershipType, "desc");
        MembershipType mt = this.mtHandler.findMembershipType(this.membershipType);
        TestMembershipTypeHandler.assertNotNull((Object)mt);
        try {
            this.mtHandler.removeMembershipType("*", true);
        }
        catch (Exception e) {
            TestMembershipTypeHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipTypeHandler.assertNull((Object)this.mtHandler.findMembershipType("*"));
        MembershipType anyMT = this.mtHandler.createMembershipTypeInstance();
        anyMT.setName("*");
        anyMT.setDescription("desc");
        try {
            this.mtHandler.createMembershipType(anyMT, true);
        }
        catch (Exception e) {
            TestMembershipTypeHandler.fail((String)"Exception should not be thrown");
        }
        TestMembershipTypeHandler.assertNotNull((Object)this.mtHandler.findMembershipType("*"));
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.preSaveNew);
        TestMembershipTypeHandler.assertEquals((int)2, (int)this.listener.postSaveNew);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestMembershipTypeHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestMembershipTypeHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testGetListeners() throws Exception {
        if (this.mtHandler instanceof MembershipTypeEventListenerHandler) {
            List list = ((MembershipTypeEventListenerHandler)this.mtHandler).getMembershipTypeListeners();
            try {
                list.clear();
                TestMembershipTypeHandler.fail((String)"We are not supposed to change list of listeners");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testMembershipTypeEventListener() throws Exception {
        List list;
        TesterMembershipTypeEventListener testListener = new TesterMembershipTypeEventListener();
        int currentSize = 1;
        if (this.mtHandler instanceof MembershipTypeEventListenerHandler) {
            list = ((MembershipTypeEventListenerHandler)this.mtHandler).getMembershipTypeListeners();
            currentSize = list.size();
        }
        this.mtHandler.addMembershipTypeEventListener((MembershipTypeEventListener)testListener);
        if (this.mtHandler instanceof MembershipTypeEventListenerHandler) {
            list = ((MembershipTypeEventListenerHandler)this.mtHandler).getMembershipTypeListeners();
            TestMembershipTypeHandler.assertEquals((int)(currentSize + 1), (int)list.size());
        }
        this.createMembershipType(this.membershipType, "desc");
        TestMembershipTypeHandler.assertEquals((int)2, (int)testListener.mtInEvent.size());
        TestMembershipTypeHandler.assertEquals((int)2, (int)testListener.mtInStorage.size());
        TestMembershipTypeHandler.assertEquals((String)this.membershipType, (String)testListener.mtInEvent.get(0).getName());
        TestMembershipTypeHandler.assertNull((Object)testListener.mtInStorage.get(0));
        TestMembershipTypeHandler.assertEquals((String)this.membershipType, (String)testListener.mtInEvent.get(1).getName());
        TestMembershipTypeHandler.assertNotNull((Object)testListener.mtInStorage.get(1));
        TestMembershipTypeHandler.assertEquals((String)this.membershipType, (String)testListener.mtInStorage.get(1).getName());
        testListener.mtInEvent.clear();
        testListener.mtInStorage.clear();
        MembershipType mt = this.mtHandler.findMembershipType(this.membershipType);
        mt.setDescription("newDesc");
        this.mtHandler.saveMembershipType(mt, true);
        TestMembershipTypeHandler.assertEquals((int)2, (int)testListener.mtInEvent.size());
        TestMembershipTypeHandler.assertEquals((int)2, (int)testListener.mtInStorage.size());
        TestMembershipTypeHandler.assertEquals((String)"newDesc", (String)testListener.mtInEvent.get(0).getDescription());
        TestMembershipTypeHandler.assertEquals((String)"newDesc", (String)testListener.mtInEvent.get(1).getDescription());
        TestMembershipTypeHandler.assertEquals((String)"newDesc", (String)testListener.mtInStorage.get(1).getDescription());
        testListener.mtInEvent.clear();
        testListener.mtInStorage.clear();
        this.mtHandler.removeMembershipType(this.membershipType, true);
        TestMembershipTypeHandler.assertEquals((int)2, (int)testListener.mtInEvent.size());
        TestMembershipTypeHandler.assertEquals((int)2, (int)testListener.mtInStorage.size());
        TestMembershipTypeHandler.assertEquals((String)this.membershipType, (String)testListener.mtInEvent.get(0).getName());
        TestMembershipTypeHandler.assertNotNull((Object)testListener.mtInStorage.get(0));
        TestMembershipTypeHandler.assertEquals((String)this.membershipType, (String)testListener.mtInEvent.get(1).getName());
        TestMembershipTypeHandler.assertNull((Object)testListener.mtInStorage.get(1));
        testListener.mtInEvent.clear();
        testListener.mtInStorage.clear();
    }

    private static class MyMembershipTypeEventListener
    extends MembershipTypeEventListener {
        public int preSaveNew;
        public int postSaveNew;
        public int preSave;
        public int postSave;
        public int preDelete;
        public int postDelete;

        private MyMembershipTypeEventListener() {
        }

        public void preSave(MembershipType type, boolean isNew) throws Exception {
            if (type == null) {
                return;
            }
            if (isNew) {
                ++this.preSaveNew;
            } else {
                ++this.preSave;
            }
        }

        public void postSave(MembershipType type, boolean isNew) throws Exception {
            if (type == null) {
                return;
            }
            if (isNew) {
                ++this.postSaveNew;
            } else {
                ++this.postSave;
            }
        }

        public void preDelete(MembershipType type) throws Exception {
            if (type == null) {
                return;
            }
            ++this.preDelete;
        }

        public void postDelete(MembershipType type) throws Exception {
            if (type == null) {
                return;
            }
            ++this.postDelete;
        }
    }

    private class TesterMembershipTypeEventListener
    extends MembershipTypeEventListener {
        List<MembershipType> mtInEvent = new ArrayList<MembershipType>();
        List<MembershipType> mtInStorage = new ArrayList<MembershipType>();

        private TesterMembershipTypeEventListener() {
        }

        public void preSave(MembershipType type, boolean isNew) throws Exception {
            this.mtInEvent.add(type);
            this.mtInStorage.add(TestMembershipTypeHandler.this.mtHandler.findMembershipType(type.getName()));
        }

        public void postSave(MembershipType type, boolean isNew) throws Exception {
            this.mtInEvent.add(type);
            this.mtInStorage.add(TestMembershipTypeHandler.this.mtHandler.findMembershipType(type.getName()));
        }

        public void preDelete(MembershipType type) throws Exception {
            this.mtInEvent.add(type);
            this.mtInStorage.add(TestMembershipTypeHandler.this.mtHandler.findMembershipType(type.getName()));
        }

        public void postDelete(MembershipType type) throws Exception {
            this.mtInEvent.add(type);
            this.mtInStorage.add(TestMembershipTypeHandler.this.mtHandler.findMembershipType(type.getName()));
        }
    }
}

