/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.log.LogLevel;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.picketlink.idm.api.IdentitySearchCriteria;

public class IDMGroupTreeListAccess
implements ListAccess<Group>,
Serializable {
    private static final long serialVersionUID = 7072169099411659727L;
    private static final Log LOG = ExoLogger.getLogger(IDMGroupTreeListAccess.class);
    private final IdentitySearchCriteria identitySearchCriteria;
    private final GroupDAOImpl groupDAOImpl;
    private final PicketLinkIDMService idmService;
    private Group parentGroup;
    private int totalSize = -1;

    public IDMGroupTreeListAccess(GroupDAOImpl groupDAOImpl, Group parentGroup, PicketLinkIDMService idmService, IdentitySearchCriteria identitySearchCriteria) {
        this.groupDAOImpl = groupDAOImpl;
        this.parentGroup = parentGroup;
        this.idmService = idmService;
        this.identitySearchCriteria = identitySearchCriteria;
    }

    public Group[] load(int index, int length) throws Exception {
        if (LOG.isTraceEnabled()) {
            Tools.logMethodIn(LOG, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        if (length == 0) {
            return new Group[0];
        }
        int size = this.getSize();
        if (index + length > size) {
            throw new IllegalArgumentException("Try to get more than groups can retrieve");
        }
        this.identitySearchCriteria.page(index, length);
        List<Group> exoGroups = this.groupDAOImpl.getChildrenGroups(this.parentGroup, this.identitySearchCriteria);
        if (LOG.isTraceEnabled()) {
            Tools.logMethodOut(LOG, LogLevel.TRACE, "load", exoGroups);
        }
        return exoGroups.toArray(new Group[0]);
    }

    public int getSize() throws Exception {
        if (LOG.isTraceEnabled()) {
            Tools.logMethodIn(LOG, LogLevel.TRACE, "getSize", null);
        }
        if (this.totalSize > -1) {
            return this.totalSize;
        }
        String groupType = this.groupDAOImpl.orgService.getConfiguration().getGroupType(this.parentGroup == null ? null : this.parentGroup.getId());
        this.totalSize = this.idmService.getIdentitySession().getPersistenceManager().findGroup(groupType, this.identitySearchCriteria).size();
        if (LOG.isTraceEnabled()) {
            Tools.logMethodOut(LOG, LogLevel.TRACE, "getSize", this.totalSize);
        }
        return this.totalSize;
    }
}

