/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.idm.Config;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.cache.CacheableGroupHandlerImpl;
import org.exoplatform.services.organization.idm.cache.CacheableUserProfileHandlerImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration-new-user-listener.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestOrganization
extends AbstractKernelTest {
    protected static final String GROUP_1 = "testOrganization_group1";
    protected static final String GROUP_2 = "testOrganization_group2";
    protected static final String GROUP_3 = "testOrganization_group3";
    protected static final String USER_1 = "testOrganization_user1";
    protected static final String USER_2 = "testOrganization_user2";
    protected static final String USER_3 = "testOrganization_user3";
    protected static final String DEFAULT_PASSWORD = "defaultpassword";
    protected static final String DESCRIPTION = " Description";
    protected OrganizationService organizationService;
    protected UserHandler userHandler_;
    protected UserProfileHandler profileHandler_;
    protected GroupHandler groupHandler_;
    protected MembershipTypeHandler mtHandler_;
    protected MembershipHandler membershipHandler_;

    protected void setUp() throws Exception {
        super.setUp();
        this.begin();
        PortalContainer container = this.getContainer();
        this.organizationService = (OrganizationService)container.getComponentInstance(OrganizationService.class);
        this.userHandler_ = this.organizationService.getUserHandler();
        this.profileHandler_ = this.organizationService.getUserProfileHandler();
        this.groupHandler_ = this.organizationService.getGroupHandler();
        this.mtHandler_ = this.organizationService.getMembershipTypeHandler();
        this.membershipHandler_ = this.organizationService.getMembershipHandler();
        this.resetData();
        this.createGroup(null, GROUP_1);
        this.createGroup(GROUP_1, GROUP_2);
        this.createGroup(GROUP_1, GROUP_3);
        this.createUser(USER_1, GROUP_1);
        this.createUser(USER_2, GROUP_2);
        this.createUser(USER_3, GROUP_1);
    }

    protected void tearDown() throws Exception {
        try {
            this.resetData();
        }
        finally {
            this.end();
            super.tearDown();
        }
    }

    public void testIDMConfiguration() {
        PicketLinkIDMOrganizationServiceImpl idmService = (PicketLinkIDMOrganizationServiceImpl)this.getContainer().getComponentInstanceOfType(PicketLinkIDMOrganizationServiceImpl.class);
        Config config = idmService.getConfiguration();
        TestOrganization.assertTrue((boolean)config.isCountPaginatedUsers());
        TestOrganization.assertFalse((boolean)config.isSkipPaginationInMembershipQuery());
    }

    public void testFindGroupNotFound() throws Exception {
        GroupHandler groupHander = this.organizationService.getGroupHandler();
        Group group = groupHander.findGroupById("testOrganization_group1NOTFOUND");
        TestOrganization.assertNull((Object)group);
    }

    public void testFindGroupCaseInsensitive() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("TOTO");
        group.setLabel("TOTO");
        groupHandler.addChild(null, group, true);
        group = groupHandler.createGroupInstance();
        group.setGroupName("toto");
        group.setLabel("toto");
        groupHandler.addChild(null, group, true);
        group = groupHandler.findGroupById("toto");
        TestOrganization.assertNotNull((Object)group);
        group = groupHandler.findGroupById("TOTO");
        TestOrganization.assertNotNull((Object)group);
        group = groupHandler.findGroupById("ToTO");
        TestOrganization.assertNull((Object)group);
    }

    public void testFindGroupAfterDelete() throws Exception {
        GroupHandler groupHander = this.organizationService.getGroupHandler();
        Collection rootGroups = groupHander.findGroups(null);
        int rootGroupsSize = rootGroups.size();
        String testGroupId = "TestGroupToDelete";
        this.createGroup(null, testGroupId);
        rootGroups = groupHander.findGroups(null);
        TestOrganization.assertEquals((int)(rootGroupsSize + 1), (int)rootGroups.size());
        this.deleteGroup(testGroupId);
        rootGroups = groupHander.findGroups(null);
        TestOrganization.assertEquals((int)rootGroupsSize, (int)rootGroups.size());
    }

    public void testSaveAndFindGroupFromRoot() throws Exception {
        GroupHandler handler = this.organizationService.getGroupHandler();
        TestOrganization.assertTrue((boolean)(handler instanceof CacheableGroupHandlerImpl));
        Collection allGroups = handler.findGroups(null);
        Group newGroup = handler.createGroupInstance();
        newGroup.setGroupName("abc");
        newGroup.setLabel("abc");
        handler.addChild(null, newGroup, true);
        allGroups = handler.findGroups(null);
        TestOrganization.assertTrue((allGroups.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (Object object : allGroups) {
            if (!((Group)object).getId().equals("/abc")) continue;
            found = true;
        }
        TestOrganization.assertTrue((boolean)found);
    }

    public void testFindGroupFromRoot() throws Exception {
        GroupHandler handler = this.organizationService.getGroupHandler();
        Collection allGroups = handler.findGroups(null);
        TestOrganization.assertTrue((allGroups.size() > 0 ? 1 : 0) != 0);
    }

    public void testFindGroupById() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.findGroupById(GROUP_1);
        TestOrganization.assertNotNull((Object)group);
        TestOrganization.assertEquals((String)GROUP_1, (String)group.getGroupName());
        TestOrganization.assertEquals((String)"testOrganization_group1 Description", (String)group.getDescription());
        group = groupHandler.findGroupById("/testOrganization_group1/testOrganization_group3");
        TestOrganization.assertNotNull((Object)group);
        TestOrganization.assertEquals((String)GROUP_3, (String)group.getGroupName());
    }

    public void testFindGroupOfUser() {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        try {
            Collection groups = groupHandler.findGroupsOfUser(USER_1);
            TestOrganization.assertNotNull((Object)groups);
            TestOrganization.assertTrue((groups.size() >= 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestOrganization.fail();
        }
    }

    public void testFindGroupsOfUserByKeyword() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        ArrayList<String> excludedGroupsTypes = new ArrayList<String>();
        Collection groups = groupHandler.findGroupsOfUserByKeyword("john", "us", excludedGroupsTypes);
        TestOrganization.assertNotNull((Object)groups);
        TestOrganization.assertEquals((int)1, (int)groups.size());
        TestOrganization.assertEquals((int)1, (int)groupHandler.findGroupsOfUserByKeyword("john", "ad", excludedGroupsTypes).size());
        TestOrganization.assertEquals((int)1, (int)groupHandler.findGroupsOfUserByKeyword("demo", "us", excludedGroupsTypes).size());
        TestOrganization.assertEquals((int)0, (int)groupHandler.findGroupsOfUserByKeyword("demo", "ad", excludedGroupsTypes).size());
        excludedGroupsTypes.add("platform_type");
        TestOrganization.assertEquals((int)0, (int)groupHandler.findGroupsOfUserByKeyword("john", "ad", excludedGroupsTypes).size());
    }

    public void testFindAllGroupsByKeyword() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        ArrayList<String> excludedGroupsTypes = new ArrayList<String>();
        Collection groups = groupHandler.findAllGroupsByKeyword("us", excludedGroupsTypes);
        TestOrganization.assertNotNull((Object)groups);
        TestOrganization.assertEquals((int)2, (int)groups.size());
        TestOrganization.assertEquals((int)1, (int)groupHandler.findAllGroupsByKeyword("ad", excludedGroupsTypes).size());
        TestOrganization.assertEquals((int)3, (int)groupHandler.findAllGroupsByKeyword("test", excludedGroupsTypes).size());
        excludedGroupsTypes.add("root_type");
        TestOrganization.assertEquals((int)1, (int)groupHandler.findAllGroupsByKeyword("us", excludedGroupsTypes).size());
        TestOrganization.assertEquals((int)2, (int)groupHandler.findAllGroupsByKeyword("test", excludedGroupsTypes).size());
    }

    public void testConsistencyMembershipListAccess() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.findGroupById(GROUP_1);
        User testUser = this.userHandler_.findUserByName("root");
        MembershipType mt = this.mtHandler_.findMembershipType("test");
        if (mt == null) {
            mt = this.mtHandler_.createMembershipTypeInstance();
            mt.setName("test");
            this.mtHandler_.createMembershipType(mt, true);
        }
        this.membershipHandler_.linkMembership(testUser, group, mt, true);
        ListAccess listAccess = this.membershipHandler_.findAllMembershipsByGroup(group);
        TestOrganization.assertEquals((int)1, (int)listAccess.getSize());
        try {
            Membership[] membershipArray = (Membership[])listAccess.load(0, 3);
        }
        catch (Exception e) {
            TestOrganization.fail();
        }
    }

    public void testFindUserByGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.findGroupById(GROUP_1);
        UserHandler uHandler = this.organizationService.getUserHandler();
        PageList users = uHandler.findUsersByGroup("/platform/administrators");
        TestOrganization.assertTrue((users.getAvailable() > 0 ? 1 : 0) != 0);
        List iterator = users.getAll();
        for (Object test : iterator) {
            User user = (User)test;
        }
    }

    public void testDisplayName() throws Exception {
        UserHandler uHandler = this.organizationService.getUserHandler();
        User john = uHandler.findUserByName("john");
        TestOrganization.assertNotNull((Object)john);
        TestOrganization.assertEquals((String)"John Anthony", (String)john.getFullName());
        john.setFullName("Johnny Something");
        uHandler.saveUser(john, false);
        john = uHandler.findUserByName("john");
        TestOrganization.assertEquals((String)"Johnny Something", (String)john.getFullName());
        john.setFullName(null);
        uHandler.saveUser(john, false);
        john = uHandler.findUserByName("john");
        TestOrganization.assertEquals((String)"John Anthony", (String)john.getFullName());
    }

    public void testCreateDuplicateMembershipType() throws Exception {
        String testType = "testCreateDuplicateMembershipType";
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName(testType);
        mt.setDescription("This is a test");
        mt.setOwner("exo");
        MembershipType mt1 = this.mtHandler_.createMembershipTypeInstance();
        mt1.setName(testType);
        mt1.setDescription("a duplicate");
        mt1.setOwner("exo1");
        try {
            this.mtHandler_.createMembershipType(mt, true);
            TestOrganization.assertEquals((String)"Expect mebershiptype is:", (String)testType, (String)this.mtHandler_.findMembershipType(testType).getName());
            this.mtHandler_.createMembershipType(mt1, true);
            TestOrganization.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MembershipType membershipType = this.mtHandler_.findMembershipType(mt.getName());
        TestOrganization.assertNotNull((String)("Membership type " + testType + " must be exist"), (Object)membershipType);
        TestOrganization.assertEquals((String)"Expect mebershiptype is:", (String)testType, (String)this.mtHandler_.findMembershipType(testType).getName());
    }

    public void testFindUserProfile() throws Exception {
        UserProfileHandler userProfileHandler = this.organizationService.getUserProfileHandler();
        UserProfileImpl userProfile = new UserProfileImpl(USER_1);
        userProfile.setAttribute("user.employer", "eXo");
        userProfileHandler.saveUserProfile((UserProfile)userProfile, false);
        if (userProfileHandler instanceof CacheableUserProfileHandlerImpl) {
            ((CacheableUserProfileHandlerImpl)userProfileHandler).clearCache();
        }
        UserProfile fetchedUserProfile = userProfileHandler.findUserProfileByName(USER_1);
        TestOrganization.assertNotNull((Object)fetchedUserProfile);
        TestOrganization.assertEquals((String)USER_1, (String)fetchedUserProfile.getUserName());
    }

    public void testNotFindUserProfile() throws Exception {
        UserProfileHandler userProfileHandler = this.organizationService.getUserProfileHandler();
        if (userProfileHandler instanceof CacheableUserProfileHandlerImpl) {
            ((CacheableUserProfileHandlerImpl)userProfileHandler).clearCache();
        }
        UserProfile userProfile = userProfileHandler.findUserProfileByName("not_existing_user");
        TestOrganization.assertNull((Object)userProfile);
    }

    public void testCreateValidMembershiptype() throws Exception {
        String testType = "testType";
        String description = "this a long description!this a long description!this a long description!this a long description!this a long description!this a long description!this a long description!this a long description!this a long description!this a long description!this a long description!";
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setDescription(description);
        mt.setName(testType);
        MembershipType mt1 = null;
        try {
            mt1 = this.mtHandler_.createMembershipType(mt, false);
            TestOrganization.fail((String)"Exception should be thrown");
        }
        catch (Exception ex) {
            TestOrganization.assertEquals((String)ex.getMessage(), (String)"The membership type description field cannot exceed 255 characters");
        }
        TestOrganization.assertNull((Object)mt1);
    }

    protected void createGroup(String parent, String name) {
        this.restartTransaction();
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        try {
            Group parentGroup = null;
            if (parent != null) {
                parentGroup = groupHandler.findGroupById(parent);
            }
            Group newGroup = groupHandler.createGroupInstance();
            newGroup.setGroupName(name);
            newGroup.setDescription(name + DESCRIPTION);
            newGroup.setLabel(name);
            groupHandler.addChild(parentGroup, newGroup, true);
        }
        catch (Exception e) {
            TestOrganization.fail((String)("Error on create group [" + name + "] " + e.getMessage()), (Throwable)e);
        }
    }

    private void deleteGroup(String name) {
        this.restartTransaction();
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        try {
            Group group = groupHandler.findGroupById(name);
            if (group == null) {
                this.log.warn((Object)("Cannot find group with id '" + name + "'"));
            } else {
                Collection groups = groupHandler.findGroups(group);
                for (Group childGroup : groups) {
                    groupHandler.removeGroup(childGroup, true);
                }
                groupHandler.removeGroup(group, true);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while deleting group", (Throwable)e);
        }
    }

    protected void createUser(String username, String ... groups) throws Exception {
        this.restartTransaction();
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.createUserInstance(username);
        user.setPassword(DEFAULT_PASSWORD);
        user.setFirstName("default");
        user.setLastName("default");
        user.setEmail(username + "@exoportal.org");
        if (groups.length > 0) {
            user.setOrganizationId(groups[0]);
        }
        userHandler.createUser(user, true);
    }

    protected void deleteUser(String username) throws Exception {
        this.restartTransaction();
        UserHandler userHandler = this.organizationService.getUserHandler();
        if (userHandler.findUserByName(username) != null) {
            userHandler.removeUser(username, true);
        }
    }

    private void resetData() throws Exception {
        this.deleteGroup("/testOrganization_group1");
        this.deleteUser(USER_1);
        this.deleteUser(USER_2);
        this.deleteUser(USER_3);
    }
}

