/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserProfileImpl;

public class InMemoryUserProfileHandler
implements UserProfileHandler {
    private static final String ERROR_BROADCASTING_EVENT_MESSAGE = "Error broadcasting event : {}";
    private List<UserProfileEventListener> profileListeners = new ArrayList<UserProfileEventListener>();
    private static Map<String, UserProfile> profilesById = new HashMap<String, UserProfile>();

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.profileListeners.add(listener);
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.profileListeners.remove(listener);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        return new UserProfileImpl(userName);
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) {
        boolean isNew = profilesById.containsKey(profile.getUserName());
        if (broadcast) {
            this.preSave(profile, isNew);
        }
        profilesById.put(profile.getUserName(), (UserProfile)ObjectUtils.clone((Object)profile));
        if (broadcast) {
            this.postSave(profile, isNew);
        }
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) {
        if (!profilesById.containsKey(userName)) {
            return null;
        }
        UserProfile profile = profilesById.get(userName);
        if (broadcast) {
            this.preDelete(profile);
        }
        profilesById.remove(userName);
        if (broadcast) {
            this.postDelete(profile);
        }
        return profile;
    }

    public UserProfile findUserProfileByName(String userName) {
        return (UserProfile)ObjectUtils.clone((Object)profilesById.get(userName));
    }

    public List<UserProfile> findUserProfiles() {
        return profilesById.values().stream().map(ObjectUtils::clone).toList();
    }

    private void preSave(UserProfile profile, boolean isNew) {
        for (UserProfileEventListener listener : this.profileListeners) {
            try {
                listener.preSave(profile, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postSave(UserProfile profile, boolean isNew) {
        for (UserProfileEventListener listener : this.profileListeners) {
            try {
                listener.postSave(profile, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void preDelete(UserProfile profile) {
        for (UserProfileEventListener listener : this.profileListeners) {
            try {
                listener.preDelete(profile);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postDelete(UserProfile profile) {
        for (UserProfileEventListener listener : this.profileListeners) {
            try {
                listener.postDelete(profile);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }
}

