/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.cache;

import java.io.Serializable;
import java.util.Collection;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;

public class CacheableMembershipHandlerImpl
extends MembershipDAOImpl {
    private final ExoCache<MembershipCacheKey, Object> membershipCache;
    private final FutureExoCache<MembershipCacheKey, Object, MembershipCacheOperationType> futureMembershipCache;
    private final ThreadLocal<Boolean> disableCacheInThread = new ThreadLocal();
    private boolean useCacheList;

    public CacheableMembershipHandlerImpl(OrganizationCacheHandler organizationCacheHandler, PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service, boolean useCacheList) {
        super(orgService, service);
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.futureMembershipCache = new FutureExoCache((Loader)new Loader<MembershipCacheKey, Object, MembershipCacheOperationType>(){

            public Object retrieve(MembershipCacheOperationType context, MembershipCacheKey key) throws Exception {
                CacheableMembershipHandlerImpl.this.disableCacheInThread.set(true);
                try {
                    switch (context.ordinal()) {
                        case 0: {
                            Membership membership = CacheableMembershipHandlerImpl.this.findMembershipByUserGroupAndType(key.getUserName(), key.getGroupId(), key.getType());
                            return membership;
                        }
                        case 1: {
                            Collection<Membership> collection = CacheableMembershipHandlerImpl.this.findMembershipsByUser(key.getUserName());
                            return collection;
                        }
                    }
                    throw new IllegalArgumentException("context value " + String.valueOf((Object)context) + " is not recognized");
                }
                finally {
                    CacheableMembershipHandlerImpl.this.disableCacheInThread.remove();
                }
            }
        }, this.membershipCache);
        this.useCacheList = useCacheList;
    }

    @Override
    public Membership findMembership(String id) throws Exception {
        if (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue()) {
            Membership membership = (Membership)this.futureMembershipCache.get((Object)MembershipCacheOperationType.MEMBERSHIP_BY_ID, (Object)new MembershipCacheKey((Membership)new MembershipImpl(id)));
            return membership == null ? null : (Membership)((ExtendedCloneable)membership).clone();
        }
        return super.findMembership(id);
    }

    @Override
    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        if (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue()) {
            Membership membership = (Membership)this.futureMembershipCache.get((Object)MembershipCacheOperationType.MEMBERSHIP_BY_ID, (Object)new MembershipCacheKey(userName, groupId, type));
            return membership == null ? null : (Membership)((ExtendedCloneable)membership).clone();
        }
        return super.findMembershipByUserGroupAndType(userName, groupId, type);
    }

    @Override
    public Collection<Membership> findMembershipsByUser(String userName) throws Exception {
        if (this.useCacheList && (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue())) {
            MembershipCacheKey cacheKey = new MembershipCacheKey(userName, null, null);
            return (Collection)this.futureMembershipCache.get((Object)MembershipCacheOperationType.MEMBERSHIPS_FOR_USER, (Object)cacheKey);
        }
        try {
            Collection collection = super.findMembershipsByUser(userName);
            return collection;
        }
        finally {
            this.clearMembershipCache(userName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        Membership membership = null;
        this.disableCacheInThread.set(true);
        try {
            membership = super.removeMembership(id, broadcast);
            this.clearMembershipCache(membership);
        }
        finally {
            this.disableCacheInThread.remove();
        }
        return membership;
    }

    @Override
    public void saveMembership(Membership m, boolean broadcast) throws Exception {
        super.saveMembership(m, broadcast);
        this.clearMembershipCache(m);
    }

    @Override
    public void createMembership(Membership m, boolean broadcast) throws Exception {
        super.createMembership(m, broadcast);
        this.clearMembershipCache(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkMembership(User user, Group g, MembershipType mt, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            super.linkMembership(user, g, mt, broadcast);
        }
        finally {
            if (user != null && g != null && mt != null) {
                this.futureMembershipCache.remove((Serializable)new MembershipCacheKey(user.getUserName(), g.getId(), mt.getName()));
                this.clearMembershipCache(user.getUserName());
            }
            this.disableCacheInThread.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Membership> removeMembershipByUser(String username, boolean broadcast) throws Exception {
        Collection memberships = null;
        this.disableCacheInThread.set(true);
        try {
            memberships = super.removeMembershipByUser(username, broadcast);
            for (Membership membership : memberships) {
                this.clearMembershipCache(membership);
            }
        }
        finally {
            this.disableCacheInThread.remove();
        }
        return memberships;
    }

    public void clearCache() {
        this.futureMembershipCache.clear();
    }

    public void disableCache() {
        this.disableCacheInThread.set(true);
    }

    public void enableCache() {
        this.disableCacheInThread.remove();
    }

    public void clearMembershipCache(Membership membership) {
        if (membership != null) {
            this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
            this.clearMembershipCache(membership.getUserName());
        }
    }

    public void clearMembershipCache(String username) {
        if (this.useCacheList) {
            this.membershipCache.remove((Serializable)new MembershipCacheKey(username, null, null));
        }
    }

    public static enum MembershipCacheOperationType {
        MEMBERSHIP_BY_ID,
        MEMBERSHIPS_FOR_USER;

    }
}

