/*
 * Decompiled with CFR 0.152.
 */
package exo.portal.component.identiy.opendsconfig;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gatein.common.xml.NoSuchElementException;
import org.gatein.common.xml.TooManyElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLTools {
    private static final DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Properties DEFAULT_FORMAT = XMLTools.createFormat(true, false, true, "utf-8");

    private XMLTools() {
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return buildFactory;
    }

    private static Properties createFormat(boolean omitXMLDeclaration, boolean standalone, boolean indented, String encoding) {
        Properties format = new Properties();
        format.setProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        format.setProperty("standalone", standalone ? "yes" : "no");
        format.setProperty("indent", indented ? "yes" : "no");
        format.setProperty("encoding", encoding);
        return format;
    }

    public static String toString(Document doc, boolean omitXMLDeclaration, boolean standalone, boolean indented, String encoding) throws TransformerException {
        Properties format = XMLTools.createFormat(omitXMLDeclaration, standalone, indented, encoding);
        return XMLTools.toString(doc, format);
    }

    public static String toString(Document doc) throws TransformerException {
        return XMLTools.toString(doc, DEFAULT_FORMAT);
    }

    public static String toString(Element element) throws ParserConfigurationException, TransformerException {
        return XMLTools.toString(element, DEFAULT_FORMAT);
    }

    private static String toString(Element element, Properties properties) throws ParserConfigurationException, TransformerException {
        Document doc = buildFactory.newDocumentBuilder().newDocument();
        element = (Element)doc.importNode(element, true);
        doc.appendChild(element);
        return XMLTools.toString(doc, properties);
    }

    private static String toString(Document doc, Properties format) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperties(format);
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    public static String asString(Element element) throws IllegalArgumentException {
        return XMLTools.asString(element, true);
    }

    public static String asString(Element element, boolean trim) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("No null element allowed");
        }
        StringBuffer buffer = new StringBuffer();
        NodeList children = element.getChildNodes();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    buffer.append(((Text)child).getData());
                    continue block4;
                }
                case 1: {
                    throw new IllegalArgumentException("Mixed content not allowed");
                }
            }
        }
        String result = buffer.toString();
        if (trim) {
            result = result.trim();
        }
        return result;
    }

    public static Element getUniqueChild(Element element, String name, boolean strict) throws IllegalArgumentException, NoSuchElementException, TooManyElementException {
        return XMLTools.getUniqueChild(element, null, name, strict);
    }

    public static Element getUniqueChild(Element element, String uri, String name, boolean strict) throws IllegalArgumentException, NoSuchElementException, TooManyElementException {
        List<Element> list = XMLTools.getChildren(element, uri, name);
        switch (list.size()) {
            case 0: {
                if (strict) {
                    throw new NoSuchElementException("Missing child " + name + " of element " + element.getNodeName());
                }
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new TooManyElementException("Too many children for element " + element.getNodeName());
    }

    public static Iterator<Element> getChildrenIterator(Element element, String name) throws IllegalArgumentException {
        return XMLTools.getChildren(element, name).iterator();
    }

    public static List<Element> getChildren(Element element, String name) throws IllegalArgumentException {
        return XMLTools.getChildren(element, null, name);
    }

    public static List<Element> getChildren(Element element, String uri, String name) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("No element found");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElt = (Element)node;
            if (uri == null) {
                if (!childElt.getTagName().equals(name)) continue;
                result.add(childElt);
                continue;
            }
            if (!uri.equals(childElt.getNamespaceURI()) || !childElt.getLocalName().equals(name)) continue;
            result.add(childElt);
        }
        return result;
    }
}

