/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectCredential;

@Entity(name="HibernateIdentityObjectCredential")
@Table(name="jbid_io_creden")
@NamedQuery(name="HibernateIdentityObjectCredential.findCredentialByTypeAndIdentity", query="SELECT c FROM HibernateIdentityObjectCredential c INNER JOIN c.type type ON type.name = :cTypeName WHERE c.identityObject.id = :ioId")
public class HibernateIdentityObjectCredential
implements IdentityObjectCredential {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JBID_IO_CREDEN_ID_SEQ")
    @Column(name="ID")
    @SequenceGenerator(name="JBID_IO_CREDEN_ID_SEQ", sequenceName="JBID_IO_CREDEN_ID_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.JOIN)
    @JoinColumn(name="CREDENTIAL_TYPE", nullable=false)
    private HibernateIdentityObjectCredentialType type;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDENTITY_OBJECT_ID", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    @LazyToOne(value=LazyToOneOption.PROXY)
    private HibernateIdentityObject identityObject;
    @Column(name="TEXT")
    private String textValue;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(name="BIN_VALUE_ID")
    @LazyToOne(value=LazyToOneOption.PROXY)
    private HibernateIdentityObjectCredentialBinaryValue binaryValue;
    @ElementCollection
    @MapKeyColumn(name="PROP_NAME")
    @Column(name="PROP_VALUE")
    @CollectionTable(name="jbid_io_creden_props", joinColumns={@JoinColumn(name="PROP_ID", referencedColumnName="ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    @LazyCollection(value=LazyCollectionOption.EXTRA)
    private Map<String, String> properties = new HashMap<String, String>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public HibernateIdentityObjectCredentialBinaryValue getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(HibernateIdentityObjectCredentialBinaryValue binaryValue) {
        this.binaryValue = binaryValue;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public HibernateIdentityObjectCredentialType getType() {
        return this.type;
    }

    public void setType(HibernateIdentityObjectCredentialType type) {
        this.type = type;
    }

    public HibernateIdentityObject getIdentityObject() {
        return this.identityObject;
    }

    public void setIdentityObject(HibernateIdentityObject identityObject) {
        this.identityObject = identityObject;
    }

    public Object getValue() {
        if (this.textValue != null) {
            return this.textValue;
        }
        return this.binaryValue.getValue();
    }

    public Object getEncodedValue() {
        return null;
    }
}

