/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipName;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;

@Entity(name="HibernateIdentityObjectRelationship")
@Table(name="jbid_io_rel")
@NamedQueries(value={@NamedQuery(name="HibernateIdentityObjectRelationship.findIdentityObjectRelationshipWithoutName", query="SELECT r FROM HibernateIdentityObjectRelationship r WHERE r.type.id = :typeId AND r.fromIdentityObject = :fromIdentityObject AND r.toIdentityObject = :toIdentityObject"), @NamedQuery(name="HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByIdentitiesAndTypeAndName", query="SELECT r FROM HibernateIdentityObjectRelationship r WHERE r.type.name = :typeName AND r.name.name = :name AND r.fromIdentityObject = :fromIdentityObject AND r.toIdentityObject = :toIdentityObject"), @NamedQuery(name="HibernateIdentityObjectRelationship.findIdentityObjectRelationshipsByIdentities", query="SELECT r FROM HibernateIdentityObjectRelationship r WHERE (   r.fromIdentityObject = :hio1     AND   r.toIdentityObject = :hio2 ) OR (   r.fromIdentityObject = :hio2     AND   r.toIdentityObject = :hio1 ) "), @NamedQuery(name="HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByIdentityByType", query="SELECT r FROM HibernateIdentityObjectRelationship r WHERE r.type.name = :typeName AND r.fromIdentityObject = :fromIdentityObject AND r.toIdentityObject = :toIdentityObject"), @NamedQuery(name="HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByAttributes", query="SELECT r FROM HibernateIdentityObjectRelationship r WHERE r.type.id = :typeId AND r.name.name = :name AND r.fromIdentityObject = :fromIdentityObject AND r.toIdentityObject = :toIdentityObject"), @NamedQuery(name="HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByIdentity", query="SELECT r FROM HibernateIdentityObjectRelationship r WHERE r.fromIdentityObject = :fromIdentityObject AND r.toIdentityObject = :toIdentityObject"), @NamedQuery(name="HibernateIdentityObjectRelationship.getRelationshipsByName", query="SELECT r FROM HibernateIdentityObjectRelationship r  WHERE r.name.id = :nameId"), @NamedQuery(name="HibernateIdentityObjectRelationship.removeRelationshipsByName", query="DELETE FROM HibernateIdentityObjectRelationship  WHERE name.id = :nameId")})
public class HibernateIdentityObjectRelationship
implements IdentityObjectRelationship {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JBID_IO_REL_ID_SEQ")
    @SequenceGenerator(name="JBID_IO_REL_ID_SEQ", sequenceName="JBID_IO_REL_ID_SEQ", allocationSize=1)
    @Column(name="ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="NAME")
    @Fetch(value=FetchMode.JOIN)
    private HibernateIdentityObjectRelationshipName name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REL_TYPE", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    private HibernateIdentityObjectRelationshipType type;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FROM_IDENTITY", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    private HibernateIdentityObject fromIdentityObject;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TO_IDENTITY", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    private HibernateIdentityObject toIdentityObject;
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="PROP_NAME")
    @Column(name="PROP_VALUE")
    @CollectionTable(name="jbid_io_rel_props", joinColumns={@JoinColumn(name="PROP_ID", referencedColumnName="ID")})
    @Fetch(value=FetchMode.SUBSELECT)
    private Map<String, String> properties = new HashMap<String, String>();

    public HibernateIdentityObjectRelationship() {
    }

    public HibernateIdentityObjectRelationship(HibernateIdentityObjectRelationshipType type, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject) {
        this.type = type;
        this.fromIdentityObject = fromIdentityObject;
        fromIdentityObject.getFromRelationships().add(this);
        this.toIdentityObject = toIdentityObject;
        toIdentityObject.getToRelationships().add(this);
    }

    public HibernateIdentityObjectRelationship(HibernateIdentityObjectRelationshipType type, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject, HibernateIdentityObjectRelationshipName name) {
        this.type = type;
        this.fromIdentityObject = fromIdentityObject;
        fromIdentityObject.getFromRelationships().add(this);
        this.toIdentityObject = toIdentityObject;
        toIdentityObject.getToRelationships().add(this);
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IdentityObjectRelationshipType getType() {
        return this.type;
    }

    public void setType(HibernateIdentityObjectRelationshipType type) {
        this.type = type;
    }

    public HibernateIdentityObject getFromIdentityObject() {
        return this.fromIdentityObject;
    }

    public void setFromIdentityObject(HibernateIdentityObject fromIdentityObject) {
        this.fromIdentityObject = fromIdentityObject;
    }

    public HibernateIdentityObject getToIdentityObject() {
        return this.toIdentityObject;
    }

    public void setToIdentityObject(HibernateIdentityObject toIdentityObject) {
        this.toIdentityObject = toIdentityObject;
    }

    public String getName() {
        if (this.name != null) {
            return this.name.getName();
        }
        return null;
    }

    public void setName(HibernateIdentityObjectRelationshipName name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

