/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.HashMap;
import java.util.Locale;
import org.gatein.api.AbstractApiTest;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.EntityNotFoundException;
import org.gatein.api.SerializationUtils;
import org.gatein.api.common.i18n.LocalizedString;
import org.gatein.api.navigation.ApiNode;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.site.SiteId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NavigationImplTest
extends AbstractApiTest {
    private Navigation navigation;

    @Test
    public void addChild() {
        this.createNavigationChildren();
        Node root = this.navigation.getRootNode(Nodes.visitAll());
        Node node = root.addChild("parent2");
        Assert.assertNotNull((Object)root.getChild("parent2"));
        this.navigation.saveNode(node);
        root = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertNotNull((Object)root.getChild("parent2"));
    }

    @Test(expected=EntityAlreadyExistsException.class)
    public void addChildExisting() {
        this.createNavigationChildren();
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        node.getChild("parent").addChild("child");
    }

    @Test(expected=IllegalStateException.class)
    public void addChildNotExpanded() {
        this.createNavigationChildren();
        Node node = this.navigation.getRootNode(Nodes.visitChildren());
        node.getChild("parent").addChild("child");
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.createSite(this.defaultSiteId, new String[0]);
        this.navigation = this.portal.getNavigation(this.defaultSiteId);
    }

    @Test
    public void createNavigationChildren() {
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Node parent = node.addChild("parent");
        parent.addChild("child");
        this.navigation.saveNode(node);
        this.navigation = this.portal.getNavigation(this.defaultSiteId);
        node = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertEquals((long)1L, (long)node.getChildCount());
        Assert.assertEquals((long)1L, (long)node.getChild("parent").getChildCount());
        Assert.assertEquals((long)0L, (long)node.getChild("parent").getChild("child").getChildCount());
    }

    @Test
    public void createNavigationEmpty() {
        this.navigation.setPriority(10);
        this.navigation = this.portal.getNavigation(this.defaultSiteId);
        Assert.assertEquals((long)10L, (long)this.navigation.getPriority());
        Assert.assertEquals((Object)this.defaultSiteId, (Object)this.navigation.getSiteId());
        Assert.assertEquals((long)0L, (long)this.navigation.getRootNode(Nodes.visitAll()).getChildCount());
    }

    @Test
    public void displayName_extended() {
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Node n = node.addChild("parent");
        HashMap<Locale, String> m = new HashMap<Locale, String>();
        m.put(Locale.ENGLISH, "extended");
        m.put(Locale.FRENCH, "prolong\u00e9");
        n.setDisplayNames(new LocalizedString(m));
        this.navigation.saveNode(node);
        n = this.navigation.getRootNode(Nodes.visitChildren()).getChild("parent");
        Assert.assertNotNull((Object)n.getDisplayNames());
        Assert.assertTrue((boolean)n.getDisplayNames().isLocalized());
        Assert.assertEquals((Object)"extended", (Object)n.getDisplayNames().getValue(Locale.ENGLISH));
        Assert.assertEquals((Object)"prolong\u00e9", (Object)n.getDisplayNames().getValue(Locale.FRENCH));
    }

    @Test
    public void displayName_simple() {
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Node n = node.addChild("parent");
        n.setDisplayName("simple");
        this.navigation.saveNode(n);
        Assert.assertEquals((Object)"simple", (Object)n.getDisplayNames().getValue());
        n = this.navigation.getRootNode(Nodes.visitChildren()).getChild("parent");
        Assert.assertNotNull((Object)n.getDisplayNames());
        Assert.assertEquals((Object)"simple", (Object)n.getDisplayNames().getValue());
        Assert.assertFalse((boolean)n.getDisplayNames().isLocalized());
    }

    @Test
    public void displayNames() throws Exception {
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        node.addChild("simple");
        node.addChild("extended");
        node.getChild("simple").setDisplayName("simple");
        LocalizedString localizedString = new LocalizedString(Locale.ENGLISH, "english");
        localizedString.setLocalizedValue(Locale.CHINA, "chinese");
        node.getChild("extended").setDisplayNames(localizedString);
        this.navigation.saveNode(node);
        Node saved = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertEquals((Object)"simple", (Object)saved.getChild("simple").getDisplayName());
        Assert.assertNotNull((Object)saved.getChild("extended").getDisplayNames());
        Assert.assertEquals((Object)"english", (Object)saved.getChild("extended").getDisplayNames().getLocalizedValue(Locale.ENGLISH).getValue());
        Assert.assertEquals((Object)"chinese", (Object)saved.getChild("extended").getDisplayNames().getLocalizedValue(Locale.CHINA).getValue());
    }

    @Test
    public void getChild() {
        this.createNavigationChildren();
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)node.isChildrenLoaded());
        Assert.assertTrue((boolean)node.getChild("parent").getChild("child").isChildrenLoaded());
        node = this.navigation.getRootNode(Nodes.visitChildren());
        Assert.assertNotNull((Object)node);
        Assert.assertTrue((boolean)node.isChildrenLoaded());
        Assert.assertFalse((boolean)node.getChild("parent").isChildrenLoaded());
    }

    @Test
    public void getNavigation() {
        this.portal.getNavigation(this.defaultSiteId).getRootNode(Nodes.visitAll());
    }

    @Test
    public void getNavigation_InvalidSite() {
        Navigation nav = this.portal.getNavigation(new SiteId("invalid"));
        Assert.assertNull((Object)nav);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNavigation_NullSiteId() {
        this.portal.getNavigation(null);
    }

    @Test
    public void getNode() {
        this.createNavigationChildren();
        Node node = this.navigation.getNode(new String[]{"parent", "child"});
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"child", (Object)node.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNode_EmptyPath() {
        String[] path = new String[]{};
        this.navigation.getNode(path);
    }

    @Test
    public void getNode_Invalid_Path() {
        this.createNavigationChildren();
        Node node = this.navigation.getNode(new String[]{"foo", "child"});
        Assert.assertNull((Object)node);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNode_NullNodePath() {
        this.navigation.getNode((NodePath)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNode_NullVisitor() {
        this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), null);
    }

    @Test
    public void getNode_With_Visitor() {
        this.createNavigationChildren();
        Node node = this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), Nodes.visitNone());
        Assert.assertNotNull((Object)node);
        Assert.assertFalse((boolean)node.isChildrenLoaded());
        node = this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), Nodes.visitChildren());
        Assert.assertTrue((boolean)node.isChildrenLoaded());
        Assert.assertNotNull((Object)node.getChild("child"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void loadNodes_NullVisitor() {
        this.navigation.getRootNode(null);
    }

    @Test
    public void moveNode() {
        Node root = this.navigation.getRootNode(Nodes.visitChildren());
        root.addChild("a").addChild("b").addChild("c").addChild("d");
        root.addChild("e").addChild("f").addChild("g").addChild("h");
        this.navigation.saveNode(root);
        root = this.navigation.getRootNode(Nodes.visitAll());
        Node d = root.getNode(new String[]{"a", "b", "c", "d"});
        Node h = root.getNode(new String[]{"e", "f", "g", "h"});
        this.navigation.refreshNode(h, Nodes.visitChildren());
        d.moveTo(h);
        this.navigation.saveNode(root);
        root = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertNull((Object)root.getNode(new String[]{"a", "b", "c", "d"}));
        Assert.assertNotNull((Object)root.getNode(new String[]{"e", "f", "g", "h", "d"}));
    }

    @Test
    public void moveNode_ReorderSaved() {
        Node root = this.navigation.getRootNode(Nodes.visitChildren());
        root.addChild("c");
        root.addChild("b");
        root.addChild("a");
        this.navigation.saveNode(root);
        root = this.navigation.getRootNode(Nodes.visitChildren());
        root.getChild("a").moveTo(0);
        root.getChild("c").moveTo(2);
        this.navigation.saveNode(root);
        root = this.navigation.getRootNode(Nodes.visitChildren());
        Assert.assertEquals((Object)"a", (Object)root.getChild(0).getName());
        Assert.assertEquals((Object)"b", (Object)root.getChild(1).getName());
        Assert.assertEquals((Object)"c", (Object)root.getChild(2).getName());
    }

    @Test
    public void moveNode_ReorderUnsaved() {
        Node root = this.navigation.getRootNode(Nodes.visitChildren());
        root.addChild("c");
        root.addChild("b");
        root.addChild("a");
        root.getChild("a").moveTo(0);
        root.getChild("c").moveTo(2);
        this.navigation.saveNode(root);
        root = this.navigation.getRootNode(Nodes.visitChildren());
        Assert.assertEquals((Object)"a", (Object)root.getChild(0).getName());
        Assert.assertEquals((Object)"b", (Object)root.getChild(1).getName());
        Assert.assertEquals((Object)"c", (Object)root.getChild(2).getName());
    }

    @Test
    public void refreshNode() {
        this.createNavigationChildren();
        Node nodeA = this.navigation.getRootNode(Nodes.visitAll());
        Node nodeB = this.navigation.getRootNode(Nodes.visitAll());
        nodeA.addChild("childA");
        this.navigation.saveNode(nodeA);
        Assert.assertNull((Object)nodeB.getChild("childA"));
        this.navigation.refreshNode(nodeB);
        Assert.assertNotNull((Object)nodeB.getChild("childA"));
    }

    @Test
    public void refreshNode_LoadChildren() {
        this.createNavigationChildren();
        Node n = this.navigation.getRootNode(Nodes.visitChildren());
        Node p = n.getChild("parent");
        Assert.assertTrue((boolean)n.isChildrenLoaded());
        Assert.assertFalse((boolean)p.isChildrenLoaded());
        this.navigation.refreshNode(p, Nodes.visitChildren());
        Assert.assertTrue((boolean)p.isChildrenLoaded());
    }

    @Test(expected=IllegalArgumentException.class)
    public void refreshNode_NullNode() {
        this.navigation.refreshNode(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void refreshNode_NullVisitor() {
        this.navigation.refreshNode(this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), null));
    }

    @Test
    public void refreshNode_WithVisitor() {
        this.createNavigationChildren();
        Node nodeA = this.navigation.getRootNode(Nodes.visitAll());
        Node nodeB = this.navigation.getRootNode(Nodes.visitAll());
        nodeA.addChild("childA").addChild("childA-1").addChild("childA-1-1");
        this.navigation.saveNode(nodeA);
        Assert.assertNull((Object)nodeB.getChild("childA"));
        this.navigation.refreshNode(nodeB, Nodes.visitNodes((int)3));
        Assert.assertNotNull((Object)nodeB.getChild("childA"));
        Assert.assertNotNull((Object)nodeB.getChild("childA").getChild("childA-1"));
        Assert.assertNotNull((Object)nodeB.getChild("childA").getChild("childA-1").getChild("childA-1-1"));
    }

    @Test
    public void removeNode() {
        this.createNavigationChildren();
        Assert.assertTrue((boolean)this.navigation.removeNode(NodePath.path((String[])new String[]{"parent", "child"})));
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertEquals((long)0L, (long)node.getChild("parent").getChildCount());
    }

    @Test(expected=EntityNotFoundException.class)
    public void removeNode_NodeNotFound() {
        this.navigation.removeNode(NodePath.path((String[])new String[]{"nosuch"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void removeNode_NullNode() {
        this.navigation.removeNode(null);
    }

    @Test
    public void saveNode() throws InterruptedException {
        this.createNavigationChildren();
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Node parent = node.getChild("parent");
        parent.addChild("child2");
        Assert.assertNull((Object)this.navigation.getRootNode(Nodes.visitAll()).getChild("parent").getChild("child2"));
        this.navigation.saveNode(parent);
        Assert.assertNotNull((Object)this.navigation.getRootNode(Nodes.visitAll()).getChild("parent").getChild("child2"));
    }

    @Test
    public void saveNode_Merge() {
        this.createNavigationChildren();
        Node nodeA = this.navigation.getRootNode(Nodes.visitAll());
        Node nodeB = this.navigation.getRootNode(Nodes.visitAll());
        nodeA.addChild("childA");
        this.navigation.saveNode(nodeA);
        nodeB.addChild("childB");
        this.navigation.saveNode(nodeB);
        Node nodeC = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertNotNull((Object)nodeC.getChild("childA"));
        Assert.assertNotNull((Object)nodeC.getChild("childB"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void saveNode_NullNode() {
        this.navigation.saveNode(null);
    }

    @Test
    public void saveNode_SaveChildSavesParent() {
        this.createNavigationChildren();
        Node node = this.navigation.getRootNode(Nodes.visitAll());
        Node parent = node.getChild("parent");
        parent.setIconName("new");
        Node child = parent.getNode(new String[]{"child"});
        child.setIconName("new");
        parent.addChild("child2");
        this.navigation.saveNode(child);
        node = this.navigation.getRootNode(Nodes.visitAll());
        Assert.assertEquals((Object)"new", (Object)node.getChild("parent").getIconName());
        Assert.assertEquals((long)2L, (long)node.getChild("parent").getChildCount());
        Assert.assertEquals((Object)"new", (Object)node.getChild("parent").getChild("child").getIconName());
    }

    @Test
    public void serialization() throws Exception {
        this.createNavigationChildren();
        Node parent = this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), Nodes.visitChildren());
        Node child = parent.getChild("child");
        this.navigation.refreshNode(child, Nodes.visitChildren());
        child.addChild("foo");
        child.setIconName("iconName");
        Node parentNode = SerializationUtils.serializeDeserialize(parent);
        Assert.assertEquals((Object)"parent", (Object)parentNode.getName());
        Assert.assertEquals((Object)((ApiNode)parent).context.getState(), (Object)((ApiNode)parentNode).context.getState());
        Assert.assertTrue((boolean)parentNode.isChildrenLoaded());
        Node childNode = parentNode.getChild("child");
        Assert.assertNotNull((Object)childNode);
        Assert.assertEquals((Object)((ApiNode)child).context.getState(), (Object)((ApiNode)childNode).context.getState());
        Assert.assertNotNull((Object)childNode.getParent());
        Assert.assertEquals((Object)"parent", (Object)childNode.getParent().getName());
        Node fooNode = childNode.getChild("foo");
        Assert.assertNotNull((Object)fooNode);
        Assert.assertEquals((Object)((ApiNode)child.getChild((String)"foo")).context.getState(), (Object)((ApiNode)fooNode).context.getState());
        Assert.assertTrue((childNode == fooNode.getParent() ? 1 : 0) != 0);
        Assert.assertTrue((parentNode.getParent() == childNode.getParent().getParent() ? 1 : 0) != 0);
    }

    @Test
    public void serialization_DisplayName() throws Exception {
        Node node = this.navigation.getRootNode(Nodes.visitAll()).addChild("parent");
        node.addChild("simple");
        node.addChild("extended");
        node.setDisplayName("parent");
        node.getChild("simple").setDisplayName("simple");
        LocalizedString localizedString = new LocalizedString(Locale.ENGLISH, "english");
        localizedString.setLocalizedValue(Locale.CHINA, "chinese");
        node.getChild("extended").setDisplayNames(localizedString);
        Node serialized = SerializationUtils.serializeDeserialize(node);
        Assert.assertEquals((Object)"parent", (Object)serialized.getDisplayName());
        Assert.assertEquals((Object)"simple", (Object)serialized.getChild("simple").getDisplayName());
        Assert.assertNotNull((Object)serialized.getChild("extended").getDisplayNames());
        Assert.assertEquals((Object)"english", (Object)serialized.getChild("extended").getDisplayNames().getLocalizedValue(Locale.ENGLISH).getValue());
        Assert.assertEquals((Object)"chinese", (Object)serialized.getChild("extended").getDisplayNames().getLocalizedValue(Locale.CHINA).getValue());
        this.navigation.saveNode(node);
        Node saved = this.navigation.getRootNode(Nodes.visitAll());
        serialized = SerializationUtils.serializeDeserialize(saved).getChild("parent");
        Assert.assertEquals((Object)"simple", (Object)serialized.getChild("simple").getDisplayName());
        Assert.assertNotNull((Object)serialized.getChild("extended").getDisplayNames());
        Assert.assertEquals((Object)"english", (Object)serialized.getChild("extended").getDisplayNames().getLocalizedValue(Locale.ENGLISH).getValue());
        Assert.assertEquals((Object)"chinese", (Object)serialized.getChild("extended").getDisplayNames().getLocalizedValue(Locale.CHINA).getValue());
    }

    @Test
    public void serialization_Move() throws Exception {
        this.createNavigationChildren();
        Node root = this.navigation.getRootNode(Nodes.visitAll());
        Node parent = root.getChild("parent");
        Node child = parent.getChild("child");
        child.moveTo(root);
        Assert.assertEquals((long)0L, (long)parent.getChildCount());
        Assert.assertEquals((long)2L, (long)root.getChildCount());
        Node serialized = SerializationUtils.serializeDeserialize(root);
        Assert.assertEquals((long)0L, (long)serialized.getChild("parent").getChildCount());
        Assert.assertEquals((long)2L, (long)serialized.getChildCount());
    }

    @Test
    public void serialization_multipath() throws Exception {
        this.createNavigationChildren();
        Node root = this.navigation.getRootNode(Nodes.visitAll());
        Node parent = root.getChild("parent");
        Node foo = parent.addChild("foo");
        foo.addChild("bar");
        Node child = parent.getChild("child");
        child.addChild("another-child");
        this.navigation.saveNode(root);
        Node rootNode = SerializationUtils.serializeDeserialize(root);
        Assert.assertNotNull((Object)rootNode.getNode(new String[]{"parent", "foo", "bar"}));
        Assert.assertNotNull((Object)rootNode.getNode(new String[]{"parent", "child", "another-child"}));
    }

    @Test
    public void serialization_Remove() throws Exception {
        this.createNavigationChildren();
        Node parent = this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), Nodes.visitAll());
        parent.removeChild("child");
        Assert.assertEquals((long)0L, (long)parent.getChildCount());
        Node parentNode = SerializationUtils.serializeDeserialize(parent);
        Assert.assertEquals((long)0L, (long)parentNode.getChildCount());
    }

    @Test
    public void serialization_Reorder() throws Exception {
        this.createNavigationChildren();
        Node parent = this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), Nodes.visitAll());
        parent.addChild("child2");
        parent.addChild("child3");
        this.navigation.saveNode(parent);
        this.navigation.getNode(parent.getNodePath(), Nodes.visitAll());
        Node child = parent.getChild("child3");
        child.moveTo(0);
        Node parentNode = SerializationUtils.serializeDeserialize(parent);
        Assert.assertEquals((Object)"child3", (Object)parentNode.getChild(0).getName());
        Assert.assertEquals((Object)"child", (Object)parentNode.getChild(1).getName());
        Assert.assertEquals((Object)"child2", (Object)parentNode.getChild(2).getName());
    }

    @Test
    public void serialization_Add() throws Exception {
        this.createNavigationChildren();
        Node parent = this.navigation.getNode(NodePath.path((String[])new String[]{"parent"}), Nodes.visitAll());
        parent.addChild("child2");
        Node parentNode = SerializationUtils.serializeDeserialize(parent);
        Assert.assertEquals((Object)"child", (Object)parentNode.getChild(0).getName());
        Assert.assertEquals((Object)"child2", (Object)parentNode.getChild(1).getName());
    }
}

