/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.KernelLifeCycle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.gatein.api.BasicPortalRequest;
import org.gatein.api.Portal;
import org.gatein.api.Util;
import org.gatein.api.common.URIResolver;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.page.PageId;
import org.gatein.api.security.Permission;
import org.gatein.api.security.User;
import org.gatein.api.site.SiteId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/mop/navigation/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.resources-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.api-configuration.xml")})
public abstract class AbstractApiTest {
    protected static final Log LOG = ExoLogger.getLogger(AbstractApiTest.class);
    @ClassRule
    public static KernelLifeCycle kernelLifeCycle = new KernelLifeCycle();
    protected PortalContainer container;
    protected Portal portal;
    protected SiteId defaultSiteId;
    protected IdentityRegistry identityRegistry;

    @After
    public void after() throws Exception {
        BasicPortalRequest.setInstance(null);
        try {
            this.cleanup();
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    @Before
    public void before() throws Exception {
        try {
            this.defaultSiteId = new SiteId("classic2");
            this.container = kernelLifeCycle.getContainer();
            this.portal = (Portal)this.container.getComponentInstanceOfType(Portal.class);
            Assert.assertNotNull((String)"Portal component not found in container", (Object)this.portal);
            this.identityRegistry = (IdentityRegistry)this.container.getComponentInstanceOfType(IdentityRegistry.class);
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
            memberships.add(new MembershipEntry("/platform/users", "member"));
            Identity john = new Identity("john", memberships);
            this.identityRegistry.register(john);
            BasicPortalRequest.setInstance((BasicPortalRequest)new BasicPortalRequest(new User("john"), this.defaultSiteId, NodePath.root(), Locale.ENGLISH, this.portal, (URIResolver)new BasicPortalRequest.BasicURIResolver("/portal")));
        }
        catch (Exception e) {
            LOG.error((Object)"Error starting container", (Throwable)e);
        }
    }

    protected void createSite(SiteId siteId, String ... pages) {
        this.createSite(siteId, true, pages);
    }

    protected void createSite(SiteId siteId, boolean createNav, String ... pages) {
        try {
            LayoutService dataStorage = (LayoutService)this.container.getComponentInstanceOfType(LayoutService.class);
            NavigationService navService = (NavigationService)this.container.getComponentInstanceOfType(NavigationService.class);
            SiteKey siteKey = Util.from((SiteId)siteId);
            PortalConfig config = new PortalConfig(siteKey.getTypeName(), siteKey.getName());
            config.setAccessPermissions(Util.from((Permission)Permission.everyone()));
            dataStorage.create(config);
            if (createNav) {
                NavigationContext nav = new NavigationContext(new SiteKey(siteKey.getTypeName(), siteKey.getName()), new NavigationState(null));
                navService.saveNavigation(nav);
            }
            this.createPage(siteId, pages);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating site", (Throwable)e);
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    protected void createPage(SiteId siteId, String ... pages) {
        PageStorage pageService = (PageStorage)this.container.getComponentInstanceOfType(PageStorage.class);
        SiteKey siteKey = Util.from((SiteId)siteId);
        for (String page : pages) {
            pageService.savePage(new PageContext(new PageKey(siteKey, page), new PageState("displayName", "description", false, false, false, null, null, Arrays.asList("Everyone"), "Everyone", PageType.PAGE.name(), null)));
        }
    }

    protected void setPermission(PageId pageId, String editPermission, String ... accessPermissions) {
        PageKey pageKey = Util.from((PageId)pageId);
        PageStorage pageService = (PageStorage)this.container.getComponentInstanceOfType(PageStorage.class);
        PageContext p = pageService.loadPage(pageKey);
        p.setState(p.getState().builder().editPermission(editPermission).accessPermissions(accessPermissions).build());
        pageService.savePage(p);
    }

    private void cleanup() throws Exception {
        SiteType[] types;
        LayoutService dataStorage = (LayoutService)this.container.getComponentInstanceOfType(LayoutService.class);
        for (SiteType type : types = new SiteType[]{SiteType.PORTAL, SiteType.GROUP, SiteType.USER}) {
            Query q = new Query(type.getName(), null, PortalConfig.class);
            ListAccess la = dataStorage.find2(q, null);
            for (PortalConfig portalConfig : (PortalConfig[])la.load(0, la.getSize())) {
                dataStorage.remove(portalConfig);
            }
        }
    }
}

