/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.Arrays;
import java.util.Date;
import org.gatein.api.AbstractApiTest;
import org.gatein.api.SerializationUtils;
import org.gatein.api.common.Filter;
import org.gatein.api.navigation.ApiFilteredNode;
import org.gatein.api.navigation.ApiNodeTest;
import org.gatein.api.navigation.FilteredNode;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.navigation.PublicationDate;
import org.gatein.api.navigation.Visibility;
import org.gatein.api.page.PageId;
import org.gatein.api.security.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApiFilteredNodeTest
extends AbstractApiTest {
    private Filter<Node> filter;
    private FilteredNode filtered;
    private Node root;
    private Navigation navigation;

    @Test
    public void addChild() {
        this.filtered.addChild("child5");
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child2", "child4", "child5");
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child1", "child2", "child3", "child4", "child5");
    }

    @Test
    public void addChild_IndexFirst() {
        this.filtered.addChild(0, "child5");
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child5", "child0", "child2", "child4");
        ApiNodeTest.assertIterator(this.root.iterator(), "child5", "child0", "child1", "child2", "child3", "child4");
    }

    @Test
    public void addChild_IndexLast() {
        this.filtered.addChild(3, "child5");
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child2", "child4", "child5");
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child1", "child2", "child3", "child4", "child5");
    }

    @Test
    public void addChild_IndexMiddle() {
        this.filtered.addChild(1, "child5");
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child5", "child2", "child4");
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child1", "child5", "child2", "child3", "child4");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void addChild_IndexOutOfBounds() {
        this.filtered.addChild(4, "child5");
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.createSite(this.defaultSiteId, new String[0]);
        this.navigation = this.portal.getNavigation(this.defaultSiteId);
        this.root = this.navigation.getRootNode(Nodes.visitAll());
        this.root.addChild("child0");
        this.root.addChild("child1");
        this.root.addChild("child2");
        this.root.addChild("child3");
        this.root.addChild("child4");
        this.filter = new Filter<Node>(){

            public boolean accept(Node object) {
                return !object.getName().equals("child1") && !object.getName().equals("child3");
            }
        };
        this.filtered = this.root.filter().show(this.filter);
    }

    @Test
    public void getChild() {
        Assert.assertNotNull((Object)this.filtered.getChild("child0"));
        Assert.assertTrue((boolean)(this.filtered.getChild("child0") instanceof ApiFilteredNode));
        Assert.assertNull((Object)this.filtered.getChild("child1"));
    }

    @Test
    public void getChild_Index() {
        Assert.assertEquals((Object)"child0", (Object)this.filtered.getChild(0).getName());
        Assert.assertTrue((boolean)(this.filtered.getChild(0) instanceof ApiFilteredNode));
        Assert.assertEquals((Object)"child2", (Object)this.filtered.getChild(1).getName());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getChild_IndexOutOfBounds() {
        this.filtered.getChild(4);
    }

    @Test
    public void getChildCount() {
        Assert.assertEquals((long)3L, (long)this.filtered.getChildCount());
    }

    @Test
    public void getDescendant() {
        this.root.getChild("child0").addChild("child0-0");
        this.root.getChild("child1").addChild("child1-0");
        Assert.assertNotNull((Object)this.filtered.getNode(NodePath.path((String[])new String[]{"child0", "child0-0"})));
        Assert.assertTrue((boolean)(this.filtered.getNode(NodePath.path((String[])new String[]{"child0", "child0-0"})) instanceof ApiFilteredNode));
        Assert.assertNull((Object)this.filtered.getNode(NodePath.path((String[])new String[]{"child1"})));
        Assert.assertNull((Object)this.filtered.getNode(NodePath.path((String[])new String[]{"child1", "child0-0"})));
    }

    @Test
    public void hasChild() {
        Assert.assertTrue((boolean)this.filtered.hasChild("child0"));
        Assert.assertFalse((boolean)this.filtered.hasChild("child1"));
        Assert.assertFalse((boolean)this.filtered.hasChild("nosuch"));
    }

    @Test
    public void indexOf() {
        Assert.assertEquals((long)0L, (long)this.filtered.indexOf("child0"));
        Assert.assertEquals((long)1L, (long)this.filtered.indexOf("child2"));
    }

    @Test
    public void iterator() {
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child2", "child4");
        Assert.assertTrue((boolean)(this.filtered.iterator().next() instanceof ApiFilteredNode));
    }

    @Test
    public void moveTo_First() {
        this.filtered.getChild("child4").moveTo(0);
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child4", "child0", "child2");
        ApiNodeTest.assertIterator(this.root.iterator(), "child4", "child0", "child1", "child2", "child3");
    }

    @Test
    public void moveTo_Last() {
        this.filtered.getChild("child4").moveTo(2);
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child2", "child4");
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child1", "child2", "child3", "child4");
    }

    @Test
    public void moveTo_Middle() {
        this.filtered.getChild("child4").moveTo(1);
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child4", "child2");
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child1", "child4", "child2", "child3");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void moveTo_OutOfBounds() {
        this.filtered.getChild("child4").moveTo(3);
    }

    @Test
    public void moveTo_Parent() {
        Node parent0 = this.root.addChild("parent0");
        parent0.addChild("child0");
        parent0.addChild("child1");
        parent0.addChild("child2");
        this.filtered.addChild("parent1").addChild("child5").moveTo(1, parent0);
        ApiNodeTest.assertIterator(this.filtered.getChild("parent0").iterator(), "child0", "child5", "child2");
        ApiNodeTest.assertIterator(this.root.getChild("parent0").iterator(), "child0", "child1", "child5", "child2");
    }

    @Test(expected=IllegalArgumentException.class)
    public void show_NullFilter() {
        this.root.filter().show(null);
    }

    @Test
    public void showAll() {
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child2", "child4");
        this.filtered = this.filtered.showAll();
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child1", "child2", "child3", "child4");
    }

    @Test
    public void showDefault() {
        this.createPage(this.defaultSiteId, "page1");
        this.setPermission(new PageId(this.defaultSiteId, "page1"), "Everyone", "*:/platform/administrators");
        this.root.getChild("child1").setVisibility(false);
        this.root.getChild("child2").setPageId(new PageId(this.defaultSiteId, "page1"));
        ApiNodeTest.assertIterator(this.root.filter().showDefault().iterator(), "child0", "child3", "child4");
    }

    @Test
    public void showVisible() {
        this.root.getChild("child1").setVisibility(false);
        this.root.getChild("child2").setVisibility(new Visibility(Visibility.Status.SYSTEM));
        this.root.getChild("child3").setVisibility(PublicationDate.endingOn((Date)new Date(System.currentTimeMillis() - 1000L)));
        this.filtered = this.root.filter().showVisible();
        ApiNodeTest.assertIterator(this.filtered.iterator(), "child0", "child4");
    }

    @Test
    public void showHasAccess() {
        this.createPage(this.defaultSiteId, "page1");
        this.setPermission(new PageId(this.defaultSiteId, "page1"), "Everyone", "*:/platform/administrators");
        this.createPage(this.defaultSiteId, "page2");
        this.setPermission(new PageId(this.defaultSiteId, "page2"), "Everyone", "Everyone");
        this.root.getChild("child1").setPageId(new PageId(this.defaultSiteId, "page1"));
        this.root.getChild("child2").setPageId(new PageId(this.defaultSiteId, "page2"));
        ApiNodeTest.assertIterator(this.root.filter().showHasAccess(new User("a")).iterator(), "child0", "child2", "child3", "child4");
        ApiNodeTest.assertIterator(this.root.filter().showHasAccess(new User("root")).iterator(), "child0", "child1", "child2", "child3", "child4");
    }

    @Test
    public void serialization() throws Exception {
        this.createPage(this.defaultSiteId, "page1");
        this.setPermission(new PageId(this.defaultSiteId, "page1"), "Everyone", "*:/platform/administrators");
        this.createPage(this.defaultSiteId, "page2");
        this.setPermission(new PageId(this.defaultSiteId, "page2"), "Everyone", "Everyone");
        this.root.getChild("child1").setPageId(new PageId(this.defaultSiteId, "page1"));
        this.root.getChild("child2").setPageId(new PageId(this.defaultSiteId, "page2"));
        this.root.getChild("child3").setVisibility(false);
        this.navigation.saveNode(this.root);
        FilteredNode filter = this.root.filter().showVisible().showHasAccess(new User("a")).show((Filter)new SerilizationFilter("child4"));
        ApiNodeTest.assertIterator(filter.iterator(), "child0", "child2");
        FilteredNode rootNode = SerializationUtils.serializeDeserialize(filter);
        ApiNodeTest.assertIterator(rootNode.showAll().iterator(), "child0", "child1", "child2", "child3", "child4");
        ApiNodeTest.assertIterator(rootNode.iterator(), "child0", "child2");
    }

    @Test
    public void showHasEdit() {
        this.createPage(this.defaultSiteId, "page1");
        this.setPermission(new PageId(this.defaultSiteId, "page1"), "*:/platform/administrators", "Everyone");
        this.createPage(this.defaultSiteId, "page2");
        this.setPermission(new PageId(this.defaultSiteId, "page2"), "Everyone", "Everyone");
        this.root.getChild("child1").setPageId(new PageId(this.defaultSiteId, "page1"));
        this.root.getChild("child2").setPageId(new PageId(this.defaultSiteId, "page2"));
        ApiNodeTest.assertIterator(this.root.filter().showHasEdit(new User("a")).iterator(), "child0", "child2", "child3", "child4");
        ApiNodeTest.assertIterator(this.root.filter().showHasEdit(new User("root")).iterator(), "child0", "child1", "child2", "child3", "child4");
    }

    @Test
    public void sourceNotChanged() {
        this.root.filter().show(this.filter);
        Assert.assertEquals((long)5L, (long)this.root.getChildCount());
        Assert.assertNotNull((Object)this.root.getChild("child1"));
    }

    public static class SerilizationFilter
    implements Filter<Node> {
        private String[] hide;

        public SerilizationFilter(String ... hide) {
            this.hide = hide;
        }

        public boolean accept(Node n) {
            return Arrays.binarySearch(this.hide, n.getName()) < 0;
        }
    }
}

