/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pc;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.pc.ExoResourceBundleFactory;
import org.exoplatform.portal.pc.GlobalPortletMetaData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.impl.deployment.DeploymentException;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployer;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployment;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;

public class ExoPortletApplicationDeployer
extends PortletApplicationDeployer {
    private final Log log = ExoLogger.getLogger(ExoPortletApplicationDeployer.class);

    public ExoPortletApplicationDeployer() {
        this(null);
    }

    public ExoPortletApplicationDeployer(ContainerPortletInvoker containerPortletInvoker) {
        super(containerPortletInvoker);
    }

    protected PortletApplication10MetaData buildPortletApplicationMetaData(ServletContext webApp) throws DeploymentException {
        PortletApplication10MetaData md;
        block7: {
            md = super.buildPortletApplicationMetaData(webApp);
            if (md != null) {
                md.setResourceBundleFactoryName(ExoResourceBundleFactory.class.getName());
                String globalPortletLocation = PropertyManager.getProperty((String)"gatein.portlet.config");
                if (globalPortletLocation != null) {
                    try {
                        GlobalPortletMetaData globalPortletMetaData = this.loadGlobalMetadata(globalPortletLocation);
                        if (globalPortletMetaData != null) {
                            globalPortletMetaData.mergeTo(md);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Complete merging global portlet metadata to portlet application " + webApp.getServletContextName()));
                        }
                        break block7;
                    }
                    catch (Exception ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Error during merge global portlet metadata to portlet application " + webApp.getServletContextName()), (Throwable)ex);
                        }
                        break block7;
                    }
                }
                this.log.warn((Object)"The global portlet metadata is not configured");
            }
        }
        return md;
    }

    protected PortletApplicationDeployment createPortletApplicationDeployment(ServletContext webApp, PortletApplication10MetaData metaData) {
        return super.createPortletApplicationDeployment(webApp, metaData);
    }

    private GlobalPortletMetaData loadGlobalMetadata(String globalPortletLocation) throws Exception {
        File globalPortletFile = new File(globalPortletLocation);
        if (globalPortletFile.exists()) {
            try (FileInputStream in = new FileInputStream(globalPortletFile);){
                GlobalPortletMetaData globalPortletMetaData = GlobalPortletMetaData.unmarshalling(in);
                return globalPortletMetaData;
            }
        }
        return null;
    }
}

