/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.user;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleManager;

public class HttpUserPortalContext
implements UserPortalContext {
    private HttpServletRequest httpRequest;

    public HttpUserPortalContext(HttpServletRequest servletRequest) {
        this.httpRequest = servletRequest;
    }

    @Override
    public ResourceBundle getBundle(UserNavigation navigation) {
        ResourceBundleManager rbMgr = (ResourceBundleManager)ExoContainerContext.getService(ResourceBundleManager.class);
        return rbMgr.getNavigationResourceBundle(this.getLocaleAsString(), this.getSiteType(navigation), this.getSiteName(navigation));
    }

    private String getSiteName(UserNavigation navigation) {
        return navigation.getKey().getName();
    }

    private String getSiteType(UserNavigation navigation) {
        return navigation.getKey().getTypeName();
    }

    private String getLocaleAsString() {
        return LocaleContextInfo.getLocaleAsString((Locale)this.getUserLocale());
    }

    @Override
    public Locale getUserLocale() {
        return LocaleContextInfoUtils.computeLocale((HttpServletRequest)this.httpRequest);
    }
}

