/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.AbstractConfigTest;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.test.mocks.servlet.MockServletRequest;
import org.gatein.common.util.Tools;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class TestUserPortalConfigService
extends AbstractConfigTest {
    private UserPortalConfigService userPortalConfigSer_;
    private OrganizationService orgService_;
    private LayoutService layoutService;
    private PageStorage pageStorage;
    private Authenticator authenticator;
    private ListenerService listenerService;
    private LinkedList<Event> events;
    private boolean registered = false;
    private SiteStorage siteStorage;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Listener listener = new Listener(){

            public void onEvent(Event event) throws Exception {
                TestUserPortalConfigService.this.events.add(event);
            }
        };
        PortalContainer container = this.getContainer();
        this.userPortalConfigSer_ = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        this.orgService_ = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        this.authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
        this.listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class);
        this.events = new LinkedList();
        this.layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        this.pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        this.siteStorage = (SiteStorage)container.getComponentInstanceOfType(SiteStorage.class);
        if (!this.registered) {
            this.listenerService.addListener(LayoutService.PAGE_CREATED, (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.page.page_destroyed", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.page.page_updated", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_created", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_destroyed", (ListenerBase)listener);
            this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_updated", (ListenerBase)listener);
        }
    }

    private static Map<String, UserNavigation> toMap(UserPortal cfg) {
        return TestUserPortalConfigService.toMap(cfg.getNavigations());
    }

    private static Map<String, UserNavigation> toMap(List<UserNavigation> navigations) {
        HashMap<String, UserNavigation> map = new HashMap<String, UserNavigation>();
        for (UserNavigation nav : navigations) {
            map.put(nav.getKey().getType().getName() + "::" + nav.getKey().getName(), nav);
        }
        return map;
    }

    public void testComputePortalSitePath() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                NewPortalConfig config = new NewPortalConfig("classpath:/org/exoplatform/portal/config/conf");
                config.setOwnerType("portal");
                config.setOverrideMode(true);
                config.setImportMode("merge");
                HashSet<String> owners = new HashSet<String>();
                owners.add("test2");
                config.setPredefinedOwner(owners);
                NewPortalConfigListener newPortalConfigListener = new NewPortalConfigListener(TestUserPortalConfigService.this.userPortalConfigSer_, TestUserPortalConfigService.this.layoutService, (ConfigurationManager)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(ConfigurationManager.class), new InitParams(), (NavigationService)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(NavigationService.class), (DescriptionStorage)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(DescriptionStorage.class), (UserACL)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(UserACL.class), (LocaleConfigService)TestUserPortalConfigService.this.getContainer().getComponentInstanceOfType(LocaleConfigService.class));
                newPortalConfigListener.initPortalConfigDB(config);
                newPortalConfigListener.initPageDB(config);
                newPortalConfigListener.initPageNavigationDB(config);
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("test2", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"test2", (String)portalCfg.getName());
                String path = TestUserPortalConfigService.this.userPortalConfigSer_.computePortalSitePath("test2", (HttpServletRequest)new MockServletRequest(this, null, Locale.ENGLISH){

                    public String getRemoteUser() {
                        return "root";
                    }
                });
                TestCase.assertEquals((String)"/portal/test2/test", (String)path);
                TestUserPortalConfigService.this.restartTransaction();
                TestUserPortalConfigService.this.layoutService.remove(PageKey.parse((String)"portal::test2::test"));
                TestUserPortalConfigService.this.restartTransaction();
                path = TestUserPortalConfigService.this.userPortalConfigSer_.computePortalSitePath("test2", (HttpServletRequest)new MockServletRequest(this, null, Locale.ENGLISH){

                    public String getRemoteUser() {
                        return "root";
                    }
                });
                TestCase.assertEquals((String)"/portal/test2/home/page", (String)path);
            }
        }.execute("root");
    }

    public void testUpdatePortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                TestCase.assertEquals((String)"en", (String)portalCfg.getLocale());
                portalCfg.setLocale("fr");
                TestUserPortalConfigService.this.layoutService.save(portalCfg);
                userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertEquals((String)"fr", (String)portalCfg.getLocale());
            }
        }.execute("root");
    }

    public void testEnforcedReimporting() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                TestCase.assertEquals((String)"en", (String)portalCfg.getLocale());
                portalCfg.setLocale("fr");
                TestUserPortalConfigService.this.layoutService.save(portalCfg);
                userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertEquals((String)"fr", (String)portalCfg.getLocale());
                TestUserPortalConfigService.this.userPortalConfigSer_.start();
                userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertEquals((String)"en", (String)portalCfg.getLocale());
            }
        }.execute("root");
    }

    public void testRootGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)("expected to have 4 navigations instead of " + String.valueOf(navigations)), (int)4, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/administrators"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/organization/management/executive-board"));
            }
        }.execute("root");
    }

    public void testGetAllPortalNames() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertTrue((boolean)TestUserPortalConfigService.this.userPortalConfigSer_.getSiteNames(SiteType.PORTAL, 0, 0).contains("system"));
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_;
                TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = "system";
                try {
                    TestCase.assertFalse((boolean)TestUserPortalConfigService.this.userPortalConfigSer_.getSiteNames(SiteType.PORTAL, 0, 0).contains("system"));
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = originalGlobalPortal;
                }
            }
        }.execute("root");
    }

    public void testGetSites() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestUserPortalConfigService.this.userPortalConfigSer_.removeUserPortalConfig("jazz");
                int size = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalSites().size();
                TestCase.assertTrue((size >= 5 ? 1 : 0) != 0);
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_;
                TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = "system";
                TestUserPortalConfigService.this.userPortalConfigSer_.siteFilter.setExcludedSiteName(TestUserPortalConfigService.this.userPortalConfigSer_.getGlobalPortal());
                try {
                    TestCase.assertEquals((int)(size - 1), (int)TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalSites().size());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = originalGlobalPortal;
                }
            }
        }.execute("root");
    }

    public void testGetGlobalUserPortalConfig() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertFalse((boolean)navigations.containsKey("portal::" + TestUserPortalConfigService.this.userPortalConfigSer_.getGlobalPortal()));
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_;
                TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = "system";
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                    userPortal = userPortalCfg.getUserPortal();
                    navigations = TestUserPortalConfigService.toMap(userPortal);
                    TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                    TestCase.assertTrue((boolean)navigations.containsKey("portal::system"));
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = originalGlobalPortal;
                }
            }
        }.execute("root");
    }

    public void testGetGlobalUserNodes() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
                filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
                filterConfigBuilder.withTemporalCheck();
                UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                Collection nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig);
                TestCase.assertNotNull((Object)nodes);
                int initialNodesSize = nodes.size();
                TestCase.assertTrue((initialNodesSize > 0 ? 1 : 0) != 0);
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_;
                TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = "systemtest";
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                    portalCfg = userPortalCfg.getPortalConfig();
                    userPortal = userPortalCfg.getUserPortal();
                    nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig);
                    TestCase.assertNotNull((Object)nodes);
                    TestCase.assertEquals((int)(initialNodesSize + 1), (int)nodes.size());
                    UserNode homeNode = (UserNode)nodes.iterator().next();
                    TestCase.assertEquals((String)"home", (String)homeNode.getName());
                    TestCase.assertEquals((String)"classic", (String)homeNode.getNavigation().getKey().getName());
                    UserNode lastUserNode = (UserNode)new ArrayList(nodes).get(initialNodesSize);
                    TestCase.assertEquals((String)"systemhome", (String)lastUserNode.getName());
                    TestCase.assertEquals((String)"systemtest", (String)lastUserNode.getNavigation().getKey().getName());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = originalGlobalPortal;
                }
            }
        }.execute("root");
    }

    public void testGetUserNodesGlobalNotIncluded() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
                filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
                filterConfigBuilder.withTemporalCheck();
                UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                Collection nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig, false);
                TestCase.assertNotNull((Object)nodes);
                int initialNodesSize = nodes.size();
                TestCase.assertTrue((initialNodesSize > 0 ? 1 : 0) != 0);
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_;
                TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = "systemtest";
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                    portalCfg = userPortalCfg.getPortalConfig();
                    userPortal = userPortalCfg.getUserPortal();
                    nodes = userPortal.getNodes(SiteType.PORTAL, Scope.ALL, filterConfig, false);
                    TestCase.assertNotNull((Object)nodes);
                    TestCase.assertEquals((int)initialNodesSize, (int)nodes.size());
                    UserNode homeNode = (UserNode)nodes.iterator().next();
                    TestCase.assertEquals((String)"home", (String)homeNode.getName());
                    TestCase.assertEquals((String)"classic", (String)homeNode.getNavigation().getKey().getName());
                    UserNode lastUserNode = (UserNode)new ArrayList(nodes).get(nodes.size() - 1);
                    TestCase.assertEquals((String)"webexplorer", (String)lastUserNode.getName());
                    TestCase.assertEquals((String)"classic", (String)lastUserNode.getNavigation().getKey().getName());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = originalGlobalPortal;
                }
            }
        }.execute("root");
    }

    public void testGetGlobalUserNode() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal);
                UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
                filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
                filterConfigBuilder.withTemporalCheck();
                UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
                UserNode userNode = userPortal.resolvePath(filterConfig, "systemhome");
                TestCase.assertNotNull((Object)userNode);
                TestCase.assertEquals((String)"home", (String)userNode.getName());
                String originalGlobalPortal = TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_;
                TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = "systemtest";
                try {
                    userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "john");
                    portalCfg = userPortalCfg.getPortalConfig();
                    userPortal = userPortalCfg.getUserPortal();
                    userNode = userPortal.resolvePath(filterConfig, "systemhome");
                    TestCase.assertNotNull((Object)userNode);
                    TestCase.assertEquals((String)"systemhome", (String)userNode.getName());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.globalPortal_ = originalGlobalPortal;
                }
            }
        }.execute("root");
    }

    public void testJohnGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "john");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)("expected to have 4 navigations instead of " + String.valueOf(navigations)), (int)4, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/administrators"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
            }
        }.execute("john");
    }

    public void testMaryGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "mary");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((int)2, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
            }
        }.execute("mary");
    }

    public void testGuestGetUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", null);
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"classic", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)String.valueOf(navigations), (int)1, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::classic"));
            }
        }.execute(null);
    }

    public void testGetMetaPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                PortalConfig portalConfig = TestUserPortalConfigService.this.userPortalConfigSer_.getMetaPortalConfig();
                TestCase.assertNotNull((Object)portalConfig);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalConfig.getType());
                TestCase.assertEquals((String)"classic", (String)portalConfig.getName());
            }
        }.execute(null);
    }

    public void testNavigationOrder() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("classic", "root");
                UserPortal userPortal = userPortalCfg.getUserPortal();
                List navigations = userPortal.getNavigations();
                TestCase.assertEquals((String)("expected to have 4 navigations instead of " + String.valueOf(navigations)), (int)4, (int)navigations.size());
                TestCase.assertEquals((String)"classic", (String)((UserNavigation)navigations.get(0)).getKey().getName());
                TestCase.assertEquals((String)"/platform/administrators", (String)((UserNavigation)navigations.get(1)).getKey().getName());
                TestCase.assertEquals((String)"/organization/management/executive-board", (String)((UserNavigation)navigations.get(2)).getKey().getName());
                TestCase.assertEquals((String)"/platform/users", (String)((UserNavigation)navigations.get(3)).getKey().getName());
            }
        }.execute("root");
    }

    public void testCreateUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestUserPortalConfigService.this.userPortalConfigSer_.createUserPortalConfig(PortalConfig.PORTAL_TYPE, "jazz", "test");
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("jazz", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                PortalConfig portalCfg = userPortalCfg.getPortalConfig();
                TestCase.assertNotNull((Object)portalCfg);
                TestCase.assertEquals((String)PortalConfig.PORTAL_TYPE, (String)portalCfg.getType());
                TestCase.assertEquals((String)"jazz", (String)portalCfg.getName());
                UserPortal userPortal = userPortalCfg.getUserPortal();
                TestCase.assertNotNull((Object)userPortal.getNavigations());
                Map<String, UserNavigation> navigations = TestUserPortalConfigService.toMap(userPortal);
                TestCase.assertEquals((String)("expected to have 4 navigations instead of " + String.valueOf(navigations)), (int)4, (int)navigations.size());
                TestCase.assertTrue((boolean)navigations.containsKey("portal::jazz"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/administrators"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/organization/management/executive-board"));
                TestCase.assertTrue((boolean)navigations.containsKey("group::/platform/users"));
                this.queryPage();
            }

            private void queryPage() {
                try {
                    TestUserPortalConfigService.this.pageStorage.findPages(0, 10, SiteType.PORTAL, null, null, null);
                }
                catch (Exception ex) {
                    TestCase.assertTrue((String)"Exception while querying pages with new portal", (boolean)false);
                }
            }
        }.execute("root");
    }

    public void testCreateGroupPortalConfigWithDefaultTemplate() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                PortalConfig groupPortalConfig;
                String groupId;
                String originalDefaultGroupSiteTemplate = TestUserPortalConfigService.this.userPortalConfigSer_.getDefaultGroupSiteTemplate();
                TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultGroupSiteTemplate("group");
                try {
                    groupId = "/groupTemplate101";
                    TestUserPortalConfigService.this.userPortalConfigSer_.createGroupSite(groupId);
                    groupPortalConfig = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, groupId);
                    TestCase.assertNotNull((Object)groupPortalConfig);
                    TestCase.assertNotNull((Object)groupPortalConfig.getPortalLayout());
                    TestCase.assertNotNull((Object)groupPortalConfig.getPortalLayout().getChildren());
                    TestCase.assertEquals((int)4, (int)groupPortalConfig.getPortalLayout().getChildren().size());
                    TestCase.assertFalse((boolean)groupPortalConfig.isDefaultLayout());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultGroupSiteTemplate(originalDefaultGroupSiteTemplate);
                }
                TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultGroupSiteTemplate("fake");
                try {
                    groupId = "/groupTemplate102";
                    TestUserPortalConfigService.this.userPortalConfigSer_.createGroupSite(groupId);
                    groupPortalConfig = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, groupId);
                    TestCase.assertNotNull((Object)groupPortalConfig);
                    TestCase.assertNotNull((Object)groupPortalConfig.getPortalLayout());
                    TestCase.assertNotNull((Object)groupPortalConfig.getPortalLayout().getChildren());
                    TestCase.assertEquals((int)1, (int)groupPortalConfig.getPortalLayout().getChildren().size());
                    TestCase.assertEquals(PageBody.class, ((ModelObject)groupPortalConfig.getPortalLayout().getChildren().get(0)).getClass());
                    TestCase.assertTrue((boolean)groupPortalConfig.isDefaultLayout());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultGroupSiteTemplate(originalDefaultGroupSiteTemplate);
                }
                TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultGroupSiteTemplate(null);
                try {
                    groupId = "/groupTemplate103";
                    TestUserPortalConfigService.this.userPortalConfigSer_.createGroupSite(groupId);
                    groupPortalConfig = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, groupId);
                    TestCase.assertNotNull((Object)groupPortalConfig);
                    TestCase.assertNotNull((Object)groupPortalConfig.getPortalLayout());
                    TestCase.assertNotNull((Object)groupPortalConfig.getPortalLayout().getChildren());
                    TestCase.assertEquals((int)1, (int)groupPortalConfig.getPortalLayout().getChildren().size());
                    TestCase.assertEquals(PageBody.class, ((ModelObject)groupPortalConfig.getPortalLayout().getChildren().get(0)).getClass());
                    TestCase.assertTrue((boolean)groupPortalConfig.isDefaultLayout());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultGroupSiteTemplate(originalDefaultGroupSiteTemplate);
                }
            }
        }.execute("root");
    }

    public void testCreateUserPortalConfigWithDefaultTemplate() {
        new UnitTest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                PortalConfig userPortalConfig;
                String userId;
                String originalDefaultUserSiteTemplate = TestUserPortalConfigService.this.userPortalConfigSer_.getDefaultUserSiteTemplate();
                TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultUserSiteTemplate("user");
                try {
                    userId = "/userTemplate101";
                    TestUserPortalConfigService.this.userPortalConfigSer_.createUserSite(userId);
                    userPortalConfig = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, userId);
                    TestCase.assertNotNull((Object)userPortalConfig);
                    TestCase.assertNotNull((Object)userPortalConfig.getPortalLayout());
                    TestCase.assertNotNull((Object)userPortalConfig.getPortalLayout().getChildren());
                    TestCase.assertEquals((int)2, (int)userPortalConfig.getPortalLayout().getChildren().size());
                    TestCase.assertFalse((boolean)userPortalConfig.isDefaultLayout());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultUserSiteTemplate(originalDefaultUserSiteTemplate);
                }
                TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultUserSiteTemplate("fake");
                try {
                    userId = "userTemplate102";
                    TestUserPortalConfigService.this.userPortalConfigSer_.createUserSite(userId);
                    userPortalConfig = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, userId);
                    TestCase.assertNotNull((Object)userPortalConfig);
                    TestCase.assertNotNull((Object)userPortalConfig.getPortalLayout());
                    TestCase.assertNotNull((Object)userPortalConfig.getPortalLayout().getChildren());
                    TestCase.assertEquals((int)1, (int)userPortalConfig.getPortalLayout().getChildren().size());
                    TestCase.assertEquals(PageBody.class, ((ModelObject)userPortalConfig.getPortalLayout().getChildren().get(0)).getClass());
                    TestCase.assertTrue((boolean)userPortalConfig.isDefaultLayout());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultUserSiteTemplate(originalDefaultUserSiteTemplate);
                }
                TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultUserSiteTemplate(null);
                try {
                    userId = "userTemplate103";
                    TestUserPortalConfigService.this.userPortalConfigSer_.createUserSite(userId);
                    userPortalConfig = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, userId);
                    TestCase.assertNotNull((Object)userPortalConfig);
                    TestCase.assertNotNull((Object)userPortalConfig.getPortalLayout());
                    TestCase.assertNotNull((Object)userPortalConfig.getPortalLayout().getChildren());
                    TestCase.assertEquals((int)1, (int)userPortalConfig.getPortalLayout().getChildren().size());
                    TestCase.assertEquals(PageBody.class, ((ModelObject)userPortalConfig.getPortalLayout().getChildren().get(0)).getClass());
                    TestCase.assertTrue((boolean)userPortalConfig.isDefaultLayout());
                }
                finally {
                    TestUserPortalConfigService.this.userPortalConfigSer_.setDefaultUserSiteTemplate(originalDefaultUserSiteTemplate);
                }
            }
        }.execute("root");
    }

    public void testRemoveUserPortalConfig() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestUserPortalConfigService.this.userPortalConfigSer_.createUserPortalConfig(PortalConfig.PORTAL_TYPE, "jazz", "test");
                UserPortalConfig userPortalCfg = TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("jazz", "root");
                TestCase.assertNotNull((Object)userPortalCfg);
                TestUserPortalConfigService.this.restartTransaction();
                TestUserPortalConfigService.this.userPortalConfigSer_.removeUserPortalConfig("jazz");
                TestUserPortalConfigService.this.restartTransaction();
                TestCase.assertNull((Object)TestUserPortalConfigService.this.userPortalConfigSer_.getUserPortalConfig("jazz", "root"));
            }
        }.execute("root");
    }

    public void testRootGetMakableNavigations() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                HashSet navigations = new HashSet(TestUserPortalConfigService.this.userPortalConfigSer_.getMakableNavigations("root", false));
                Set expectedNavigations = Tools.toSet((Object[])new String[]{"/platform/users", "/platform", "/platform/guests", "/platform/administrators", "/organization", "/organization/management", "/organization/management/executive-board"});
                for (String expectedNavigation : expectedNavigations) {
                    TestCase.assertTrue((String)("Navigation not found : " + expectedNavigation), (boolean)navigations.contains(expectedNavigation));
                }
            }
        }.execute(null);
    }

    public void testJohnGetMakableNavigations() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                HashSet navigations = new HashSet(TestUserPortalConfigService.this.userPortalConfigSer_.getMakableNavigations("john", false));
                Set expectedNavigations = Tools.toSet((Object[])new String[]{"/organization/management/executive-board"});
                TestCase.assertEquals((Object)expectedNavigations, navigations);
            }
        }.execute(null);
    }

    public void testMaryGetMakableNavigations() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                HashSet navigations = new HashSet(TestUserPortalConfigService.this.userPortalConfigSer_.getMakableNavigations("mary", false));
                Set expectedNavigations = Collections.emptySet();
                TestCase.assertEquals(expectedNavigations, navigations);
            }
        }.execute(null);
    }

    public void testHasMakableNavigations() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals((boolean)true, (boolean)TestUserPortalConfigService.this.userPortalConfigSer_.hasMakableNavigations("root", true));
                TestCase.assertEquals((boolean)false, (boolean)TestUserPortalConfigService.this.userPortalConfigSer_.hasMakableNavigations(null, true));
                TestCase.assertEquals((boolean)true, (boolean)TestUserPortalConfigService.this.userPortalConfigSer_.hasMakableNavigations("john", true));
            }
        }.execute(null);
    }

    public void testRootGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals((String)"group::/platform/administrators::newAccount", (String)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount")).getKey().format());
                TestCase.assertEquals((String)"group::/organization/management/executive-board::newStaff", (String)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff")).getKey().format());
            }
        }.execute("root");
    }

    public void testJohnGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals(null, (Object)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount")));
                TestCase.assertEquals((String)"group::/organization/management/executive-board::newStaff", (String)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff")).getKey().format());
            }
        }.execute("john");
    }

    public void testMaryGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals(null, (Object)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount")));
                TestCase.assertEquals(null, (Object)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff")));
            }
        }.execute("mary");
    }

    public void testAnonymousGetPage() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertEquals(null, (Object)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/platform/administrators::newAccount")));
                TestCase.assertEquals(null, (Object)TestUserPortalConfigService.this.userPortalConfigSer_.getPage(PageKey.parse((String)"group::/organization/management/executive-board::newStaff")));
            }
        }.execute(null);
    }

    public void testOverwriteUserLayout() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                PortalConfig cfg = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, "overwritelayout");
                TestCase.assertNotNull((Object)cfg);
                Container container = cfg.getPortalLayout();
                TestCase.assertNotNull((Object)container);
                TestCase.assertEquals((int)2, (int)container.getChildren().size());
                TestCase.assertTrue((boolean)(container.getChildren().get(0) instanceof PageBody));
                TestCase.assertTrue((((Application)container.getChildren().get(1)).getType() == ApplicationType.PORTLET ? 1 : 0) != 0);
                Application pa = (Application)container.getChildren().get(1);
                ApplicationState state = pa.getState();
                TestCase.assertEquals((String)"overwrite_application_ref/overwrite_portlet_ref", (String)TestUserPortalConfigService.this.layoutService.getId(state));
            }
        }.execute(null);
    }

    public void testUserTemplate() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                TestCase.assertNull((Object)TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, "user"));
                TestCase.assertNull((Object)TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, "julien"));
                UserHandler userHandler = TestUserPortalConfigService.this.orgService_.getUserHandler();
                User user = userHandler.createUserInstance("julien");
                user.setPassword("default");
                user.setFirstName("default");
                user.setLastName("default");
                user.setEmail("exo@exoportal.org");
                userHandler.createUser(user, true);
                PortalConfig cfg = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.USER_TYPE, "julien");
                TestCase.assertNotNull((Object)cfg);
                Container container = cfg.getPortalLayout();
                TestCase.assertNotNull((Object)container);
                TestCase.assertEquals((int)2, (int)container.getChildren().size());
                TestCase.assertTrue((boolean)(container.getChildren().get(0) instanceof PageBody));
                TestCase.assertTrue((((Application)container.getChildren().get(1)).getType() == ApplicationType.PORTLET ? 1 : 0) != 0);
                Application pa = (Application)container.getChildren().get(1);
                ApplicationState state = pa.getState();
                TestCase.assertEquals((String)"foo/bar", (String)TestUserPortalConfigService.this.layoutService.getId(pa.getState()));
            }
        }.execute(null);
    }

    public void testGroupTemplate() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                String groupName = "groupTest";
                TestCase.assertNull((Object)TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, groupName));
                GroupHandler groupHandler = TestUserPortalConfigService.this.orgService_.getGroupHandler();
                Group group = groupHandler.createGroupInstance();
                group.setGroupName(groupName);
                group.setDescription("this is a group for test");
                groupHandler.addChild(null, group, true);
                PortalConfig cfg = TestUserPortalConfigService.this.layoutService.getPortalConfig(PortalConfig.GROUP_TYPE, "/" + groupName);
                TestCase.assertNotNull((Object)cfg);
                Container container = cfg.getPortalLayout();
                TestCase.assertNotNull((Object)container);
                TestCase.assertEquals((int)4, (int)container.getChildren().size());
                TestCase.assertTrue((boolean)(container.getChildren().get(2) instanceof PageBody));
                TestCase.assertTrue((((Application)container.getChildren().get(1)).getType() == ApplicationType.PORTLET ? 1 : 0) != 0);
                groupHandler.removeGroup(group, true);
            }
        }.execute(null);
    }

    public void testGetPortalSiteRootNodeAndFirstAllowedPageNode() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                String siteName = "classic";
                MockHttpServletRequest httpRequest = new MockHttpServletRequest("/portal/classic", null, 0, "GET", null);
                UserNode rootNode = TestUserPortalConfigService.this.userPortalConfigSer_.getPortalSiteRootNode(siteName, SiteType.PORTAL.getName(), (HttpServletRequest)httpRequest);
                TestCase.assertNotNull((Object)rootNode);
            }
        }.execute(null);
    }

    public void testGetFirstAllowedPageNode() {
        new UnitTest(){

            @Override
            public void execute() throws Exception {
                String siteName = "classic";
                MockHttpServletRequest httpRequest = new MockHttpServletRequest("/portal/classic", null, 0, null, null);
                String path = TestUserPortalConfigService.this.userPortalConfigSer_.getFirstAllowedPageNode(siteName, SiteType.PORTAL.getName(), "home", (HttpServletRequest)httpRequest);
                TestCase.assertNotNull((Object)path);
            }
        }.execute(null);
    }

    private abstract class UnitTest {
        private UnitTest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void execute(String userId) {
            Exception failure = null;
            TestUserPortalConfigService.this.begin();
            ConversationState conversationState = null;
            if (userId != null) {
                try {
                    conversationState = new ConversationState(TestUserPortalConfigService.this.authenticator.createIdentity(userId));
                }
                catch (Exception e) {
                    failure = e;
                }
            }
            if (failure == null) {
                ConversationState.setCurrent(conversationState);
                try {
                    this.execute();
                }
                catch (Exception e) {
                    failure = e;
                }
                finally {
                    ConversationState.setCurrent(null);
                    TestUserPortalConfigService.this.end();
                }
            }
            if (failure != null) {
                AssertionFailedError err = new AssertionFailedError();
                err.initCause((Throwable)failure);
                throw err;
            }
        }

        protected abstract void execute() throws Exception;
    }
}

