/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.branding.BrandingRestResourcesV1;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.portal.branding.model.Favicon;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.portal.rest.services.BaseRestServicesTestCase;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.json.JSONObject;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BrandingRestResourcesTest
extends BaseRestServicesTestCase {
    private BrandingService originalBrandingService;
    private BrandingService brandingService;
    private FileService fileService;
    private SettingService settingService;

    @Override
    protected Class<?> getComponentClass() {
        return BrandingRestResourcesV1.class;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.brandingService = (BrandingService)Mockito.mock(BrandingService.class);
        this.fileService = (FileService)Mockito.mock(FileService.class);
        this.settingService = (SettingService)Mockito.mock(SettingService.class);
        this.originalBrandingService = (BrandingService)this.getContainer().unregisterComponent(BrandingService.class).getComponentInstance();
        this.getContainer().registerComponentInstance(BrandingService.class, (Object)this.brandingService);
        this.getContainer().registerComponentInstance((Object)"FileService", (Object)this.fileService);
        this.getContainer().registerComponentInstance((Object)"SettingService", (Object)this.settingService);
    }

    @Override
    public void tearDown() throws Exception {
        this.getContainer().unregisterComponent((Object)"FileService");
        this.getContainer().unregisterComponent((Object)"SettingService");
        this.getContainer().unregisterComponent(BrandingService.class);
        this.getContainer().registerComponentInstance(BrandingService.class, (Object)this.originalBrandingService);
        super.tearDown();
    }

    public void testGetBrandingInformation() throws Exception {
        String path = "/v1/platform/branding/";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        Branding branding = new Branding();
        branding.setCompanyName("test1");
        Mockito.when((Object)this.brandingService.getBrandingInformation(false)).thenReturn((Object)branding);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        BrandingRestResourcesTest.assertEquals((int)200, (int)resp.getStatus());
        Object entity = resp.getEntity();
        BrandingRestResourcesTest.assertNotNull((Object)entity);
        BrandingRestResourcesTest.assertTrue((boolean)(entity instanceof Branding));
        Branding brandingResp = (Branding)entity;
        BrandingRestResourcesTest.assertEquals((String)"test1", (String)brandingResp.getCompanyName());
    }

    public void testUpdateBrandingInformation() throws Exception {
        String path = "/v1/platform/branding/";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "PUT", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        Branding branding = new Branding();
        branding.setCompanyName("test1");
        JSONObject jsonBranding = new JSONObject();
        jsonBranding.put("companyName", (Object)branding.getCompanyName());
        ArgumentCaptor brandingArgumentCaptor = ArgumentCaptor.forClass(Branding.class);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", Arrays.asList("application/json"));
        ContainerResponse resp = this.launcher.service("PUT", path, "", headers, jsonBranding.toString().getBytes(), envctx);
        BrandingRestResourcesTest.assertEquals((int)204, (int)resp.getStatus());
        Object entity = resp.getEntity();
        BrandingRestResourcesTest.assertNull((Object)entity);
        ((BrandingService)Mockito.verify((Object)this.brandingService, (VerificationMode)Mockito.times((int)1))).updateBrandingInformation((Branding)brandingArgumentCaptor.capture());
        BrandingRestResourcesTest.assertNotNull((Object)brandingArgumentCaptor);
        Branding caturedBranding = (Branding)brandingArgumentCaptor.getValue();
        BrandingRestResourcesTest.assertEquals((String)"test1", (String)caturedBranding.getCompanyName());
    }

    public void testGetBrandingFavicon() throws Exception {
        String path = "/v1/platform/branding/favicon?v=test";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        BrandingRestResourcesTest.assertEquals((int)404, (int)resp.getStatus());
        Favicon favicon = new Favicon(null, 5L, new byte[]{1, 2, 3}, 0L, 0L);
        Mockito.when((Object)this.brandingService.getFavicon()).thenReturn((Object)favicon);
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        BrandingRestResourcesTest.assertEquals((int)200, (int)resp.getStatus());
        Object entity = resp.getEntity();
        BrandingRestResourcesTest.assertNotNull((Object)entity);
        BrandingRestResourcesTest.assertTrue((boolean)(entity instanceof ByteArrayInputStream));
        BrandingRestResourcesTest.assertEquals((int)3, (int)((ByteArrayInputStream)entity).available());
    }

    public void testGetBrandingLogo() throws Exception {
        String path = "/v1/platform/branding/logo?v=test";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        BrandingRestResourcesTest.assertEquals((int)404, (int)resp.getStatus());
        Logo logo = new Logo(null, 5L, new byte[]{1, 2, 3}, 0L, 0L);
        Mockito.when((Object)this.brandingService.getLogo()).thenReturn((Object)logo);
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        BrandingRestResourcesTest.assertEquals((int)200, (int)resp.getStatus());
        Object entity = resp.getEntity();
        BrandingRestResourcesTest.assertNotNull((Object)entity);
        BrandingRestResourcesTest.assertTrue((boolean)(entity instanceof ByteArrayInputStream));
        BrandingRestResourcesTest.assertEquals((int)3, (int)((ByteArrayInputStream)entity).available());
    }
}

