/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.Arrays;
import org.exoplatform.portal.config.DefaultGroupVisibilityPlugin;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultGroupVisibilityPluginTest {
    @Test
    public void shouldHasPermissionWhenUserIsSuperUser() {
        UserACL userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)userACL.getSuperUser()).thenReturn((Object)"john");
        DefaultGroupVisibilityPlugin plugin = new DefaultGroupVisibilityPlugin(userACL);
        Identity userIdentity = new Identity("john", Arrays.asList(new MembershipEntry("/platform/users", "manager")));
        GroupImpl groupPlatform = new GroupImpl();
        groupPlatform.setId("/platform");
        GroupImpl groupPlatformUsers = new GroupImpl();
        groupPlatformUsers.setId("/platform/users");
        boolean hasPermissionOnPlatform = plugin.hasPermission(userIdentity, (Group)groupPlatform);
        boolean hasPermissionOnPlatformUsers = plugin.hasPermission(userIdentity, (Group)groupPlatformUsers);
        Assert.assertTrue((boolean)hasPermissionOnPlatform);
        Assert.assertTrue((boolean)hasPermissionOnPlatformUsers);
    }

    @Test
    public void shouldHasPermissionWhenUserIsPlatformAdministrator() {
        UserACL userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)userACL.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)userACL.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        DefaultGroupVisibilityPlugin plugin = new DefaultGroupVisibilityPlugin(userACL);
        Identity userIdentity = new Identity("john", Arrays.asList(new MembershipEntry("/platform/administrators", "manager")));
        GroupImpl groupPlatform = new GroupImpl();
        groupPlatform.setId("/platform");
        GroupImpl groupPlatformUsers = new GroupImpl();
        groupPlatformUsers.setId("/platform/users");
        boolean hasPermissionOnPlatform = plugin.hasPermission(userIdentity, (Group)groupPlatform);
        boolean hasPermissionOnPlatformUsers = plugin.hasPermission(userIdentity, (Group)groupPlatformUsers);
        Assert.assertTrue((boolean)hasPermissionOnPlatform);
        Assert.assertTrue((boolean)hasPermissionOnPlatformUsers);
    }

    @Test
    public void shouldHasPermissionWhenUserIsInGivenGroup() {
        UserACL userACL = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)userACL.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)userACL.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        DefaultGroupVisibilityPlugin plugin = new DefaultGroupVisibilityPlugin(userACL);
        Identity userIdentity = new Identity("john", Arrays.asList(new MembershipEntry("/platform/developers", "manager"), new MembershipEntry("/platform/testers", "member"), new MembershipEntry("/organization/rh", "*")));
        GroupImpl groupPlatform = new GroupImpl();
        groupPlatform.setId("/platform");
        GroupImpl groupPlatformDevelopers = new GroupImpl();
        groupPlatformDevelopers.setId("/platform/developers");
        GroupImpl groupPlatformTesters = new GroupImpl();
        groupPlatformTesters.setId("/platform/testers");
        GroupImpl groupOrganization = new GroupImpl();
        groupOrganization.setId("/organization");
        GroupImpl groupOrganizationRh = new GroupImpl();
        groupOrganizationRh.setId("/organization/rh");
        GroupImpl groupDepartments = new GroupImpl();
        groupDepartments.setId("/departments");
        boolean hasPermissionOnPlatform = plugin.hasPermission(userIdentity, (Group)groupPlatform);
        boolean hasPermissionOnPlatformDevelopers = plugin.hasPermission(userIdentity, (Group)groupPlatformDevelopers);
        boolean hasPermissionOnPlatformTesters = plugin.hasPermission(userIdentity, (Group)groupPlatformTesters);
        boolean hasPermissionOnOrganization = plugin.hasPermission(userIdentity, (Group)groupOrganization);
        boolean hasPermissionOnOrganizationRh = plugin.hasPermission(userIdentity, (Group)groupOrganizationRh);
        boolean hasPermissionOnODepartments = plugin.hasPermission(userIdentity, (Group)groupDepartments);
        Assert.assertTrue((boolean)hasPermissionOnPlatform);
        Assert.assertTrue((boolean)hasPermissionOnPlatformDevelopers);
        Assert.assertFalse((boolean)hasPermissionOnPlatformTesters);
        Assert.assertTrue((boolean)hasPermissionOnOrganization);
        Assert.assertTrue((boolean)hasPermissionOnOrganizationRh);
        Assert.assertFalse((boolean)hasPermissionOnODepartments);
    }
}

