/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.services.resources.LocaleConfigService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewPortalConfigListenerTest {
    @Mock
    private UserPortalConfigService owner;
    @Mock
    private LayoutService layoutService;
    @Mock
    private ConfigurationManager configurationManager;
    @Mock
    private NavigationService navigationService;
    @Mock
    private InitParams initParams;
    @Mock
    private DescriptionStorage descriptionStorage;
    @Mock
    private UserACL userACL;
    @Mock
    private LocaleConfigService localeConfigService;

    @Test
    public void testInitPageDB() throws Exception {
        ValueParam valueParam = new ValueParam();
        valueParam.setName("meta.portal");
        valueParam.setValue("classic");
        Mockito.when((Object)this.initParams.getValueParam("meta.portal")).thenReturn((Object)valueParam);
        NewPortalConfigListener newPortalConfigListener = new NewPortalConfigListener(this.owner, this.layoutService, this.configurationManager, this.initParams, this.navigationService, this.descriptionStorage, this.userACL, this.localeConfigService);
        newPortalConfigListener.createdOwners.add("global");
        HashSet<String> predefinedOwner = new HashSet<String>();
        predefinedOwner.add("global");
        NewPortalConfig newPortalConfig = (NewPortalConfig)Mockito.mock(NewPortalConfig.class);
        Mockito.when((Object)newPortalConfig.getPredefinedOwner()).thenReturn(predefinedOwner);
        Mockito.when((Object)newPortalConfig.getImportMode()).thenReturn((Object)"overwrite");
        Mockito.when((Object)newPortalConfig.getOwnerType()).thenReturn((Object)PortalConfig.PORTAL_TYPE);
        PageContext pageContext = (PageContext)Mockito.mock(PageContext.class);
        ArrayList<PageContext> allPages = new ArrayList<PageContext>();
        allPages.add(pageContext);
        Mockito.when((Object)this.layoutService.findPages((SiteKey)Mockito.any(SiteKey.class))).thenReturn(allPages);
        newPortalConfigListener.initPageDB(newPortalConfig);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)1))).removePages((SiteKey)Mockito.any());
        Mockito.reset((Object[])new LayoutService[]{this.layoutService});
        Mockito.when((Object)newPortalConfig.getImportMode()).thenReturn((Object)"merge");
        newPortalConfigListener.initPageDB(newPortalConfig);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)0))).removePages((SiteKey)Mockito.any());
    }

    @Test
    public void testReloadConfig() throws Exception {
        ValueParam valueParam = new ValueParam();
        valueParam.setName("meta.portal");
        valueParam.setValue("classic");
        Mockito.when((Object)this.initParams.getValueParam("meta.portal")).thenReturn((Object)valueParam);
        HashSet<String> predefinedOwner = new HashSet<String>();
        predefinedOwner.add("global");
        NewPortalConfig newPortalConfig = (NewPortalConfig)Mockito.mock(NewPortalConfig.class);
        Mockito.when((Object)newPortalConfig.getPredefinedOwner()).thenReturn(predefinedOwner);
        Mockito.when((Object)newPortalConfig.isPredefinedOwner(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)newPortalConfig.getImportMode()).thenReturn((Object)"insert", (Object[])new String[]{"merge"});
        Mockito.when((Object)newPortalConfig.getOverrideMode()).thenReturn((Object)false);
        Mockito.when((Object)newPortalConfig.getOwnerType()).thenReturn((Object)PortalConfig.PORTAL_TYPE);
        String location = "war:/conf/webapps/test-location/portal";
        Mockito.when((Object)newPortalConfig.getLocation()).thenReturn((Object)location);
        Mockito.when((Object)newPortalConfig.getTemplateLocation()).thenReturn((Object)location);
        ((NewPortalConfig)Mockito.doCallRealMethod().when((Object)newPortalConfig)).setImportMode(Mockito.anyString());
        ((NewPortalConfig)Mockito.doCallRealMethod().when((Object)newPortalConfig)).setOverrideMode(Mockito.anyBoolean());
        ArrayList<NewPortalConfig> configs = new ArrayList<NewPortalConfig>();
        configs.add(newPortalConfig);
        Mockito.when((Object)this.initParams.getObjectParamValues(NewPortalConfig.class)).thenReturn(configs);
        Mockito.when((Object)this.layoutService.getPortalConfig("portal", "global")).thenReturn((Object)new PortalConfig());
        Mockito.mockStatic(IOUtil.class);
        Mockito.when((Object)IOUtil.getStreamContentAsString((InputStream)((InputStream)Mockito.any()))).thenReturn(null, (Object[])new String[]{null, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<page-set xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.exoplatform.org/xml/ns/gatein_objects_1_8 http://www.exoplatform.org/xml/ns/gatein_objects_1_8\"\n  xmlns=\"http://www.exoplatform.org/xml/ns/gatein_objects_1_8\"><page>\n    <name>profile</name>\n    <title>Profile</title>\n    <access-permissions>*:/platform/users;*:/platform/externals</access-permissions>\n    <edit-permission>manager:/platform/administrators</edit-permission></page></page-set>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node-navigation>\n  <priority>2</priority>\n  <page-nodes>\n    <node>\n      <name>profile</name>\n      <label>#{portal.global.profile}</label>\n      <visibility>SYSTEM</visibility>\n      <page-reference>portal::global::profile</page-reference>\n    </node>\n  </page-nodes>\n</node-navigation>"});
        NewPortalConfigListener newPortalConfigListener = new NewPortalConfigListener(this.owner, this.layoutService, this.configurationManager, this.initParams, this.navigationService, this.descriptionStorage, this.userACL, this.localeConfigService);
        newPortalConfigListener.createdOwners.add("global");
        try {
            newPortalConfigListener.reloadConfig("portal", "global", location, "merge", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)1))).save((PageContext)Mockito.any(PageContext.class), (Page)Mockito.any());
        ((NavigationService)Mockito.verify((Object)this.navigationService, (VerificationMode)Mockito.times((int)1))).saveNavigation((NavigationContext)Mockito.any());
    }
}

