/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.AbstractDAOTest;
import org.exoplatform.portal.mop.dao.SiteDAO;

public class SiteDAOTest
extends AbstractDAOTest {
    private SiteDAO siteDAO;

    @Override
    protected void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.siteDAO = (SiteDAO)this.getContainer().getComponentInstanceOfType(SiteDAO.class);
        this.siteDAO.deleteAll();
    }

    @Override
    protected void tearDown() throws Exception {
        this.siteDAO.deleteAll();
        super.tearDown();
        this.end();
    }

    public void testCreate() {
        SiteEntity siteEntity = this.createSiteEntity("test", SiteType.PORTAL);
        this.siteDAO.create((Object)siteEntity);
        this.restartTransaction();
        SiteEntity result = (SiteEntity)this.siteDAO.find((Serializable)siteEntity.getId());
        SiteDAOTest.assertNotNull((Object)result);
        this.assertSite(siteEntity, result);
        this.siteDAO.delete((Object)siteEntity);
    }

    public void testFind() {
        SiteEntity siteEntity = this.createSiteEntity("test1", SiteType.PORTAL);
        siteEntity.setDisplayed(true);
        siteEntity.setDisplayOrder(1);
        this.siteDAO.create((Object)siteEntity);
        this.restartTransaction();
        SiteEntity result = this.siteDAO.findByKey(new SiteKey(siteEntity.getSiteType(), siteEntity.getName()));
        SiteDAOTest.assertNotNull((Object)result);
        this.assertSite(siteEntity, result);
        List results = this.siteDAO.findByType(siteEntity.getSiteType());
        SiteDAOTest.assertEquals((int)1, (int)results.size());
        List keys = this.siteDAO.findSiteKey(siteEntity.getSiteType());
        SiteDAOTest.assertEquals((int)1, (int)keys.size());
        SiteEntity siteEntity2 = this.createSiteEntity("test2", SiteType.PORTAL);
        siteEntity2.setDisplayed(false);
        siteEntity2.setDisplayOrder(4);
        this.siteDAO.create((Object)siteEntity2);
        this.restartTransaction();
        SiteEntity siteEntity3 = this.createSiteEntity("test3", SiteType.GROUP);
        siteEntity3.setDisplayed(true);
        siteEntity3.setDisplayOrder(3);
        this.siteDAO.create((Object)siteEntity3);
        this.restartTransaction();
        SiteEntity siteEntity4 = this.createSiteEntity("test4", SiteType.USER);
        siteEntity4.setDisplayed(true);
        siteEntity4.setDisplayOrder(2);
        this.siteDAO.create((Object)siteEntity4);
        this.restartTransaction();
        SiteFilter filter = new SiteFilter();
        filter.setFilterByDisplayed(true);
        filter.setDisplayed(false);
        List siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)1, (int)siteKeys.size());
        filter.setDisplayed(true);
        filter.setSiteType(SiteType.PORTAL);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)1, (int)siteKeys.size());
        SiteDAOTest.assertEquals((String)siteEntity.getName(), (String)((SiteKey)siteKeys.get(0)).getName());
        filter.setExcludedSiteName("test1");
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)0, (int)siteKeys.size());
        filter.setExcludedSiteName(null);
        filter.setSiteType(SiteType.GROUP);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)1, (int)siteKeys.size());
        SiteDAOTest.assertEquals((String)siteEntity3.getName(), (String)((SiteKey)siteKeys.get(0)).getName());
        filter.setSiteType(null);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)3, (int)siteKeys.size());
        filter.setExcludedSiteType(SiteType.PORTAL);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)2, (int)siteKeys.size());
        SiteDAOTest.assertEquals((String)siteEntity4.getName(), (String)((SiteKey)siteKeys.get(1)).getName());
        filter.setFilterByDisplayed(false);
        filter.setSortByDisplayOrder(true);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)2, (int)siteKeys.size());
        SiteDAOTest.assertEquals((String)siteEntity3.getName(), (String)((SiteKey)siteKeys.get(1)).getName());
        siteEntity3.setDisplayOrder(2);
        this.siteDAO.update((Object)siteEntity3);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)2, (int)siteKeys.size());
        SiteDAOTest.assertEquals((String)siteEntity4.getName(), (String)((SiteKey)siteKeys.get(1)).getName());
        siteEntity3.setName("/spaces/test3");
        this.siteDAO.update((Object)siteEntity3);
        filter.setExcludeSpaceSites(true);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)1, (int)siteKeys.size());
        SiteDAOTest.assertEquals((String)siteEntity4.getName(), (String)((SiteKey)siteKeys.get(0)).getName());
        filter.setExcludedSiteType(null);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)3, (int)siteKeys.size());
        filter.setExcludeSpaceSites(false);
        siteKeys = this.siteDAO.findSitesKeys(filter);
        SiteDAOTest.assertEquals((int)4, (int)siteKeys.size());
        this.siteDAO.delete((Object)siteEntity);
        this.siteDAO.delete((Object)siteEntity2);
    }

    private void assertSite(SiteEntity expected, SiteEntity siteEntity) {
        SiteDAOTest.assertEquals((String)expected.getDescription(), (String)siteEntity.getDescription());
        SiteDAOTest.assertEquals((Object)expected.getId(), (Object)siteEntity.getId());
        SiteDAOTest.assertEquals((String)expected.getLabel(), (String)siteEntity.getLabel());
        SiteDAOTest.assertEquals((String)expected.getName(), (String)siteEntity.getName());
        SiteDAOTest.assertEquals((String)expected.getSiteBody(), (String)siteEntity.getSiteBody());
        SiteDAOTest.assertEquals((String)expected.getSkin(), (String)siteEntity.getSkin());
        SiteDAOTest.assertEquals((Object)expected.getSiteType(), (Object)siteEntity.getSiteType());
        SiteDAOTest.assertEquals((String)expected.getProperties(), (String)siteEntity.getProperties());
    }

    private SiteEntity createSiteEntity(String siteName, SiteType siteType) {
        SiteEntity siteEntity = new SiteEntity();
        siteEntity.setDescription(siteName + "Desc");
        siteEntity.setLabel(siteName + "Label");
        siteEntity.setLocale(siteName + "Locale");
        siteEntity.setName(siteName);
        siteEntity.setSiteBody(siteName + "Body");
        siteEntity.setSiteType(siteType);
        siteEntity.setSkin(siteName + "Skin");
        siteEntity.setProperties(siteName + "Properties");
        return siteEntity;
    }
}

