/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.settings.rest.SettingEntity;
import org.exoplatform.settings.rest.SettingValueEntity;

@Path(value="/v1/settings")
@Tag(name="/v1/settings", description="Managing settings")
public class SettingResource
implements ResourceContainer {
    private SettingService settingService;
    private UserACL userACL;

    public SettingResource(SettingService settingService, UserACL userACL) {
        this.settingService = settingService;
        this.userACL = userACL;
    }

    @Path(value="/{context}/{scope}/{settingKey}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific setting value", description="Gets a specific setting value", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User does not have permissions to get it"), @ApiResponse(responseCode="404", description="Setting does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSetting(@Parameter(description="Context - Format 'contextName,contextId' where 'contextId' is optional. Example: GLOBAL or USER,john", required=true) @PathParam(value="context") String contextParams, @Parameter(description="Scope - Format 'scopeName,scopeId' where 'scopeId' is optional. Example: GLOBAL or APPLICATION,wiki or SPACE,marketing", required=true) @PathParam(value="scope") String scopeParams, @Parameter(description="Setting key", required=true) @PathParam(value="settingKey") String settingKey) {
        if (StringUtils.isEmpty((CharSequence)contextParams) || StringUtils.isEmpty((CharSequence)scopeParams) || StringUtils.isEmpty((CharSequence)settingKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Context, scope and setting key are mandatory").build();
        }
        Context context = this.extractContext(contextParams);
        if (!this.hasPermissions(context)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Scope scope = this.extractScope(scopeParams);
        SettingValue settingValue = this.settingService.get(context, scope, settingKey);
        if (settingValue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        SettingEntity settingEntity = new SettingEntity(context, scope, settingKey, settingValue.getValue().toString());
        return Response.ok((Object)settingEntity, (String)"application/json").build();
    }

    @Path(value="/{context}/{scope}/{settingKey}")
    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Sets a specific setting value", description="Sets a specific setting value", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="User does not have permissions to update it"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response setSetting(@Parameter(description="Context - Format 'contextName,contextId' where 'contextId' is optional. Example: GLOBAL or USER,john", required=true) @PathParam(value="context") String contextParams, @Parameter(description="Scope - Format 'scopeName,scopeId' where 'scopeId' is optional. Example: GLOBAL or APPLICATION,wiki or SPACE,marketing", required=true) @PathParam(value="scope") String scopeParams, @Parameter(description="Setting key", required=true) @PathParam(value="settingKey") String settingKey, @Parameter(description="Setting value", required=true) SettingValueEntity settingValue) {
        if (StringUtils.isEmpty((CharSequence)contextParams) || StringUtils.isEmpty((CharSequence)scopeParams) || StringUtils.isEmpty((CharSequence)settingKey) || settingValue == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Context, scope and setting key and value are mandatory").build();
        }
        Context context = this.extractContext(contextParams);
        if (!this.hasPermissions(context)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Scope scope = this.extractScope(scopeParams);
        this.settingService.set(context, scope, settingKey, SettingValue.create((String)settingValue.getValue()));
        return Response.ok().build();
    }

    private boolean hasPermissions(Context context) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        String currentUser = identity.getUserId();
        if (currentUser != null) {
            return context.getName().toUpperCase().equals(Context.USER.getName()) && (context.getId() == null || currentUser.equals(context.getId())) || this.userACL.isAdministrator(identity);
        }
        return false;
    }

    private Scope extractScope(String scopeParams) {
        String scopeName = scopeParams;
        String scopeId = null;
        int scopeIndex = scopeParams.indexOf(",");
        if (scopeIndex > 0) {
            scopeName = scopeParams.substring(0, scopeIndex);
            scopeId = scopeParams.substring(scopeIndex + 1);
        }
        return new Scope(scopeName, scopeId);
    }

    private Context extractContext(String contextParams) {
        String contextName = contextParams;
        String contextId = null;
        int contextIndex = contextParams.indexOf(",");
        if (contextIndex > 0) {
            contextName = contextParams.substring(0, contextIndex);
            contextId = contextParams.substring(contextIndex + 1);
        }
        if (contextName.equals("GLOBAL")) {
            return Context.GLOBAL;
        }
        return new Context(contextName, contextId);
    }
}

