/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.AbstractSiteDataImportTest;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.storage.PageStorage;

public class TestSiteDataImportInsert
extends AbstractSiteDataImportTest {
    @Override
    protected ImportMode getMode() {
        return ImportMode.INSERT;
    }

    @Override
    protected void afterSecondBootWithOverride(PortalContainer container) throws Exception {
        RequestLifeCycle.begin((ExoContainer)container);
        LayoutService layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        PageStorage pageStorage = (PageStorage)container.getComponentInstanceOfType(PageStorage.class);
        PortalConfig portal = layoutService.getPortalConfig("classic");
        Container layout = portal.getPortalLayout();
        TestSiteDataImportInsert.assertEquals((int)1, (int)layout.getChildren().size());
        Application layoutPortlet = (Application)layout.getChildren().get(0);
        TestSiteDataImportInsert.assertEquals((String)"site1/layout", (String)layoutService.getId(layoutPortlet.getState()));
        PageContext home = pageStorage.loadPage(PageKey.parse((String)"portal::classic::home"));
        TestSiteDataImportInsert.assertNotNull((Object)home);
        TestSiteDataImportInsert.assertEquals((String)"site 1", (String)home.getState().getDisplayName());
        PageContext page1 = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page1"));
        TestSiteDataImportInsert.assertNotNull((Object)page1);
        TestSiteDataImportInsert.assertEquals((String)"site 1", (String)page1.getState().getDisplayName());
        PageContext page2 = pageStorage.loadPage(PageKey.parse((String)"portal::classic::page2"));
        TestSiteDataImportInsert.assertNotNull((Object)page2);
        TestSiteDataImportInsert.assertEquals((String)"site 2", (String)page2.getState().getDisplayName());
        RequestLifeCycle.end();
    }
}

