/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import jakarta.servlet.ServletContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.branding.BrandingServiceImpl;
import org.exoplatform.portal.branding.model.Background;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.portal.branding.model.Favicon;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BrandingServiceImplTest {
    @Test
    public void shouldGetDefaultBrandingInformationWhenNoUpdate() {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        InitParams initParams = new InitParams();
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        ValueParam companyLink = new ValueParam();
        companyLink.setName("exo.branding.company.link");
        companyLink.setValue("https://meeds.io");
        initParams.addParam((Object)companyLink);
        ValueParam siteName = new ValueParam();
        siteName.setName("exo.branding.company.siteName");
        siteName.setValue("Meeds");
        initParams.addParam((Object)siteName);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Branding brandingInformation = brandingService.getBrandingInformation();
        Assert.assertNotNull((Object)brandingInformation);
        Assert.assertEquals((Object)"Default Company Name", (Object)brandingInformation.getCompanyName());
        Assert.assertEquals((Object)"https://meeds.io", (Object)brandingInformation.getCompanyLink());
        Assert.assertEquals((Object)"Meeds", (Object)brandingInformation.getSiteName());
    }

    @Test
    public void shouldGetDefaultBrandingThemeColorsWhenNoUpdate() {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        String primaryColor = "#3f8487";
        String primaryBackground = "#f0f0f0";
        String secondaryColor = "#000000";
        String secondaryBackground = "#e25d5d";
        String borderRadius = "8px";
        InitParams initParams = new InitParams();
        ValuesParam themeStyle = new ValuesParam();
        themeStyle.setName("exo.branding.theme.variables");
        ArrayList<CallSite> variables = new ArrayList<CallSite>();
        variables.add((CallSite)((Object)("primaryColor:" + primaryColor)));
        variables.add((CallSite)((Object)("primaryBackground:" + primaryBackground)));
        variables.add((CallSite)((Object)("secondaryColor:" + secondaryColor)));
        variables.add((CallSite)((Object)("secondaryBackground:" + secondaryBackground)));
        variables.add((CallSite)((Object)("borderRadius:" + borderRadius)));
        themeStyle.setValues(variables);
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        initParams.addParam((Object)themeStyle);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        brandingService.start();
        Branding brandingInformation = brandingService.getBrandingInformation();
        Assert.assertNotNull((Object)brandingInformation);
        Assert.assertNotNull((String)"Default Theme style shouldn't be null", (Object)brandingInformation.getThemeStyle());
        Assert.assertEquals((long)5L, (long)brandingInformation.getThemeStyle().size());
        Assert.assertEquals((Object)primaryColor, brandingInformation.getThemeStyle().get("primaryColor"));
        Assert.assertEquals((Object)primaryBackground, brandingInformation.getThemeStyle().get("primaryBackground"));
        Assert.assertEquals((Object)secondaryColor, brandingInformation.getThemeStyle().get("secondaryColor"));
        Assert.assertEquals((Object)secondaryBackground, brandingInformation.getThemeStyle().get("secondaryBackground"));
        Assert.assertEquals((Object)borderRadius, brandingInformation.getThemeStyle().get("borderRadius"));
    }

    @Test
    public void shouldGetSavedBrandingThemeColorsWhenUpdate() {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        String primaryColorNewValue = "#3f8488";
        String primaryBackgroundNewValue = "#f0f0f1";
        String secondaryColorNewValue = "#000001";
        String secondaryBackgroundNewValue = "#e25d5e";
        String borderRadiusNewValue = "12px";
        Mockito.when((Object)settingService.get(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "primaryColor")).thenReturn((Object)SettingValue.create((String)primaryColorNewValue));
        Mockito.when((Object)settingService.get(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "primaryBackground")).thenReturn((Object)SettingValue.create((String)primaryBackgroundNewValue));
        Mockito.when((Object)settingService.get(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "secondaryColor")).thenReturn((Object)SettingValue.create((String)secondaryColorNewValue));
        Mockito.when((Object)settingService.get(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "secondaryBackground")).thenReturn((Object)SettingValue.create((String)secondaryBackgroundNewValue));
        Mockito.when((Object)settingService.get(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "borderRadius")).thenReturn((Object)SettingValue.create((String)borderRadiusNewValue));
        String primaryColor = "#3f8487";
        String primaryBackground = "#f0f0f0";
        String secondaryColor = "#000000";
        String secondaryBackground = "#e25d5d";
        String borderRadius = "8px";
        InitParams initParams = new InitParams();
        ValuesParam themeStyle = new ValuesParam();
        themeStyle.setName("exo.branding.theme.variables");
        ArrayList<CallSite> variables = new ArrayList<CallSite>();
        variables.add((CallSite)((Object)("primaryColor:" + primaryColor)));
        variables.add((CallSite)((Object)("primaryBackground:" + primaryBackground)));
        variables.add((CallSite)((Object)("secondaryColor:" + secondaryColor)));
        variables.add((CallSite)((Object)("secondaryBackground:" + secondaryBackground)));
        variables.add((CallSite)((Object)("borderRadius:" + borderRadius)));
        themeStyle.setValues(variables);
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        initParams.addParam((Object)themeStyle);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        brandingService.start();
        Branding brandingInformation = brandingService.getBrandingInformation();
        Assert.assertNotNull((Object)brandingInformation);
        Assert.assertNotNull((String)"Default Theme colors shouldn't be null", (Object)brandingInformation.getThemeStyle());
        Assert.assertEquals((long)5L, (long)brandingInformation.getThemeStyle().size());
        Assert.assertEquals((Object)primaryColorNewValue, brandingInformation.getThemeStyle().get("primaryColor"));
        Assert.assertEquals((Object)primaryBackgroundNewValue, brandingInformation.getThemeStyle().get("primaryBackground"));
        Assert.assertEquals((Object)secondaryColorNewValue, brandingInformation.getThemeStyle().get("secondaryColor"));
        Assert.assertEquals((Object)secondaryBackgroundNewValue, brandingInformation.getThemeStyle().get("secondaryBackground"));
        Assert.assertEquals((Object)borderRadiusNewValue, brandingInformation.getThemeStyle().get("borderRadius"));
    }

    @Test
    public void shouldGetUpdatedBrandingInformationWhenInformationUpdated() {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        Mockito.when((Object)settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name")).thenReturn((Object)new SettingValue((Object)"Updated Company Name"));
        Mockito.when((Object)settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link")).thenReturn((Object)new SettingValue((Object)"https://investors.meeds.io"));
        Mockito.when((Object)settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName")).thenReturn((Object)new SettingValue((Object)"Meeds.io"));
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        InitParams initParams = new InitParams();
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        ValueParam companyLink = new ValueParam();
        companyLink.setName("exo.branding.company.link");
        companyLink.setValue("https://meeds.io");
        initParams.addParam((Object)companyLink);
        ValueParam siteName = new ValueParam();
        siteName.setName("exo.branding.company.siteName");
        siteName.setValue("Meeds");
        initParams.addParam((Object)siteName);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Branding brandingInformation = brandingService.getBrandingInformation();
        Assert.assertNotNull((Object)brandingInformation);
        Assert.assertEquals((Object)"Updated Company Name", (Object)brandingInformation.getCompanyName());
        Assert.assertEquals((Object)"https://investors.meeds.io", (Object)brandingInformation.getCompanyLink());
        Assert.assertEquals((Object)"Meeds.io", (Object)brandingInformation.getSiteName());
    }

    @Test
    public void shouldGetBrandingInformationWithoutBinaries() {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        String loginBgPath = "loginBgPath";
        String faviconPath = "faviconPath";
        String logoPath = "logoPath";
        ValueParam logoPathParam = new ValueParam();
        logoPathParam.setName("exo.branding.company.logo");
        logoPathParam.setValue(logoPath);
        initParams.addParam((Object)logoPathParam);
        ValueParam faviconPathParam = new ValueParam();
        faviconPathParam.setName("exo.branding.company.favicon");
        faviconPathParam.setValue(faviconPath);
        initParams.addParam((Object)faviconPathParam);
        ValueParam loginBgPathParam = new ValueParam();
        loginBgPathParam.setName("authentication.background");
        loginBgPathParam.setValue(loginBgPath);
        initParams.addParam((Object)loginBgPathParam);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)container.getPortalContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getResourceAsStream(loginBgPath)).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Mockito.when((Object)context.getResourceAsStream(faviconPath)).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Mockito.when((Object)container.getPortalContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getResourceAsStream(logoPath)).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Assert.assertNotNull((Object)brandingService.getLoginBackgroundPath());
        Assert.assertNotNull((Object)brandingService.getLogoPath());
        Assert.assertNotNull((Object)brandingService.getLoginBackgroundPath());
        Branding branding = brandingService.getBrandingInformation(false);
        Assert.assertNotNull((Object)branding);
        Assert.assertNotNull((Object)branding.getLogo());
        Assert.assertNotNull((Object)branding.getFavicon());
        Assert.assertNotNull((Object)branding.getLoginBackground());
        Assert.assertNull((Object)branding.getLogo().getData());
        Assert.assertNull((Object)branding.getFavicon().getData());
        Assert.assertNull((Object)branding.getLoginBackground().getData());
        branding = brandingService.getBrandingInformation(true);
        Assert.assertNotNull((Object)branding);
        Assert.assertNotNull((Object)branding.getLogo());
        Assert.assertNotNull((Object)branding.getFavicon());
        Assert.assertNotNull((Object)branding.getLoginBackground());
        Assert.assertNotNull((Object)branding.getLogo().getData());
        Assert.assertNotNull((Object)branding.getFavicon().getData());
        Assert.assertNotNull((Object)branding.getLoginBackground().getData());
    }

    @Test
    public void shouldUpdateCompanyNameAndTopBarThemeWhenInformationUpdated() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        InitParams initParams = new InitParams();
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        String primaryColor = "#3f8487";
        String primaryBackground = "#f0f0f0";
        String secondaryColor = "#000000";
        String secondaryBackground = "#e25d5d";
        String borderRadius = "8px";
        String primaryColorNewValue = "#3f8488";
        String primaryBackgroundNewValue = "#f0f0f1";
        Object secondaryColorNewValue = null;
        Object secondaryBackgroundNewValue = null;
        Object borderRadiusNewValue = null;
        ValuesParam themeStyle = new ValuesParam();
        themeStyle.setName("exo.branding.theme.variables");
        ArrayList<CallSite> variables = new ArrayList<CallSite>();
        variables.add((CallSite)((Object)("primaryColor:" + primaryColor)));
        variables.add((CallSite)((Object)("primaryBackground:" + primaryBackground)));
        variables.add((CallSite)((Object)("secondaryColor:" + secondaryColor)));
        variables.add((CallSite)((Object)("secondaryBackground:" + secondaryBackground)));
        variables.add((CallSite)((Object)("borderRadius:" + borderRadius)));
        themeStyle.setValues(variables);
        initParams.addParam((Object)themeStyle);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Branding newBranding = new Branding();
        newBranding.setCompanyName("New Company Name");
        newBranding.setTopBarTheme("Pink");
        newBranding.setThemeStyle(new HashMap());
        newBranding.getThemeStyle().put("primaryColor", primaryColorNewValue);
        newBranding.getThemeStyle().put("primaryBackground", primaryBackgroundNewValue);
        newBranding.getThemeStyle().put("secondaryColor", secondaryColorNewValue);
        newBranding.getThemeStyle().put("secondaryBackground", secondaryBackgroundNewValue);
        newBranding.getThemeStyle().put("borderRadius", borderRadiusNewValue);
        ArgumentCaptor settingContext = ArgumentCaptor.forClass(Context.class);
        ArgumentCaptor settingScope = ArgumentCaptor.forClass(Scope.class);
        ArgumentCaptor settingKey = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor settingValue = ArgumentCaptor.forClass(SettingValue.class);
        brandingService.updateBrandingInformation(newBranding);
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)5))).set((Context)settingContext.capture(), (Scope)settingScope.capture(), (String)settingKey.capture(), (SettingValue)settingValue.capture());
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)1))).remove(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "secondaryColor");
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)1))).remove(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "secondaryBackground");
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)1))).remove(BrandingServiceImpl.BRANDING_CONTEXT, BrandingServiceImpl.BRANDING_SCOPE, "borderRadius");
        List contexts = settingContext.getAllValues();
        List scopes = settingScope.getAllValues();
        List keys = settingKey.getAllValues();
        List values = settingValue.getAllValues();
        Assert.assertEquals((Object)Context.GLOBAL, contexts.get(0));
        Assert.assertEquals((Object)Scope.GLOBAL, scopes.get(0));
        Assert.assertEquals((Object)"exo.branding.company.name", keys.get(0));
        Assert.assertEquals((Object)"New Company Name", (Object)((SettingValue)values.get(0)).getValue());
        Assert.assertEquals((Object)Context.GLOBAL, contexts.get(1));
        Assert.assertEquals((Object)Scope.GLOBAL, scopes.get(1));
        Assert.assertEquals((Object)"bar_navigation_style", keys.get(1));
        Assert.assertEquals((Object)"Pink", (Object)((SettingValue)values.get(1)).getValue());
        Assert.assertEquals((Object)BrandingServiceImpl.BRANDING_CONTEXT, contexts.get(2));
        Assert.assertEquals((Object)BrandingServiceImpl.BRANDING_SCOPE, scopes.get(2));
        Assert.assertEquals((Object)BrandingServiceImpl.BRANDING_CONTEXT, contexts.get(3));
        Assert.assertEquals((Object)BrandingServiceImpl.BRANDING_SCOPE, scopes.get(3));
        String firstThemeColorParam = (String)keys.get(2);
        String firstThemeColorValue = ((SettingValue)values.get(2)).getValue().toString();
        String secondThemeColorParam = (String)keys.get(3);
        String secondThemeColorValue = ((SettingValue)values.get(3)).getValue().toString();
        Assert.assertEquals((Object)"primaryColor", (Object)secondThemeColorParam);
        Assert.assertEquals((Object)"primaryBackground", (Object)firstThemeColorParam);
        Assert.assertEquals((Object)primaryColorNewValue, (Object)secondThemeColorValue);
        Assert.assertEquals((Object)primaryBackgroundNewValue, (Object)firstThemeColorValue);
    }

    @Test
    public void shouldUpdateLogoWhenLogoUpdatedByUploadId() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        FileInfo fileInfo = new FileInfo(Long.valueOf(2L), "myLogo", "image/png", "CompanyBranding", (long)"myLogo".getBytes().length, new Date(), "john", null, false);
        FileItem fileItem = new FileItem(fileInfo, null);
        Mockito.when((Object)fileService.writeFile((FileItem)ArgumentMatchers.any(FileItem.class))).thenReturn((Object)fileItem);
        Mockito.when((Object)fileService.getFileInfo(ArgumentMatchers.anyLong())).thenReturn((Object)fileInfo);
        String uploadId = "1";
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        UploadResource uploadResource = new UploadResource(uploadId);
        URL resource = this.getClass().getResource("/branding/logo.png");
        uploadResource.setStoreLocation(resource.getPath());
        Mockito.when((Object)uploadService.getUploadResource(uploadId)).thenReturn((Object)uploadResource);
        InitParams initParams = new InitParams();
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Branding newBranding = new Branding();
        Logo logo = new Logo();
        logo.setUploadId(uploadId);
        newBranding.setLogo(logo);
        ArgumentCaptor settingContextArgumentCaptor = ArgumentCaptor.forClass(Context.class);
        ArgumentCaptor settingScopeArgumentCaptor = ArgumentCaptor.forClass(Scope.class);
        ArgumentCaptor settingKeyArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor settingValueArgumentCaptor = ArgumentCaptor.forClass(SettingValue.class);
        ArgumentCaptor fileItemArgumentCaptor = ArgumentCaptor.forClass(FileItem.class);
        brandingService.updateBrandingInformation(newBranding);
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)2))).set((Context)settingContextArgumentCaptor.capture(), (Scope)settingScopeArgumentCaptor.capture(), (String)settingKeyArgumentCaptor.capture(), (SettingValue)settingValueArgumentCaptor.capture());
        ((FileService)Mockito.verify((Object)fileService, (VerificationMode)Mockito.times((int)1))).writeFile((FileItem)fileItemArgumentCaptor.capture());
        List contexts = settingContextArgumentCaptor.getAllValues();
        List scopes = settingScopeArgumentCaptor.getAllValues();
        List keys = settingKeyArgumentCaptor.getAllValues();
        List values = settingValueArgumentCaptor.getAllValues();
        Assert.assertEquals((Object)Context.GLOBAL, contexts.get(0));
        Assert.assertEquals((Object)Scope.GLOBAL, scopes.get(0));
        Assert.assertEquals((Object)"exo.branding.company.id", keys.get(0));
        Assert.assertEquals((Object)"2", (Object)((SettingValue)values.get(0)).getValue());
        List fileItems = fileItemArgumentCaptor.getAllValues();
        Assert.assertTrue((boolean)Arrays.equals(IOUtils.toByteArray((URL)resource), ((FileItem)fileItems.get(0)).getAsByte()));
    }

    @Test
    public void shouldUpdateFaviconWhenFaviconUpdatedByUploadId() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        FileInfo fileInfo = new FileInfo(Long.valueOf(2L), "myFavicon", "image/png", "CompanyBranding", (long)"myFavicon".getBytes().length, new Date(), "john", null, false);
        FileItem fileItem = new FileItem(fileInfo, null);
        Mockito.when((Object)fileService.writeFile((FileItem)ArgumentMatchers.any(FileItem.class))).thenReturn((Object)fileItem);
        Mockito.when((Object)fileService.getFileInfo(ArgumentMatchers.anyLong())).thenReturn((Object)fileInfo);
        String uploadId = "1";
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        UploadResource uploadResource = new UploadResource(uploadId);
        URL resource = this.getClass().getResource("/branding/favicon.ico");
        uploadResource.setStoreLocation(resource.getPath());
        Mockito.when((Object)uploadService.getUploadResource(uploadId)).thenReturn((Object)uploadResource);
        InitParams initParams = new InitParams();
        ValueParam companyName = new ValueParam();
        companyName.setName("exo.branding.company.name");
        companyName.setValue("Default Company Name");
        initParams.addParam((Object)companyName);
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Branding newBranding = new Branding();
        Favicon favicon = new Favicon();
        favicon.setUploadId(uploadId);
        newBranding.setFavicon(favicon);
        ArgumentCaptor settingContextArgumentCaptor = ArgumentCaptor.forClass(Context.class);
        ArgumentCaptor settingScopeArgumentCaptor = ArgumentCaptor.forClass(Scope.class);
        ArgumentCaptor settingKeyArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor settingValueArgumentCaptor = ArgumentCaptor.forClass(SettingValue.class);
        ArgumentCaptor fileItemArgumentCaptor = ArgumentCaptor.forClass(FileItem.class);
        brandingService.updateBrandingInformation(newBranding);
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)2))).set((Context)settingContextArgumentCaptor.capture(), (Scope)settingScopeArgumentCaptor.capture(), (String)settingKeyArgumentCaptor.capture(), (SettingValue)settingValueArgumentCaptor.capture());
        ((FileService)Mockito.verify((Object)fileService, (VerificationMode)Mockito.times((int)1))).writeFile((FileItem)fileItemArgumentCaptor.capture());
        List contexts = settingContextArgumentCaptor.getAllValues();
        List scopes = settingScopeArgumentCaptor.getAllValues();
        List keys = settingKeyArgumentCaptor.getAllValues();
        List values = settingValueArgumentCaptor.getAllValues();
        Assert.assertEquals((Object)Context.GLOBAL, contexts.get(0));
        Assert.assertEquals((Object)Scope.GLOBAL, scopes.get(0));
        Assert.assertEquals((Object)"exo.branding.company.favicon.id", keys.get(0));
        Assert.assertEquals((Object)"2", (Object)((SettingValue)values.get(0)).getValue());
        List fileItems = fileItemArgumentCaptor.getAllValues();
        Assert.assertTrue((boolean)Arrays.equals(IOUtils.toByteArray((URL)resource), ((FileItem)fileItems.get(0)).getAsByte()));
    }

    @Test
    public void testGetDefaultLoginBackground() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Assert.assertNull((Object)brandingService.getLoginBackgroundPath());
        String imagePath = "loginBgPath";
        ValueParam loginBgPath = new ValueParam();
        loginBgPath.setName("authentication.background");
        loginBgPath.setValue(imagePath);
        initParams.addParam((Object)loginBgPath);
        brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)container.getPortalContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getResourceAsStream(imagePath)).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Background loginBackground = brandingService.getLoginBackground();
        Assert.assertNotNull((Object)loginBackground);
        Assert.assertEquals((long)3L, (long)loginBackground.getSize());
        Assert.assertNotNull((Object)brandingService.getLoginBackgroundPath());
    }

    @Test
    public void testGetDefaultFavicon() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Assert.assertNull((Object)brandingService.getFaviconPath());
        String imagePath = "faviconPath";
        ValueParam faviconPathParam = new ValueParam();
        faviconPathParam.setName("exo.branding.company.favicon");
        faviconPathParam.setValue(imagePath);
        initParams.addParam((Object)faviconPathParam);
        brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)container.getPortalContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getResourceAsStream(imagePath)).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Favicon favicon = brandingService.getFavicon();
        Assert.assertNotNull((Object)favicon);
        Assert.assertEquals((long)3L, (long)favicon.getSize());
        Assert.assertNotNull((Object)brandingService.getFaviconPath());
    }

    @Test
    public void testGetDefaultLogo() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Assert.assertNull((Object)brandingService.getLogoPath());
        String imagePath = "logoPath";
        ValueParam logoPathParam = new ValueParam();
        logoPathParam.setName("exo.branding.company.logo");
        logoPathParam.setValue(imagePath);
        initParams.addParam((Object)logoPathParam);
        brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)container.getPortalContext()).thenReturn((Object)context);
        Mockito.when((Object)context.getResourceAsStream(imagePath)).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Logo logo = brandingService.getLogo();
        Assert.assertNotNull((Object)logo);
        Assert.assertEquals((long)3L, (long)logo.getSize());
        Assert.assertNotNull((Object)brandingService.getLogoPath());
    }

    @Test
    public void testUpdateLoginBackground() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Assert.assertNull((Object)brandingService.getLoginBackgroundPath());
        String uploadId = "uploadId";
        long fileId = 2L;
        UploadResource uploadResource = new UploadResource(uploadId, "fileName.png");
        uploadResource.setStoreLocation(this.getClass().getClassLoader().getResource("branding/favicon.ico").getPath());
        Mockito.when((Object)uploadService.getUploadResource(uploadId)).thenReturn((Object)uploadResource);
        Mockito.when((Object)fileService.writeFile((FileItem)ArgumentMatchers.any())).thenAnswer(invocation -> {
            FileItem fileItem = (FileItem)invocation.getArgument(0);
            fileItem.getFileInfo().setId(Long.valueOf(fileId));
            return fileItem;
        });
        Background loginBackground = new Background(uploadId, 0L, null, 0L, 0L);
        brandingService.updateLoginBackground(loginBackground);
        ((FileService)Mockito.verify((Object)fileService, (VerificationMode)Mockito.times((int)1))).writeFile((FileItem)ArgumentMatchers.argThat(fileItem -> {
            Assert.assertNotNull((Object)fileItem);
            Assert.assertNotNull((Object)fileItem.getFileInfo());
            Assert.assertEquals((Object)"loginBackground.png", (Object)fileItem.getFileInfo().getName());
            Assert.assertEquals((Object)"image/png", (Object)fileItem.getFileInfo().getMimetype());
            Assert.assertEquals((Object)"CompanyBranding", (Object)fileItem.getFileInfo().getNameSpace());
            return true;
        }));
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"authentication.background"), (SettingValue)ArgumentMatchers.argThat(value -> value != null && value.getValue() != null && StringUtils.equals((CharSequence)value.getValue().toString(), (CharSequence)String.valueOf(fileId))));
    }

    @Test
    public void testRemoveLoginBackground() throws Exception {
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        long fileId = 2L;
        Mockito.when((Object)settingService.get(Context.GLOBAL, Scope.GLOBAL, "authentication.background")).thenReturn((Object)new SettingValue((Object)String.valueOf(fileId)));
        FileItem fileItem = new FileItem(Long.valueOf(fileId), "loginBackground.png", "image/png", "CompanyBranding", 5L, new Date(), "testuser", false, (InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Mockito.when((Object)fileService.getFile(fileId)).thenReturn((Object)fileItem);
        Background loginBackground = new Background("0", 0L, null, 0L, 0L);
        brandingService.updateLoginBackground(loginBackground);
        ((FileService)Mockito.verify((Object)fileService, (VerificationMode)Mockito.times((int)1))).deleteFile(fileId);
        ((SettingService)Mockito.verify((Object)settingService, (VerificationMode)Mockito.times((int)1))).remove(Context.GLOBAL, Scope.GLOBAL, "authentication.background");
    }

    @Test
    public void testUpdateLoginTitle() throws Exception {
        String defaultLoginTitle = "Login Title";
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        ValueParam defaultTitleParam = new ValueParam();
        defaultTitleParam.setName("authentication.title");
        defaultTitleParam.setValue(defaultLoginTitle);
        initParams.addParam((Object)defaultTitleParam);
        Mockito.when((Object)localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.newLocaleConfig(Locale.ENGLISH));
        Mockito.when((Object)localeConfigService.getLocalConfigs()).thenReturn(Arrays.asList(this.newLocaleConfig(Locale.ENGLISH), this.newLocaleConfig(Locale.FRENCH)));
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Assert.assertNotNull((Object)brandingService.getLoginTitle());
        Assert.assertEquals((long)1L, (long)brandingService.getLoginTitle().size());
        Assert.assertEquals((Object)defaultLoginTitle, (Object)brandingService.getLoginTitle(Locale.ENGLISH));
        Assert.assertEquals((Object)defaultLoginTitle, (Object)brandingService.getLoginTitle(Locale.FRENCH));
        HashMap customValues = new HashMap();
        ((SettingService)Mockito.doAnswer(invocation -> {
            customValues.put(invocation.getArgument(2).toString().replace("authentication.title.", ""), ((SettingValue)invocation.getArgument(3, SettingValue.class)).getValue().toString());
            return null;
        }).when((Object)settingService)).set((Context)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_CONTEXT), (Scope)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_SCOPE), (String)ArgumentMatchers.argThat(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"authentication.title.")), (SettingValue)ArgumentMatchers.any());
        Mockito.when((Object)settingService.get((Context)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_CONTEXT), (Scope)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_SCOPE), (String)ArgumentMatchers.argThat(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"authentication.title.")))).thenAnswer(invocation -> {
            String language = invocation.getArgument(2).toString().replace("authentication.title.", "");
            return customValues.containsKey(language) ? SettingValue.create((String)((String)customValues.get(language))) : null;
        });
        ((SettingService)Mockito.doAnswer(invocation -> {
            customValues.remove(invocation.getArgument(2).toString().replace("authentication.title.", ""));
            return null;
        }).when((Object)settingService)).remove((Context)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_CONTEXT), (Scope)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_SCOPE), (String)ArgumentMatchers.argThat(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"authentication.title.")));
        String customLocaleTitle = "FR Title";
        Branding branding = new Branding();
        branding.setLoginTitle(Collections.singletonMap(Locale.FRENCH.getLanguage(), customLocaleTitle));
        brandingService.updateBrandingInformation(branding);
        Assert.assertEquals((long)2L, (long)brandingService.getLoginTitle().size());
        Assert.assertEquals((Object)defaultLoginTitle, (Object)brandingService.getLoginTitle(Locale.ENGLISH));
        Assert.assertEquals((Object)customLocaleTitle, (Object)brandingService.getLoginTitle(Locale.FRENCH));
        branding.setLoginTitle(Collections.singletonMap(Locale.ENGLISH.getLanguage(), ""));
        brandingService.updateBrandingInformation(branding);
        Assert.assertEquals((long)1L, (long)brandingService.getLoginTitle().size());
        Assert.assertEquals((Object)"", (Object)brandingService.getLoginTitle(Locale.ENGLISH));
        Assert.assertEquals((Object)"", (Object)brandingService.getLoginTitle(Locale.FRENCH));
    }

    @Test
    public void testUpdateLoginSubtitle() throws Exception {
        String defaultLoginTitle = "Login Subtitle";
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        FileService fileService = (FileService)Mockito.mock(FileService.class);
        ConfigurationManager configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        InitParams initParams = new InitParams();
        ValueParam defaultTitleParam = new ValueParam();
        defaultTitleParam.setName("authentication.subtitle");
        defaultTitleParam.setValue(defaultLoginTitle);
        initParams.addParam((Object)defaultTitleParam);
        Mockito.when((Object)localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.newLocaleConfig(Locale.ENGLISH));
        Mockito.when((Object)localeConfigService.getLocalConfigs()).thenReturn(Arrays.asList(this.newLocaleConfig(Locale.ENGLISH), this.newLocaleConfig(Locale.FRENCH)));
        BrandingServiceImpl brandingService = this.newBrandingService(settingService, fileService, uploadService, localeConfigService, configurationManager, container, initParams);
        Assert.assertNotNull((Object)brandingService.getLoginSubtitle());
        Assert.assertEquals((long)1L, (long)brandingService.getLoginSubtitle().size());
        Assert.assertEquals((Object)defaultLoginTitle, (Object)brandingService.getLoginSubtitle(Locale.ENGLISH));
        Assert.assertEquals((Object)defaultLoginTitle, (Object)brandingService.getLoginSubtitle(Locale.FRENCH));
        HashMap customValues = new HashMap();
        ((SettingService)Mockito.doAnswer(invocation -> {
            customValues.put(invocation.getArgument(2).toString().replace("authentication.subtitle.", ""), ((SettingValue)invocation.getArgument(3, SettingValue.class)).getValue().toString());
            return null;
        }).when((Object)settingService)).set((Context)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_CONTEXT), (Scope)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_SCOPE), (String)ArgumentMatchers.argThat(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"authentication.subtitle.")), (SettingValue)ArgumentMatchers.any());
        Mockito.when((Object)settingService.get((Context)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_CONTEXT), (Scope)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_SCOPE), (String)ArgumentMatchers.argThat(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"authentication.subtitle.")))).thenAnswer(invocation -> {
            String language = invocation.getArgument(2).toString().replace("authentication.subtitle.", "");
            return customValues.containsKey(language) ? SettingValue.create((String)((String)customValues.get(language))) : null;
        });
        ((SettingService)Mockito.doAnswer(invocation -> {
            customValues.remove(invocation.getArgument(2).toString().replace("authentication.subtitle.", ""));
            return null;
        }).when((Object)settingService)).remove((Context)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_CONTEXT), (Scope)ArgumentMatchers.eq((Object)BrandingServiceImpl.BRANDING_SCOPE), (String)ArgumentMatchers.argThat(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"authentication.subtitle.")));
        String customLocaleTitle = "FR Subtitle";
        Branding branding = new Branding();
        branding.setLoginSubtitle(Collections.singletonMap(Locale.FRENCH.getLanguage(), customLocaleTitle));
        brandingService.updateBrandingInformation(branding);
        Assert.assertEquals((long)2L, (long)brandingService.getLoginSubtitle().size());
        Assert.assertEquals((Object)defaultLoginTitle, (Object)brandingService.getLoginSubtitle(Locale.ENGLISH));
        Assert.assertEquals((Object)customLocaleTitle, (Object)brandingService.getLoginSubtitle(Locale.FRENCH));
        branding.setLoginSubtitle(Collections.singletonMap(Locale.ENGLISH.getLanguage(), ""));
        brandingService.updateBrandingInformation(branding);
        Assert.assertEquals((long)1L, (long)brandingService.getLoginSubtitle().size());
        Assert.assertEquals((Object)"", (Object)brandingService.getLoginSubtitle(Locale.ENGLISH));
        Assert.assertEquals((Object)"", (Object)brandingService.getLoginSubtitle(Locale.FRENCH));
    }

    private LocaleConfigImpl newLocaleConfig(Locale locale) {
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(locale);
        return localeConfig;
    }

    private BrandingServiceImpl newBrandingService(SettingService settingService, FileService fileService, UploadService uploadService, LocaleConfigService localeConfigService, ConfigurationManager configurationManager, PortalContainer container, InitParams initParams) {
        return new BrandingServiceImpl(container, configurationManager, settingService, fileService, uploadService, localeConfigService, (ListenerService)Mockito.mock(ListenerService.class), initParams);
    }
}

